/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.jdbc;

import java.text.MessageFormat;

public class JDBCDriverDefinition
implements Comparable<JDBCDriverDefinition> {
    private String urlPattern = "";
    private String dbName = "";
    private String driverName = "";
    private String defaultDBName = "MYDATABASE";
    private String defaultServer = "localhost";

    public JDBCDriverDefinition(String dbName, String driverName, String urlPattern) {
        this(dbName, driverName, urlPattern, "MYDATABASE", "localhost");
    }

    public JDBCDriverDefinition(String dbName, String driverName, String urlPattern, String defaultDBName) {
        this(dbName, driverName, urlPattern, defaultDBName, "localhost");
    }

    public JDBCDriverDefinition(String dbName, String driverName, String urlPattern, String defaultDBName, String defaultServer) {
        this.dbName = dbName;
        this.driverName = driverName;
        this.urlPattern = urlPattern;
        this.defaultDBName = defaultDBName;
        this.defaultServer = defaultServer;
    }

    public String getUrl(String server, String database) {
        if (database == null || database.trim().length() == 0) {
            database = this.getDefaultDBName();
        }
        database = database.trim();
        if (server == null || server.trim().length() == 0) {
            server = this.getDefaultServer();
        }
        server = server.trim();
        return MessageFormat.format(this.getUrlPattern(), server, database);
    }

    public boolean isAvailable(ClassLoader cl) {
        try {
            Class.forName(this.getDriverName(), false, cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getDefaultDBName() {
        return this.defaultDBName;
    }

    public void setDefaultDBName(String defaultDBName) {
        this.defaultDBName = defaultDBName;
    }

    public String getDefaultServer() {
        return this.defaultServer;
    }

    public String toString() {
        return String.valueOf(this.dbName) + " (" + this.driverName + ")";
    }

    @Override
    public int compareTo(JDBCDriverDefinition o) {
        return ("" + o).compareTo(this.toString());
    }
}

