/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.reader;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.reader.DatasetReaderListener;
import com.jaspersoft.studio.editor.preview.view.control.ReportController;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceUtil;
import net.sf.jasperreports.data.cache.ColumnDataCacheHandler;
import net.sf.jasperreports.eclipse.builder.JasperReportCompiler;
import net.sf.jasperreports.eclipse.builder.JasperReportErrorHandler;
import net.sf.jasperreports.eclipse.builder.Markers;
import net.sf.jasperreports.eclipse.builder.jdt.JRErrorHandler;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JRFiller;
import net.sf.jasperreports.engine.fill.ReportFiller;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class DatasetReader {
    private DataAdapterDescriptor dataAdapterDesc;
    private List<String> columns;
    private JRDesignDataset designDataset;
    private int maxRecords = -1;
    private List<DatasetReaderListener> listeners;
    private boolean running;
    private ReportFiller rf;
    private boolean recalcParameters = false;
    private PropertyChangeListener dveListener = evt -> {
        if (evt.getPropertyName().equals("defaultValueExpression")) {
            this.recalcParameters = true;
        }
    };

    public DatasetReader() {
        this.listeners = new ArrayList<DatasetReaderListener>();
    }

    public static JasperDesign getJasperDesign(JasperReportsConfiguration jConfig) throws IOException, JRException {
        String reportLocation = JaspersoftStudioPlugin.getInstance().getFileLocation("/resources/data.jrxml");
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = new FileInputStream(reportLocation);){
            return JRXmlLoader.load((JasperReportsContext)jConfig, (InputStream)is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void setupDataset(JasperDesign dataJD, JRDesignDataset designDataset, JasperReportsConfiguration jConfig, List<String> columns) throws JRException {
        JRField f;
        int n;
        JRField[] jRFieldArray;
        JRDesignQuery query = new JRDesignQuery();
        if (designDataset.getQuery() != null) {
            query.setLanguage(designDataset.getQuery().getLanguage());
            query.setText(designDataset.getQuery().getText());
        }
        dataJD.setQuery(query);
        dataJD.setLanguage(jConfig.getJasperDesign().getLanguage());
        dataJD.setFilterExpression(designDataset.getFilterExpression());
        ModelUtils.replacePropertiesMap(jConfig.getJasperDesign().getPropertiesMap(), dataJD.getPropertiesMap());
        List parametersList = designDataset.getParametersList();
        for (JRParameter param : parametersList) {
            if (param.isSystemDefined()) continue;
            if (dataJD.getParametersMap().containsKey(param.getName())) {
                dataJD.removeParameter(param.getName());
            }
            dataJD.addParameter(param);
        }
        if (!columns.isEmpty()) {
            JRField[] fields;
            dataJD.getFieldsList().clear();
            dataJD.getFieldsMap().clear();
            jRFieldArray = fields = designDataset.getFields();
            n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                f = jRFieldArray[n2];
                dataJD.addField(f);
                ++n2;
            }
        }
        dataJD.getVariablesList().clear();
        dataJD.getVariablesMap().clear();
        dataJD.getGroupsList().clear();
        dataJD.getMainDesignDataset().getGroupsMap().clear();
        for (JRGroup sf : designDataset.getGroupsList()) {
            JRDesignGroup gr = new JRDesignGroup();
            gr.setName(sf.getName());
            dataJD.addGroup(gr);
        }
        JRVariable[] variables = designDataset.getVariables();
        jRFieldArray = variables;
        n = variables.length;
        int n3 = 0;
        while (n3 < n) {
            block13: {
                f = jRFieldArray[n3];
                try {
                    JRDesignVariable v = new JRDesignVariable();
                    v.setName(f.getName());
                    v.setSystemDefined(f.isSystemDefined());
                    v.setValueClassName(f.getValueClassName());
                    v.setCalculation(f.getCalculationValue());
                    v.setExpression(f.getExpression());
                    v.setInitialValueExpression(f.getInitialValueExpression());
                    v.setIncrementerFactoryClassName(f.getIncrementerFactoryClassName());
                    v.setIncrementType(f.getIncrementTypeValue());
                    if (f.getIncrementGroup() != null) {
                        v.setIncrementGroup((JRGroup)dataJD.getGroupsMap().get(f.getIncrementGroup().getName()));
                    }
                    v.setResetType(f.getResetTypeValue());
                    if (f.getResetGroup() != null) {
                        v.setResetGroup((JRGroup)dataJD.getGroupsMap().get(f.getResetGroup().getName()));
                    }
                    dataJD.addVariable(v);
                }
                catch (JRException e) {
                    if (e.getMessageKey().equals("design.dataset.duplicate.variable")) break block13;
                    e.printStackTrace();
                }
            }
            ++n3;
        }
        dataJD.getSortFieldsList().clear();
        dataJD.getMainDesignDataset().getSortFieldsMap().clear();
        for (JRSortField sf : designDataset.getSortFieldsList()) {
            dataJD.addSortField(sf);
        }
        dataJD.getScriptletsList().clear();
        dataJD.getMainDesignDataset().getScriptletsMap().clear();
        for (JRSortField sf : designDataset.getScriptletsList()) {
            dataJD.addScriptlet((JRScriptlet)sf);
        }
    }

    public static JasperReport compile(JasperReportsConfiguration jConfig, JasperDesign dataJD, IProgressMonitor monitor) throws CoreException, JRException {
        JasperReport jrobj = null;
        IFile f = (IFile)jConfig.get("ifile");
        if (f != null) {
            Markers.deleteMarkers((IResource)f);
            JasperReportCompiler compiler = new JasperReportCompiler();
            compiler.setErrorHandler((JasperReportErrorHandler)new JRErrorHandler(f));
            compiler.setProject(f.getProject());
            jrobj = compiler.compileReport((JasperReportsContext)jConfig, dataJD, monitor);
            if (jrobj == null) {
                Object[] markers = f.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                if (!Misc.isNullOrEmpty((Object[])markers)) {
                    LinkedHashSet<String> set = new LinkedHashSet<String>();
                    Object[] objectArray = markers;
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object m = objectArray[n2];
                        set.add(m.getAttribute("message").toString());
                        ++n2;
                    }
                    StringBuilder str = new StringBuilder("");
                    for (String s : set) {
                        str.append(String.valueOf(s) + "\n");
                    }
                    UIUtils.showError((Throwable)new Exception(str.toString()));
                }
                return null;
            }
        } else {
            jrobj = JasperCompileManager.getInstance((JasperReportsContext)jConfig).compile(dataJD);
        }
        return jrobj;
    }

    public static Map<String, Object> prepareParameters(JasperReportsConfiguration jConfig, int maxRecords) {
        Map<String, Object> existing;
        Map<String, Object> hm = new HashMap<String, Object>();
        if (jConfig.getJRParameters() != null && (existing = jConfig.getJRParameters()) != null) {
            hm.putAll(existing);
        }
        hm = ReportController.resetParameters(hm, jConfig);
        if (maxRecords > 0) {
            hm.put("REPORT_MAX_COUNT", maxRecords);
        } else {
            hm.remove("REPORT_MAX_COUNT");
        }
        return hm;
    }

    public JasperPrint fillReport(JasperReportsConfiguration jConfig, JRDesignDataset designDataset, DataAdapterDescriptor dataAdapterDesc, JasperReport jrobj, Map<String, Object> hm) throws JRException {
        DataAdapterService das = null;
        try {
            if (dataAdapterDesc != null) {
                Object obj;
                hm.put("PARAMETER_DATA_ADAPTER", dataAdapterDesc.getDataAdapter());
                ReportContext rc = (ReportContext)hm.get("REPORT_CONTEXT");
                if (rc != null && ((obj = rc.getParameterValue("net.sf.jasperreports.data.cache.handler")) == null || obj instanceof ColumnDataCacheHandler && !((ColumnDataCacheHandler)obj).isSnapshotPopulated())) {
                    das = DataAdapterServiceUtil.getInstance((ParameterContributorContext)new ParameterContributorContext((JasperReportsContext)jConfig, (JRDataset)designDataset, hm)).getService(dataAdapterDesc.getDataAdapter());
                    das.contributeParameters(hm);
                }
            }
            ModelUtils.replacePropertiesMap(designDataset.getPropertiesMap(), jrobj.getMainDataset().getPropertiesMap());
            JaspersoftStudioPlugin.getExtensionManager().onRun(jConfig, jrobj, hm);
            this.rf = JRFiller.createReportFiller((JasperReportsContext)jConfig, (JasperReport)jrobj);
            JasperPrint jasperPrint = this.rf.fill(hm);
            return jasperPrint;
        }
        finally {
            if (das != null) {
                das.dispose();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void start(JasperReportsConfiguration jConfig, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stop() {
        if (this.running) {
            if (this.rf != null) {
                try {
                    this.rf.cancelFill();
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
            for (DatasetReaderListener l : this.listeners) {
                l.invalidate();
            }
        }
    }

    public DataAdapterDescriptor getDataAdapterDescriptor() {
        return this.dataAdapterDesc;
    }

    public void setDataAdapterDescriptor(DataAdapterDescriptor dataAdapterDesc) {
        this.dataAdapterDesc = dataAdapterDesc;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public JRDesignDataset getDesignDataset() {
        return this.designDataset;
    }

    public void setDesignDataset(JRDesignDataset designDataset) {
        this.designDataset = designDataset;
        designDataset.getEventSupport().addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("parameters")) {
                this.recalcParameters = true;
                this.listenParameters();
            }
        });
        this.listenParameters();
    }

    private void listenParameters() {
        JRParameter[] jRParameterArray = this.designDataset.getParameters();
        int n = jRParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRParameter p = jRParameterArray[n2];
            ((JRDesignParameter)p).getEventSupport().removePropertyChangeListener(this.dveListener);
            ((JRDesignParameter)p).getEventSupport().addPropertyChangeListener(this.dveListener);
            ++n2;
        }
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    public void addDatasetReaderListener(DatasetReaderListener listener) {
        this.listeners.add(listener);
    }

    public void removeDatasetReaderListener(DatasetReaderListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isRunning() {
        return this.running;
    }
}

