/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.storage;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterFactory;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.DataAdapterUtils;
import com.jaspersoft.studio.data.DefaultDataAdapterDescriptor;
import com.jaspersoft.studio.data.customadapters.JSSCastorUtil;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.XMLUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.LinkedHashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.CastorHelper;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.util.JacksonRuntimException;
import net.sf.jasperreports.util.JacksonUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.ide.IDE;
import org.exolab.castor.mapping.Mapping;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class FileDataAdapterStorage
extends ADataAdapterStorage {
    private IProject project;
    private static XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    public FileDataAdapterStorage(IProject project) {
        this.project = project;
        this.daDescriptors = new LinkedHashMap();
    }

    @Override
    public void findAll() {
        try {
            IResource[] members;
            if (this.project.isOpen() && (members = this.project.members()) != null && members.length > 0) {
                WorkspaceJob job = new WorkspaceJob(Messages.FileDataAdapterStorage_1){
                    private IResourceChangeListener rcl;

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        this.listenWorkspace();
                        monitor.beginTask(String.valueOf(Messages.FileDataAdapterStorage_2) + FileDataAdapterStorage.this.project.getName(), 10);
                        FileDataAdapterStorage.this.project.accept((IResourceProxyVisitor)new ResourceVisitor(), 2, 20);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        monitor.internalWorked(10.0);
                        return Status.OK_STATUS;
                    }

                    protected void listenWorkspace() {
                        final IWorkspace wspace = ResourcesPlugin.getWorkspace();
                        this.rcl = new IResourceChangeListener(){

                            public void resourceChanged(IResourceChangeEvent event) {
                                final IResourceDelta delta = event.getDelta();
                                if (delta == null) {
                                    return;
                                }
                                IResourceDelta docDelta = delta.findMember((this).FileDataAdapterStorage.this.project.getFullPath());
                                if (docDelta == null) {
                                    return;
                                }
                                if (delta.getKind() != 1 && delta.getKind() != 2 && (delta.getKind() != 4 || (delta.getFlags() & 0x53905) != 0)) {
                                    return;
                                }
                                new WorkspaceJob(Messages.FileDataAdapterStorage_1){

                                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                        monitor.beginTask(String.valueOf(Messages.FileDataAdapterStorage_2) + ((this).this).FileDataAdapterStorage.this.project.getName(), 10);
                                        this.processEvent(delta);
                                        if (monitor.isCanceled()) {
                                            return Status.CANCEL_STATUS;
                                        }
                                        monitor.internalWorked(10.0);
                                        return Status.OK_STATUS;
                                    }
                                }.schedule(100L);
                            }

                            protected void processEvent(IResourceDelta delta) {
                                try {
                                    delta.accept(new IResourceDeltaVisitor(){

                                        public boolean visit(IResourceDelta delta) throws CoreException {
                                            IResource res = delta.getResource();
                                            if (res.getType() == 4 && res.equals((Object)((this).this).FileDataAdapterStorage.this.project) && delta.getKind() == 2) {
                                                DataAdapterManager.removeProject((IProject)res);
                                                wspace.removeResourceChangeListener(rcl);
                                                return false;
                                            }
                                            if (res.getType() == 1 && DataAdapterUtils.isSupportedFileExtension(res.getFileExtension())) {
                                                switch (delta.getKind()) {
                                                    case 1: {
                                                        break;
                                                    }
                                                    case 2: {
                                                        UIUtils.getDisplay().asyncExec(() -> {
                                                            DataAdapterDescriptor das = FileDataAdapterStorage.this.findDataAdapter(res.getProjectRelativePath().toOSString());
                                                            FileDataAdapterStorage.this.removeDataAdapter(das);
                                                        });
                                                        break;
                                                    }
                                                    case 4: {
                                                        UIUtils.getDisplay().asyncExec(() -> {
                                                            DataAdapterDescriptor das = FileDataAdapterStorage.this.findDataAdapter(res.getProjectRelativePath().toOSString());
                                                            if (das != null) {
                                                                FileDataAdapterStorage.super.removeDataAdapter(das);
                                                                try {
                                                                    IFile file = (IFile)res;
                                                                    das = FileDataAdapterStorage.readDataADapter(file.getContents(), file);
                                                                    das.setName(file.getProjectRelativePath().toOSString());
                                                                    FileDataAdapterStorage.super.addDataAdapter(das);
                                                                }
                                                                catch (CoreException e) {
                                                                    UIUtils.showError((Throwable)e);
                                                                }
                                                            } else {
                                                                try {
                                                                    FileDataAdapterStorage.this.checkFile((IFile)res);
                                                                }
                                                                catch (CoreException e) {
                                                                    UIUtils.showError((Throwable)e);
                                                                }
                                                            }
                                                        });
                                                    }
                                                }
                                            }
                                            return true;
                                        }
                                    });
                                }
                                catch (CoreException e) {
                                    UIUtils.showError((Throwable)e);
                                }
                            }
                        };
                        wspace.addResourceChangeListener(this.rcl);
                    }
                };
                job.schedule();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean addDataAdapter(DataAdapterDescriptor adapter) {
        boolean result = super.addDataAdapter(adapter);
        if (result) {
            IFile file = this.project.getFile(adapter.getName());
            JasperReportsConfiguration jConf = JasperReportsConfiguration.getDefaultJRConfig(file);
            try {
                String xml = DataAdapterManager.toDataAdapterFile(adapter, (JasperReportsContext)jConf);
                if (file.exists()) {
                    file.setContents((InputStream)new ByteArrayInputStream(xml.getBytes()), true, true, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    file.create((InputStream)new ByteArrayInputStream(xml.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                }
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                jConf.dispose();
            }
        }
        return false;
    }

    @Override
    public boolean removeDataAdapter(DataAdapterDescriptor da) {
        IFile file;
        boolean result = super.removeDataAdapter(da);
        if (result && (file = this.project.getFile(da.getName())).exists()) {
            try {
                file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    private void checkFile(IFile file) throws CoreException {
        DataAdapterDescriptor das;
        if (!file.isAccessible() || file.isDerived() || file.isPhantom() || file.isHidden() || file.isVirtual() || !file.exists()) {
            return;
        }
        String ext = file.getFileExtension();
        if (DataAdapterUtils.isSupportedFileExtension(ext) && (das = FileDataAdapterStorage.readDataADapter(file.getContents(), file)) != null) {
            das.setName(file.getProjectRelativePath().toOSString());
            UIUtils.getDisplay().asyncExec(() -> {
                FileDataAdapterStorage.super.addDataAdapter(das);
                IDE.setDefaultEditor((IFile)file, (String)"com.jaspersoft.studio.data.DataAdapterEditorPart");
            });
        }
    }

    private static String readXML(InputStream in) {
        try {
            XMLStreamReader streamReader = inputFactory.createXMLStreamReader(in);
            streamReader.nextTag();
            if (streamReader.getName().getLocalPart().endsWith("DataAdapter")) {
                int i = 0;
                while (i < streamReader.getAttributeCount()) {
                    if (streamReader.getAttributeName(i).getLocalPart().equals("class")) {
                        return streamReader.getAttributeValue(i);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static DataAdapterDescriptor readDataADapter(InputStream in, IFile file) {
        JasperReportsConfiguration jConf = null;
        DataAdapterDescriptor da = null;
        try {
            try {
                in = new BufferedInputStream(in);
                in.mark(Integer.MAX_VALUE);
                String className = FileDataAdapterStorage.readXML(in);
                if (!Misc.isNullOrEmpty((String)className)) {
                    in.reset();
                    jConf = JasperReportsConfiguration.getDefaultJRConfig(file);
                    da = FileDataAdapterStorage.readDataADapter(in, file, jConf);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (jConf != null) {
                    jConf.dispose();
                }
                FileUtils.closeStream((Closeable)in);
            }
        }
        finally {
            if (jConf != null) {
                jConf.dispose();
            }
            FileUtils.closeStream((Closeable)in);
        }
        return da;
    }

    public static DataAdapterDescriptor readDataADapter(InputStream in, IFile file, JasperReportsConfiguration jrConfig) {
        try {
            in = new BufferedInputStream(in);
            in.mark(Integer.MAX_VALUE);
            String className = FileDataAdapterStorage.readXML(in);
            if (!Misc.isNullOrEmpty((String)className)) {
                in.reset();
                DataAdapterDescriptor dataAdapterDescriptor = FileDataAdapterStorage.readDataADapter(in, file, jrConfig, className);
                return dataAdapterDescriptor;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileUtils.closeStream((Closeable)in);
        }
        return null;
    }

    private static DataAdapterDescriptor readDataADapter(InputStream in, IFile file, JasperReportsConfiguration jrConfig, String className) {
        DataAdapterDescriptor dad;
        block10: {
            dad = null;
            try {
                DataAdapterFactory factory = DataAdapterManager.findFactoryByDataAdapterClass(className);
                if (factory == null) {
                    IProject project = file.getProject();
                    if (project != null) {
                        InputStream mis;
                        DefaultDataAdapterDescriptor ddad = new DefaultDataAdapterDescriptor();
                        Class<?> clazz = jrConfig.getClassLoader().loadClass(className);
                        if (clazz == null || (mis = jrConfig.getClassLoader().getResourceAsStream(String.valueOf(clazz.getName().replace(".", "/")) + ".xml")) == null) break block10;
                        try {
                            Mapping mapping = new Mapping(jrConfig.getClassLoader());
                            mapping.loadMapping(new InputSource(mis));
                            DataAdapter dataAdapter = (DataAdapter)CastorHelper.read((Node)XMLUtils.parseNoValidation(in).getDocumentElement(), (Mapping)mapping);
                            if (dataAdapter != null) {
                                ddad.setDataAdapter(dataAdapter);
                                dad = ddad;
                            }
                            break block10;
                        }
                        finally {
                            FileUtils.closeStream((Closeable)mis);
                        }
                    }
                    JaspersoftStudioPlugin.getInstance().getLog().log((IStatus)new Status(2, JaspersoftStudioPlugin.getUniqueIdentifier(), 0, String.valueOf(Messages.DataAdapterManager_nodataadapterfound) + className, null));
                    break block10;
                }
                DataAdapterDescriptor dataAdapterDescriptor = factory.createDataAdapter();
                DataAdapter dataAdapter = null;
                try {
                    dataAdapter = (DataAdapter)JacksonUtil.getInstance((JasperReportsContext)jrConfig).loadXml(in, DataAdapter.class);
                }
                catch (JacksonRuntimException jacksonRuntimException) {
                    in.reset();
                    dataAdapter = (DataAdapter)JSSCastorUtil.getInstance(jrConfig).read(in);
                }
                dataAdapterDescriptor.setDataAdapter(dataAdapter);
                dad = dataAdapterDescriptor;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dad;
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    public String getStorageName() {
        return this.project.getName();
    }

    private final class ResourceVisitor
    implements IResourceProxyVisitor {
        private ResourceVisitor() {
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            String fext;
            IPath fpath;
            if (proxy.isTeamPrivateMember()) {
                return false;
            }
            if (proxy.getType() == 2) {
                return true;
            }
            if (proxy.getType() == 1 && (fpath = proxy.requestFullPath()) != null && (fext = fpath.getFileExtension()) != null && DataAdapterUtils.isSupportedFileExtension(fext)) {
                FileDataAdapterStorage.this.checkFile((IFile)proxy.requestResource());
            }
            return true;
        }
    }
}

