/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.storage;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.storage.DataAdapterLocationResolver;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IFile;

public class JRDefaultDataAdapterStorage
extends ADataAdapterStorage {
    private JasperReportsConfiguration jConfig;
    private JasperDesign design;
    private IFile report;
    private Map<String, DataAdapterLocationResolver> resolvers = new HashMap<String, DataAdapterLocationResolver>();

    public JRDefaultDataAdapterStorage(JasperReportsConfiguration jConfig) {
        this.jConfig = jConfig;
        this.design = jConfig.getJasperDesign();
        this.report = (IFile)jConfig.get("ifile");
        this.daDescriptors = new HashMap();
    }

    @Override
    public void findAll() {
    }

    @Override
    public String getStorageName() {
        return Messages.JRDefaultDataAdapterStorage_0;
    }

    @Override
    public Collection<DataAdapterDescriptor> getDataAdapterDescriptors() {
        if (this.design != null) {
            return this.getDataAdapterDescriptors(this.design.getMainDesignDataset());
        }
        return new ArrayList<DataAdapterDescriptor>();
    }

    @Override
    public Collection<DataAdapterDescriptor> getDataAdapterDescriptors(JRDesignDataset dataset) {
        this.daDescriptors.clear();
        String location = dataset.getPropertiesMap().getProperty("net.sf.jasperreports.data.adapter");
        DataAdapterDescriptor currentDefault = this.getDefaultJRDataAdapter(location);
        if (currentDefault != null) {
            this.daDescriptors.put(location, currentDefault);
        }
        return this.daDescriptors.values();
    }

    public DataAdapterDescriptor getDefaultJRDataAdapter(String location) {
        if (location != null) {
            DataAdapterLocationResolver resolver = this.getResolver(location);
            return resolver.getDataAdapter();
        }
        return null;
    }

    public DataAdapterDescriptor getDefaultJRDataAdapter(JRDesignDataset dataset) {
        String location = null;
        location = dataset != null ? dataset.getPropertiesMap().getProperty("net.sf.jasperreports.data.adapter") : this.design.getMainDataset().getPropertiesMap().getProperty("net.sf.jasperreports.data.adapter");
        return this.getDefaultJRDataAdapter(location);
    }

    protected DataAdapterLocationResolver getResolver(String location) {
        DataAdapterLocationResolver resolver = this.resolvers.get(location);
        if (resolver == null) {
            resolver = new DataAdapterLocationResolver(location, this.jConfig, this.report);
            this.resolvers.put(location, resolver);
        }
        return resolver;
    }

    @Override
    public String getLabel(DataAdapterDescriptor d) {
        String label = d.getTitle();
        return String.valueOf(label) + Messages.JRDefaultDataAdapterStorage_1;
    }

    @Override
    public String getUrl(DataAdapterDescriptor da) {
        for (DataAdapterLocationResolver resolver : this.resolvers.values()) {
            if (resolver.getDataAdapter() != da) continue;
            return resolver.getAdapterURL();
        }
        return null;
    }
}

