/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.widget;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.noda.NoDataAdapterDescriptor;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.storage.JRDefaultDataAdapterStorage;
import com.jaspersoft.studio.data.widget.IDataAdapterRunnable;
import com.jaspersoft.studio.editor.context.AEditorContext;
import com.jaspersoft.studio.messages.Messages;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.viewer.IReportViewerListener;
import net.sf.jasperreports.eclipse.viewer.ReportViewerEvent;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;

public class DataAdapterAction
extends Action
implements IMenuCreator,
PropertyChangeListener,
IReportViewerListener {
    public static final String ID = "DATAADAPTERACTION";
    private IDataAdapterRunnable editor;
    private ADataAdapterStorage[] dastorages;
    private Menu listMenu;
    private Control parent;
    private DataAdapterDescriptor selectedDA;
    private String language;
    private static NoDataAdapterDescriptor noda = new NoDataAdapterDescriptor();

    public DataAdapterAction(IDataAdapterRunnable editor, ADataAdapterStorage[] dastorages, JRDesignDataset dataset) {
        this.setId(ID);
        this.setMenuCreator(this);
        this.setText(Messages.DataAdapterAction_0);
        this.setDescription(Messages.DataAdapterAction_1);
        this.setToolTipText(Messages.DataAdapterAction_2);
        this.editor = editor;
        this.dastorages = dastorages;
    }

    public DataAdapterAction(IDataAdapterRunnable editor, ADataAdapterStorage[] dastorages) {
        this.setId(ID);
        this.setMenuCreator(this);
        this.setText(Messages.DataAdapterAction_0);
        this.setDescription(Messages.DataAdapterAction_1);
        this.setToolTipText(Messages.DataAdapterAction_2);
        this.editor = editor;
        this.dastorages = dastorages;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public JRDesignDataset getCurrentDataset() {
        if (this.editor.getConfiguration().getJasperDesign() != null) {
            return this.editor.getConfiguration().getJasperDesign().getMainDesignDataset();
        }
        return null;
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.editor.isNotRunning();
    }

    public void run() {
        String runonchange = this.editor.getConfiguration().getProperty("com.jaspersoft.studio.run.report.on.da.change", "true");
        if (runonchange.equals("false")) {
            return;
        }
        JRDesignDataset currentDataset = this.getCurrentDataset();
        if (currentDataset == null) {
            if (!this.editor.runReport(null, true)) {
                this.refreshDA();
            }
            return;
        }
        JRDefaultDataAdapterStorage defaultStorage = DataAdapterManager.getJRDefaultStorage(this.editor.getConfiguration());
        DataAdapterDescriptor defaultDA = defaultStorage.getDefaultJRDataAdapter(currentDataset);
        if (defaultDA == this.selectedDA) {
            if (!this.editor.runReport(null, true)) {
                this.refreshDA();
            }
        } else if (!this.editor.runReport(this.selectedDA, true) && (defaultDA = defaultStorage.getDefaultJRDataAdapter(currentDataset)) != this.selectedDA) {
            this.setSelected(defaultDA);
        }
    }

    public void refreshDA() {
        JRDefaultDataAdapterStorage defaultStorage = DataAdapterManager.getJRDefaultStorage(this.editor.getConfiguration());
        DataAdapterDescriptor defaultDA = defaultStorage.getDefaultJRDataAdapter(this.getCurrentDataset());
        if (defaultDA == null) {
            AEditorContext cntx;
            String p;
            JRDesignDataset currentDataset = this.getCurrentDataset();
            if (currentDataset != null && (p = currentDataset.getPropertiesMap().getProperty(this.editor.getConfiguration().getEditorContext().getDataAdapterProperty())) != null) {
                this.setSelected(p);
                return;
            }
            if (defaultDA == null && !(cntx = this.editor.getConfiguration().getEditorContext()).hasNoDataAdapter()) {
                this.setSelected(Messages.DataAdapterManager_oneemptyrecord);
                return;
            }
        }
        this.setSelected(defaultDA);
    }

    public void dispose() {
        if (this.listMenu != null) {
            this.listMenu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        JRDesignDataset currentDataset;
        MenuItem m1;
        this.parent = parent;
        if (this.listMenu != null) {
            this.listMenu.dispose();
        }
        if (parent.isDisposed()) {
            UIUtils.showError((Throwable)new Exception("he is disposed"));
            return null;
        }
        this.listMenu = new Menu(parent);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem menuItem = (MenuItem)e.getSource();
                menuItem.setSelection(true);
                DataAdapterAction.this.setSelected((DataAdapterDescriptor)menuItem.getData("da.key"));
                DataAdapterAction.this.run();
            }
        };
        AEditorContext cntx = this.editor.getConfiguration().getEditorContext();
        if (cntx.hasNoDataAdapter()) {
            m1 = new MenuItem(this.listMenu, 8);
            m1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    m1.setSelection(true);
                    DataAdapterAction.this.setSelected((DataAdapterDescriptor)null);
                    DataAdapterAction.this.run();
                }
            });
            m1.setText(Messages.DataAdapterAction_0);
        }
        if (this.dastorages != null && (currentDataset = this.getCurrentDataset()) != null) {
            int i = 0;
            while (i < this.dastorages.length) {
                ADataAdapterStorage s = this.dastorages[i];
                if (cntx.isDataAdapterStorage(s)) {
                    for (DataAdapterDescriptor d : s.getDataAdapterDescriptors(currentDataset)) {
                        String[] langs;
                        if (this.language != null && (langs = d.getLanguages()) != null) {
                            boolean exists = false;
                            String[] stringArray = langs;
                            int n = langs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String l = stringArray[n2];
                                if (this.language.equalsIgnoreCase(l) || l.equals("*")) {
                                    exists = true;
                                    break;
                                }
                                ++n2;
                            }
                            if (!exists) continue;
                        }
                        MenuItem m12 = new MenuItem(this.listMenu, 8);
                        m12.setImage(d.getIcon(16));
                        m12.addSelectionListener((SelectionListener)listener);
                        m12.setData("da.key", (Object)d);
                        m12.setText(s.getLabel(d));
                    }
                    if (!s.getDataAdapterDescriptors(currentDataset).isEmpty() && i < this.dastorages.length - 1 && !this.dastorages[i + 1].getDataAdapterDescriptors(currentDataset).isEmpty()) {
                        new MenuItem(this.listMenu, 2);
                    }
                }
                ++i;
            }
        }
        if (!cntx.hasNoDataAdapter()) {
            new MenuItem(this.listMenu, 2);
            m1 = new MenuItem(this.listMenu, 8);
            m1.setImage(noda.getIcon(16));
            m1.addSelectionListener((SelectionListener)listener);
            m1.setData("da.key", (Object)noda);
            m1.setText(noda.getTitle());
        }
        return this.listMenu;
    }

    private void refresh() {
    }

    public void setDataAdapterStorages(ADataAdapterStorage[] dastorages) {
        ADataAdapterStorage das;
        int n;
        int n2;
        ADataAdapterStorage[] aDataAdapterStorageArray;
        if (this.dastorages != null) {
            aDataAdapterStorageArray = dastorages;
            n2 = dastorages.length;
            n = 0;
            while (n < n2) {
                das = aDataAdapterStorageArray[n];
                das.removePropertyChangeListener(this);
                ++n;
            }
        }
        this.dastorages = dastorages;
        if (dastorages != null) {
            aDataAdapterStorageArray = dastorages;
            n2 = dastorages.length;
            n = 0;
            while (n < n2) {
                das = aDataAdapterStorageArray[n];
                das.addPropertyChangeListener(this);
                ++n;
            }
        }
        this.setSelected(Messages.DataAdapterManager_oneemptyrecord);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    public void viewerStateChanged(ReportViewerEvent arg0) {
        this.refresh();
    }

    public void setSelected(String d) {
        DataAdapterDescriptor defaultDA;
        if (d != null && this.dastorages != null) {
            ADataAdapterStorage[] aDataAdapterStorageArray = this.dastorages;
            int n = this.dastorages.length;
            int n2 = 0;
            while (n2 < n) {
                ADataAdapterStorage das = aDataAdapterStorageArray[n2];
                AEditorContext cntx = this.editor.getConfiguration().getEditorContext();
                if (cntx.isDataAdapterStorage(das)) {
                    for (DataAdapterDescriptor dad : das.getDataAdapterDescriptors()) {
                        if (!dad.getName().equals(d)) continue;
                        this.setSelected(dad);
                        return;
                    }
                }
                ++n2;
            }
        }
        if ("NO_DATA_ADAPTER".equals(d)) {
            this.setSelected(noda);
            return;
        }
        JRDefaultDataAdapterStorage defaultStorage = DataAdapterManager.getJRDefaultStorage(this.editor.getConfiguration());
        JRDesignDataset currentDataset = this.getCurrentDataset();
        if (currentDataset != null && (defaultDA = defaultStorage.getDefaultJRDataAdapter(currentDataset)) != null) {
            this.setSelected(defaultDA);
        }
    }

    public void setSelected(DataAdapterDescriptor d) {
        this.selectedDA = d;
        if (d == null) {
            this.setText(Messages.DataAdapterAction_0);
            this.setDescription(Messages.DataAdapterAction_1);
            this.setToolTipText(Messages.DataAdapterAction_2);
        } else {
            String name = d.getTitle();
            if (name.length() > 17) {
                name = String.valueOf(name.substring(0, 17)) + "...";
            }
            this.setText(name);
            this.setDescription(d.getDescription());
            this.setToolTipText(d.getName());
        }
        if (this.parent != null) {
            ToolBar toolBar = (ToolBar)this.parent;
            toolBar.pack(true);
            toolBar.getParent().getParent().layout(true);
        }
    }

    public boolean isDefaultDASelected() {
        JRDefaultDataAdapterStorage defaultStorage = DataAdapterManager.getJRDefaultStorage(this.editor.getConfiguration());
        JRDesignDataset currentDataset = this.getCurrentDataset();
        if (currentDataset != null) {
            DataAdapterDescriptor defaultDA = defaultStorage.getDefaultJRDataAdapter(currentDataset);
            return defaultDA != null && defaultDA == this.selectedDA;
        }
        return false;
    }

    public DataAdapterDescriptor getSelected() {
        return this.selectedDA;
    }
}

