/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterFactory;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.wizard.DataAdapterWizardDialog;
import com.jaspersoft.studio.data.wizard.pages.DataAdapterEditorPage;
import com.jaspersoft.studio.data.wizard.pages.DataAdaptersListPage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jobs.CheckedRunnableWithProgress;
import com.jaspersoft.studio.wizards.JSSWizard;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceUtil;
import net.sf.jasperreports.eclipse.classpath.JavaProjectClassLoader;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.util.CompositeClassloader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public abstract class AbstractDataAdapterWizard
extends JSSWizard
implements SelectionListener {
    protected DataAdapterDescriptor dataAdapter = null;
    protected DataAdapterWizardDialog wizardDialog = null;
    protected DataAdapterFactory selectedFactory = null;
    protected DataAdaptersListPage dataAdapterListPage = null;
    protected DataAdapterEditorPage dataAdapterEditorPage = null;
    protected ADataAdapterStorage storage;

    public AbstractDataAdapterWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void setWizardDialog(DataAdapterWizardDialog wizardDialog) {
        this.wizardDialog = wizardDialog;
        if (this.wizardDialog != null) {
            this.wizardDialog.addTestListener(this);
            this.wizardDialog.addPageChangingListener(new IPageChangingListener(){

                public void handlePageChanging(PageChangingEvent event) {
                    if (event.getCurrentPage() == AbstractDataAdapterWizard.this.dataAdapterListPage && event.getTargetPage() == AbstractDataAdapterWizard.this.dataAdapterEditorPage) {
                        DataAdapterFactory factory = AbstractDataAdapterWizard.this.dataAdapterListPage.getSelectedFactory();
                        MessageFormat fm = new MessageFormat(Messages.DataAdapterWizard_newdataadaptername);
                        DataAdapterDescriptor newDataAdapter = factory.createDataAdapter();
                        int i = 1;
                        while (i < 1000) {
                            String name = fm.format(new Object[]{i > 1 ? "(" + i + ")" : ""}).trim();
                            if (AbstractDataAdapterWizard.this.storage.isDataAdapterNameValid(name)) {
                                newDataAdapter.getDataAdapter(AbstractDataAdapterWizard.this.getConfig()).setName(name);
                                break;
                            }
                            ++i;
                        }
                        if (AbstractDataAdapterWizard.this.selectedFactory != factory) {
                            AbstractDataAdapterWizard.this.dataAdapterEditorPage.setDataAdapter(newDataAdapter);
                            AbstractDataAdapterWizard.this.selectedFactory = factory;
                        }
                    }
                }
            });
            this.wizardDialog.addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    AbstractDataAdapterWizard.this.getWizardDialog().setTestButtonEnabled(event.getSelectedPage() == AbstractDataAdapterWizard.this.dataAdapterEditorPage);
                }
            });
        }
    }

    public DataAdapterWizardDialog getWizardDialog() {
        return this.wizardDialog;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.getContainer().getCurrentPage() == this.dataAdapterEditorPage) {
            final DataAdapter da = this.dataAdapterEditorPage.getDataAdapterEditor().getDataAdapter().getDataAdapter();
            this.getWizardDialog().setTestButtonEnabled(false);
            try {
                try {
                    this.getContainer().run(true, true, (IRunnableWithProgress)new CheckedRunnableWithProgress(){
                        private DataAdapterService daService = null;

                        @Override
                        protected void runOperations(IProgressMonitor monitor) {
                            monitor.beginTask("Testing Data Adapter", 2);
                            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
                            try {
                                try {
                                    IProject[] prjs;
                                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                                    IProject[] iProjectArray = prjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                                    int n = prjs.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IProject p = iProjectArray[n2];
                                        if (ProjectUtil.isOpen((IProject)p) && p.getNature("org.eclipse.jdt.core.javanature") != null) {
                                            cl = cl == null ? JavaProjectClassLoader.instance((IJavaProject)JavaCore.create((IProject)p)) : new CompositeClassloader(cl, JavaProjectClassLoader.instance((IJavaProject)JavaCore.create((IProject)p)));
                                        }
                                        ++n2;
                                    }
                                    cl = JaspersoftStudioPlugin.getDriversManager().getClassLoader(cl);
                                    cl = new CompositeClassloader(cl, this.getClass().getClassLoader());
                                    Thread.currentThread().setContextClassLoader(cl);
                                    AbstractDataAdapterWizard.this.getConfig().setClassLoader(cl);
                                    this.daService = DataAdapterServiceUtil.getInstance((ParameterContributorContext)new ParameterContributorContext((JasperReportsContext)AbstractDataAdapterWizard.this.getConfig(), null, null)).getService(da);
                                    this.daService.test();
                                    UIUtils.getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            UIUtils.showInformation((String)Messages.DataAdapterWizard_testbutton, (String)Messages.DataAdapterWizard_testsuccesful);
                                        }
                                    });
                                }
                                catch (Exception e1) {
                                    UIUtils.showError((Throwable)e1);
                                    monitor.done();
                                    Thread.currentThread().setContextClassLoader(oldCL);
                                }
                            }
                            finally {
                                monitor.done();
                                Thread.currentThread().setContextClassLoader(oldCL);
                            }
                        }

                        @Override
                        protected void abortOperationInvoked() throws InterruptedException {
                            if (this.daService != null) {
                                this.daService.dispose();
                                this.daService = null;
                            }
                            super.abortOperationInvoked();
                        }
                    });
                }
                catch (InvocationTargetException e1) {
                    UIUtils.showError((Throwable)e1.getCause());
                    this.getWizardDialog().setTestButtonEnabled(true);
                }
                catch (InterruptedException e1) {
                    UIUtils.showError((Throwable)e1);
                    this.getWizardDialog().setTestButtonEnabled(true);
                }
            }
            finally {
                this.getWizardDialog().setTestButtonEnabled(true);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public DataAdapterDescriptor getDataAdapter() {
        return this.dataAdapter;
    }
}

