/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterFactory;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.adapter.IReportDescriptor;
import com.jaspersoft.studio.data.wizard.JSSPropertiesPage;
import com.jaspersoft.studio.data.wizard.SelectWorkspacePage;
import com.jaspersoft.studio.data.wizard.ShowJSSAdaptersPage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.util.PreferencesUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.util.CastorUtil;
import net.sf.jasperreports.util.JacksonRuntimException;
import net.sf.jasperreports.util.JacksonUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.w3c.dom.Node;

public class ImportJSSAdapterWizard
extends Wizard
implements IImportWizard {
    private SelectWorkspacePage page0 = new SelectWorkspacePage();
    private ShowJSSAdaptersPage page1 = new ShowJSSAdaptersPage();
    private JSSPropertiesPage page2 = new JSSPropertiesPage();

    public void addPages() {
        this.addPage((IWizardPage)this.page0);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
    }

    public IReportDescriptor getSelectedConfiguration() {
        return this.page0.getSelection();
    }

    private void addAdapters() {
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){
                Transformer t;

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List<?> adapterNodes = ImportJSSAdapterWizard.this.page1.getSelectedAdapter();
                        int i = 0;
                        while (i < adapterNodes.size()) {
                            Node adapterNode = (Node)adapterNodes.get(i);
                            if (adapterNode.getNodeType() == 1) {
                                String adapterClassName = adapterNode.getAttributes().getNamedItem("class").getNodeValue();
                                DataAdapterFactory factory = DataAdapterManager.findFactoryByDataAdapterClass(adapterClassName);
                                if (factory == null) {
                                    JaspersoftStudioPlugin.getInstance().getLog().log((IStatus)new Status(2, JaspersoftStudioPlugin.getUniqueIdentifier(), 0, String.valueOf(Messages.DataAdapterManager_nodataadapterfound) + adapterClassName, null));
                                } else {
                                    DataAdapterDescriptor dataAdapterDescriptor = factory.createDataAdapter();
                                    DataAdapter dataAdapter = null;
                                    byte[] bytes = this.nodeToString(adapterNode).getBytes();
                                    try {
                                        dataAdapter = (DataAdapter)JacksonUtil.getInstance((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance()).loadXml((InputStream)new ByteArrayInputStream(bytes), DataAdapter.class);
                                    }
                                    catch (JacksonRuntimException jacksonRuntimException) {
                                        dataAdapter = (DataAdapter)CastorUtil.getInstance((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance()).read((InputStream)new ByteArrayInputStream(bytes));
                                    }
                                    dataAdapterDescriptor.setDataAdapter(dataAdapter);
                                    DataAdapterManager.getPreferencesStorage().addDataAdapter(dataAdapterDescriptor);
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                private String nodeToString(Node node) throws TransformerFactoryConfigurationError, TransformerException {
                    StringWriter sw = new StringWriter();
                    if (this.t == null) {
                        this.t = TransformerFactory.newInstance().newTransformer();
                        this.t.setOutputProperty("omit-xml-declaration", "yes");
                        this.t.setOutputProperty("indent", "yes");
                    }
                    this.t.transform(new DOMSource(node), new StreamResult(sw));
                    return sw.toString();
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        this.addAdapters();
        List<String> proeprties = this.page2.getProperties();
        String[] keys = proeprties.toArray(new String[proeprties.size()]);
        String[] values = new String[proeprties.size()];
        int i = 0;
        while (i < keys.length) {
            values[i] = this.page2.getProperyValue(keys[i]);
            ++i;
        }
        PreferencesUtils.storeJasperReportsProperty(keys, values);
        return true;
    }
}

