/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard.pages;

import com.jaspersoft.studio.data.ADataAdapterComposite;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterEditor;
import com.jaspersoft.studio.data.DataAdapterFactory;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.WizardEndingStateListener;
import java.text.MessageFormat;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DataAdapterEditorPage
extends WizardPage
implements WizardEndingStateListener {
    private DataAdapterEditor dataAdapterEditor = null;
    private String subTitle = "";
    private Composite mainContainer = null;
    private Composite staticContainer = null;
    private Composite customContainer = null;
    private ADataAdapterComposite editorComposite = null;
    private Text textName;
    private boolean editMode = false;
    private ADataAdapterStorage storage;
    private JasperReportsContext jrContext;
    private WizardPageSupport wizardPageSupport;

    public void setStorage(ADataAdapterStorage storage) {
        this.storage = storage;
    }

    public void setJrContext(JasperReportsContext jrContext) {
        this.jrContext = jrContext;
    }

    public DataAdapterEditorPage() {
        super("dataAdaptereditorpage");
        this.setTitle(Messages.DataAdapterEditorPage_2);
        this.setDescription(Messages.DataAdapterEditorPage_3);
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.getErrorMessage() == null;
    }

    public void createControl(Composite parent) {
        this.mainContainer = new Composite(parent, 0);
        this.setControl((Control)this.mainContainer);
        this.mainContainer.setLayout((Layout)new GridLayout(1, false));
        this.staticContainer = new Composite(this.mainContainer, 0);
        this.staticContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_staticContainer = new GridLayout(2, false);
        gl_staticContainer.marginHeight = 0;
        gl_staticContainer.marginWidth = 0;
        this.staticContainer.setLayout((Layout)gl_staticContainer);
        Label lblName = new Label(this.staticContainer, 0);
        lblName.setText(Messages.DataAdapterEditorPage_4);
        this.textName = new Text(this.staticContainer, 2048);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label = new Label(this.staticContainer, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.customContainer = new Composite(this.mainContainer, 0);
        this.customContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.customContainer.setLayout((Layout)new GridLayout(1, false));
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = DataAdapterEditorPage.this.textName.getText().trim();
                boolean b = true;
                if (DataAdapterEditorPage.this.isEditMode()) {
                    b = DataAdapterEditorPage.this.isDataAdapterNameValid(name);
                } else if (DataAdapterEditorPage.this.storage != null) {
                    b = DataAdapterEditorPage.this.storage.isDataAdapterNameValid(name);
                }
                DataAdapterEditorPage.this.setPageComplete(b);
                if (b) {
                    DataAdapterEditorPage.this.setDescription(DataAdapterEditorPage.this.getSubTitle());
                    DataAdapterEditorPage.this.setMessage(DataAdapterEditorPage.this.getSubTitle());
                    DataAdapterEditorPage.this.dataAdapterEditor.getDataAdapter().getDataAdapter().setName(name);
                } else if (name.length() > 0) {
                    DataAdapterEditorPage.this.setMessage(MessageFormat.format(Messages.DataAdapterEditorPage_5, name), 3);
                } else {
                    DataAdapterEditorPage.this.setMessage(Messages.DataAdapterEditorPage_7, 3);
                }
            }
        });
        this.setPageComplete(false);
        this.setMessage(Messages.DataAdapterEditorPage_8, 3);
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.dataAdapterEditor.getHelpContextId());
    }

    public void setDataAdapter(DataAdapterDescriptor newDataAdapterDescriptor) {
        if (newDataAdapterDescriptor.getEditor() == this.dataAdapterEditor) {
            return;
        }
        DataAdapterFactory daFactory = DataAdapterManager.findFactoryByDataAdapterClass(newDataAdapterDescriptor.getDataAdapter().getClass().getName());
        if (daFactory != null) {
            this.setSubTitle(daFactory.getLabel());
        }
        this.dataAdapterEditor = newDataAdapterDescriptor.getEditor();
        if (this.editorComposite != null) {
            this.wizardPageSupport.dispose();
            this.editorComposite.dispose();
        }
        if (this.jrContext == null) {
            this.jrContext = JasperReportsConfiguration.getDefaultJRConfig();
        }
        this.editorComposite = this.dataAdapterEditor.getComposite(this.customContainer, 0, this, this.jrContext);
        this.editorComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.wizardPageSupport = WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.editorComposite.getBindingContext());
        this.dataAdapterEditor.setDataAdapter(newDataAdapterDescriptor);
        this.textName.setText(Misc.nvl((Object)newDataAdapterDescriptor.getName(), (String)""));
        this.customContainer.layout();
        if (this.getShell().isVisible()) {
            Point currentSize = this.customContainer.getSize();
            Point preferredSize = this.customContainer.computeSize(-1, -1);
            Point windowSize = this.getShell().getSize();
            this.getShell().layout();
            this.getShell().setSize(new Point(windowSize.x, windowSize.y + Math.max(0, preferredSize.y - currentSize.y)));
        }
    }

    public DataAdapterDescriptor getDataAdapter() {
        DataAdapterDescriptor da = this.getDataAdapterEditor().getDataAdapter();
        da.getDataAdapter().setName(this.textName.getText());
        return da;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public DataAdapterEditor getDataAdapterEditor() {
        return this.dataAdapterEditor;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    private boolean isDataAdapterNameValid(String dataAdapterName) {
        return dataAdapterName != null && !"".equals(dataAdapterName);
    }

    @Override
    public void performFinishInvoked() {
        if (this.editorComposite != null) {
            this.editorComposite.performAdditionalUpdates();
        }
    }

    @Override
    public void performCancelInvoked() {
    }
}

