/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.debug;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactoryContext;

public class TraceGovernor
extends JRDefaultScriptlet {
    public static final String PREFIX = "com.jaspersoft.studio.trace.";
    public static final String TYPE_FIELD = "field.";
    public static final String TYPE_VARIABLE = "variable.";
    public static final String TYPE_PARAMETER = "parameter.";
    public static final String AFTER_DETAIL_EVAL = "afterDetailEval.";
    public static final String BEFORE_DETAIL_EVAL = "beforeDetailEval.";
    public static final String AFTER_GROUP_INIT = "afterGroupInit.";
    public static final String BEFORE_GROUP_INIT = "beforeGroupInit.";
    public static final String AFTER_COLUMN_INIT = "afterColumnInit.";
    public static final String BEFORE_COLUMN_INIT = "beforeColumnInit.";
    public static final String AFTER_PAGE_INIT = "afterPageInit.";
    public static final String BEFORE_PAGE_INIT = "beforePageInit.";
    public static final String AFTER_REPORT_INIT = "afterReportInit.";
    public static final String BEFORE_REPORT_INIT = "beforeReportInit.";
    private ScriptletFactoryContext context;
    private JasperReportsConfiguration jrConfig;
    private boolean trace = false;
    private Map<String, Boolean> beforeRepInit = new HashMap<String, Boolean>();
    private Map<String, Boolean> afterRepInit = new HashMap<String, Boolean>();
    private Map<String, Boolean> beforePageInit = new HashMap<String, Boolean>();
    private Map<String, Boolean> afterPageInit = new HashMap<String, Boolean>();
    private Map<String, Boolean> beforeColInit = new HashMap<String, Boolean>();
    private Map<String, Boolean> afterColInit = new HashMap<String, Boolean>();
    private Map<String, Boolean> beforeGroupInit = new HashMap<String, Boolean>();
    private Map<String, Boolean> afterGroupInit = new HashMap<String, Boolean>();
    private Map<String, Boolean> beforeDetEval = new HashMap<String, Boolean>();
    private Map<String, Boolean> afterDetEval = new HashMap<String, Boolean>();

    public TraceGovernor(ScriptletFactoryContext context) {
        this.context = context;
        if (context.getJasperReportsContext() instanceof JasperReportsConfiguration) {
            this.jrConfig = (JasperReportsConfiguration)context.getJasperReportsContext();
        }
    }

    private void show(String level, Map<String, Boolean> map) {
        String name;
        if (this.jrConfig == null || !this.trace) {
            return;
        }
        String trace = "";
        JRDataset dataset = this.context.getDataset();
        JRField[] jRFieldArray = dataset.getFields();
        int n = jRFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRField f = jRFieldArray[n2];
            name = f.getName();
            if (map.get("com.jaspersoft.studio.trace.field." + dataset.getName() + "." + level + name).booleanValue()) {
                try {
                    trace = String.valueOf(trace) + "Field [" + name + "] " + this.getFieldValue(name) + "\n";
                }
                catch (JRScriptletException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        jRFieldArray = dataset.getVariables();
        n = jRFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            JRField v = jRFieldArray[n2];
            name = v.getName();
            if (map.get("com.jaspersoft.studio.trace.variable." + dataset.getName() + "." + level + name).booleanValue()) {
                try {
                    trace = String.valueOf(trace) + "Variable [" + name + "] " + this.getVariableValue(name) + "\n";
                }
                catch (JRScriptletException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        jRFieldArray = dataset.getParameters();
        n = jRFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            JRField p = jRFieldArray[n2];
            name = p.getName();
            if (map.get("com.jaspersoft.studio.trace.parameter." + dataset.getName() + "." + level + name).booleanValue()) {
                try {
                    trace = String.valueOf(trace) + "Parameter [" + name + "] " + this.getParameterValue(name) + "\n";
                }
                catch (JRScriptletException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        if (!Misc.isNullOrEmpty((String)trace)) {
            System.out.println("\n" + trace);
        }
    }

    private void setup(Map<String, Boolean> map, String type, String level, String name) {
        JRDataset dataset = this.context.getDataset();
        String key = PREFIX + type + dataset.getName() + "." + level + name;
        Boolean b = this.jrConfig.getPropertyBoolean(key, false);
        if (b.booleanValue()) {
            this.trace = true;
        }
        map.put(key, b);
    }

    private void initMaps(String type, String name) {
        this.setup(this.beforeRepInit, type, BEFORE_REPORT_INIT, name);
        this.setup(this.afterRepInit, type, AFTER_REPORT_INIT, name);
        this.setup(this.beforePageInit, type, BEFORE_PAGE_INIT, name);
        this.setup(this.afterPageInit, type, AFTER_PAGE_INIT, name);
        this.setup(this.beforeColInit, type, BEFORE_COLUMN_INIT, name);
        this.setup(this.afterColInit, type, AFTER_COLUMN_INIT, name);
        if (this.context.getDataset().getGroups() != null) {
            JRGroup[] jRGroupArray = this.context.getDataset().getGroups();
            int n = jRGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                JRGroup gr = jRGroupArray[n2];
                String n3 = gr.getName();
                this.setup(this.beforeGroupInit, type, BEFORE_GROUP_INIT + n3 + ".", name);
                this.setup(this.afterGroupInit, type, AFTER_GROUP_INIT + n3 + ".", name);
                ++n2;
            }
        }
        this.setup(this.beforeDetEval, type, BEFORE_DETAIL_EVAL, name);
        this.setup(this.afterDetEval, type, AFTER_DETAIL_EVAL, name);
    }

    private void resetMaps() {
        this.trace = false;
        this.beforeRepInit.clear();
        this.afterRepInit.clear();
        this.beforePageInit.clear();
        this.afterPageInit.clear();
        this.beforeColInit.clear();
        this.afterColInit.clear();
        this.beforeGroupInit.clear();
        this.afterGroupInit.clear();
        this.beforeDetEval.clear();
        this.afterDetEval.clear();
    }

    public void beforeReportInit() throws JRScriptletException {
        JRParameter[] parameters;
        JRVariable[] variables;
        int n;
        this.resetMaps();
        JRField[] fields = this.context.getDataset().getFields();
        if (fields != null) {
            JRField[] jRFieldArray = fields;
            n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                JRField f = jRFieldArray[n2];
                this.initMaps(TYPE_FIELD, f.getName());
                ++n2;
            }
        }
        if ((variables = this.context.getDataset().getVariables()) != null) {
            JRVariable[] jRVariableArray = variables;
            int n3 = variables.length;
            n = 0;
            while (n < n3) {
                JRVariable v = jRVariableArray[n];
                this.initMaps(TYPE_VARIABLE, v.getName());
                ++n;
            }
        }
        if ((parameters = this.context.getDataset().getParameters()) != null) {
            JRParameter[] jRParameterArray = parameters;
            int n4 = parameters.length;
            int n5 = 0;
            while (n5 < n4) {
                JRParameter p = jRParameterArray[n5];
                this.initMaps(TYPE_PARAMETER, p.getName());
                ++n5;
            }
        }
        this.show(BEFORE_REPORT_INIT, this.beforeRepInit);
    }

    public void afterReportInit() throws JRScriptletException {
        this.show(AFTER_REPORT_INIT, this.afterRepInit);
    }

    public void beforePageInit() throws JRScriptletException {
        this.show(BEFORE_PAGE_INIT, this.beforePageInit);
    }

    public void afterPageInit() throws JRScriptletException {
        this.show(AFTER_PAGE_INIT, this.afterPageInit);
    }

    public void beforeColumnInit() throws JRScriptletException {
        this.show(BEFORE_COLUMN_INIT, this.beforeColInit);
    }

    public void afterColumnInit() throws JRScriptletException {
        this.show(AFTER_COLUMN_INIT, this.afterColInit);
    }

    public void beforeGroupInit(String groupName) throws JRScriptletException {
        this.show(BEFORE_GROUP_INIT + groupName + ".", this.beforeGroupInit);
    }

    public void afterGroupInit(String groupName) throws JRScriptletException {
        this.show(AFTER_GROUP_INIT + groupName + ".", this.afterGroupInit);
    }

    public void beforeDetailEval() throws JRScriptletException {
        this.show(BEFORE_DETAIL_EVAL, this.beforeDetEval);
    }

    public void afterDetailEval() throws JRScriptletException {
        this.show(AFTER_DETAIL_EVAL, this.afterDetEval);
    }
}

