/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.dnd;

import com.jaspersoft.studio.model.ANode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class NodeTransfer
extends ByteArrayTransfer {
    private static NodeTransfer instance = new NodeTransfer();
    private static final String TYPE_NAME = "node-transfer-format";
    private static final int TYPEID = NodeTransfer.registerType((String)"node-transfer-format");

    public static NodeTransfer getInstance() {
        return instance;
    }

    private NodeTransfer() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ANode[] fromByteArray(byte[] bytes) {
        try {
            if (bytes == null) {
                return null;
            }
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            int n = in.readInt();
            ANode[] gadgets = new ANode[n];
            int i = 0;
            while (true) {
                if (i >= n) {
                    return gadgets;
                }
                ANode gadget = this.readGadget(null, in);
                if (gadget == null) {
                    return null;
                }
                gadgets[i] = gadget;
                ++i;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        byte[] bytes = this.toByteArray((Object[])object);
        if (bytes != null) {
            super.javaToNative((Object)bytes, transferData);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        return this.fromByteArray(bytes);
    }

    private ANode readGadget(ANode parent, ObjectInputStream dataIn) throws IOException {
        try {
            return (ANode)dataIn.readObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected byte[] toByteArray(Object[] nodes) {
        byte[] bytes = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            try {
                ObjectOutputStream out = new ObjectOutputStream(byteOut);
                out.writeInt(nodes.length);
                int i = 0;
                while (i < nodes.length) {
                    if (nodes[i] instanceof ANode) {
                        this.writeNode((ANode)nodes[i], out);
                    }
                    ++i;
                }
                out.close();
                bytes = byteOut.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
                FileUtils.closeStream((Closeable)byteOut);
            }
        }
        finally {
            FileUtils.closeStream((Closeable)byteOut);
        }
        return bytes;
    }

    private void writeNode(ANode node, ObjectOutputStream dataOut) {
        try {
            dataOut.writeObject(node);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

