/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor;

import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class DeltaVisitor
implements IResourceDeltaVisitor {
    private EditorPart part;

    public DeltaVisitor(EditorPart part) {
        this.part = part;
    }

    public boolean visit(IResourceDelta delta) {
        IEditorInput editorInput = this.part.getEditorInput();
        IFile file = null;
        if (editorInput instanceof IFileEditorInput) {
            file = ((IFileEditorInput)editorInput).getFile();
        }
        if (delta == null || delta.getResource() == null || this.part == null || editorInput == null || file == null) {
            return true;
        }
        if (!delta.getResource().equals((Object)file)) {
            return true;
        }
        switch (delta.getKind()) {
            case 1: {
                break;
            }
            case 2: {
                if ((0x2000 & delta.getFlags()) == 0) {
                    UIUtils.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DeltaVisitor.this.part.getSite().getPage().closeEditor((IEditorPart)DeltaVisitor.this.part, false);
                        }
                    });
                    break;
                }
                this.changeInput(delta.getMovedToPath());
                break;
            }
            case 4: {
                if ((delta.getFlags() & 0x100) == 0 && (delta.getFlags() & 0x10000) == 0 && (delta.getFlags() & 0x40000) == 0) break;
                this.changeInput(delta.getFullPath());
            }
        }
        return true;
    }

    private void changeInput(IPath toPath) {
        final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(toPath);
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ISelectionProvider selectionProvider = DeltaVisitor.this.part.getSite().getSelectionProvider();
                    DeltaVisitor.this.part.init(DeltaVisitor.this.part.getEditorSite(), (IEditorInput)new FileEditorInput(newFile));
                    if (selectionProvider != null) {
                        DeltaVisitor.this.part.getSite().setSelectionProvider(selectionProvider);
                    }
                }
                catch (PartInitException e) {
                    UIUtils.showError((Throwable)e);
                }
            }
        });
    }
}

