/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor;

import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.editor.AMultiEditor;
import com.jaspersoft.studio.editor.report.CachedSelectionProvider;
import com.jaspersoft.studio.editor.report.CommonSelectionCacheProvider;
import com.jaspersoft.studio.editor.style.StyleTemplateEditor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.style.MStylesTemplate;
import com.jaspersoft.studio.model.style.StyleTemplateFactory;
import java.io.InputStream;
import java.util.HashSet;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import net.sf.jasperreports.engine.xml.JRXmlTemplateWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class JRtxEditor
extends AMultiEditor
implements CachedSelectionProvider {
    private StyleTemplateEditor styleEditor;
    private CommonSelectionCacheProvider selectionCache = new CommonSelectionCacheProvider();

    @Override
    public void doSaveParticipate(IProgressMonitor monitor) {
        this.styleEditor.doSave(monitor);
    }

    @Override
    protected void xml2model(InputStream in) {
        JRTemplate template = JRXmlTemplateLoader.load((InputStream)in);
        JasperDesign jd = new JasperDesign();
        jd.setJasperReportsContext((JasperReportsContext)this.jrContext);
        MRoot m = new MRoot(null, jd);
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        MStylesTemplate ms = new MStylesTemplate((ANode)m, file);
        ms.setValue(template);
        ms.setJasperConfiguration(this.jrContext);
        this.jrContext.setJasperDesign(jd);
        StyleTemplateFactory.createTemplateRoot(ms, new HashSet<String>(), file, (JRSimpleTemplate)template);
        this.setModel(m);
    }

    @Override
    protected String doModel2xml() throws Exception {
        JRSimpleTemplate report = (JRSimpleTemplate)this.model.getChildren().get(0).getValue();
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        this.jrContext.setProperty("net.sf.jasperreports.report.version", this.jrContext.getProperty("com.jaspersoft.studio.compatibility.version"));
        String xml = JRXmlTemplateWriter.writeTemplate((JasperReportsContext)this.jrContext, (JRTemplate)report, (String)JRXmlWriterHelper.fixencoding(file.getCharset(true)));
        xml = xml.replaceFirst("<jasperTemplate ", "<!-- Created with Jaspersoft Studio -->\n<jasperTemplate ");
        return xml;
    }

    @Override
    public void setModel(INode model) {
        super.setModel(model);
        if (this.styleEditor != null) {
            this.styleEditor.setModel(model);
        }
    }

    @Override
    public INode getModel() {
        return this.model;
    }

    protected void createPages() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getContainer(), "com.jaspersoft.studio.doc.editor_jrtx");
        this.createPage0();
        this.createPageXML();
    }

    void createPage0() {
        try {
            this.styleEditor = new StyleTemplateEditor(this.jrContext);
            int index = this.addPage((IEditorPart)this.styleEditor, this.getEditorInput());
            this.setPageText(index, "Preview");
        }
        catch (PartInitException e) {
            UIUtils.showError((Throwable)e);
        }
    }

    @Override
    public CommonSelectionCacheProvider getSelectionCache() {
        return this.selectionCache;
    }
}

