/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.CommandMessage;
import com.jaspersoft.studio.editor.action.MessageProviderCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class CustomDeleteAction
extends DeleteAction {
    public static final String CANCEL_OPERATION_KEY = "cancelOperation";
    public static final String IS_CALCULATING_ENABLE = "calculatingEnable";

    public CustomDeleteAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
    }

    private ANode getModel() {
        List objects = this.getSelectedObjects();
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof EditPart)) {
            return null;
        }
        int i = 0;
        while (i < objects.size()) {
            EditPart object = (EditPart)objects.get(i);
            if (object.getModel() instanceof ANode) {
                return (ANode)object.getModel();
            }
            ++i;
        }
        return null;
    }

    private boolean isPartDescendent(ANode child, ANode possibileParent) {
        ANode parent = child.getParent();
        while (parent != null) {
            if (parent == possibileParent) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    protected boolean reorderPart(ArrayList<EditPart> selectedParts) {
        if (selectedParts.size() <= 1) {
            return false;
        }
        int i = 0;
        while (i < selectedParts.size()) {
            int j = i + 1;
            while (j < selectedParts.size()) {
                ANode model1 = (ANode)selectedParts.get(i).getModel();
                ANode model2 = (ANode)selectedParts.get(j).getModel();
                if (this.isPartDescendent(model2, model1)) {
                    EditPart part = selectedParts.remove(j);
                    selectedParts.add(i, part);
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    protected List<EditPart> getOrderedSelectedObjects() {
        List selectedObject = super.getSelectedObjects();
        ArrayList<EditPart> selectedParts = new ArrayList<EditPart>();
        for (Object obj : selectedObject) {
            selectedParts.add((EditPart)obj);
        }
        while (this.reorderPart(selectedParts)) {
        }
        return selectedParts;
    }

    public CompoundCommand createDeleteCommand(List objects, boolean isCalculatingEnabled) {
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof EditPart)) {
            return null;
        }
        GroupRequest deleteReq = new GroupRequest((Object)"delete");
        deleteReq.setEditParts(objects);
        deleteReq.getExtendedData().put(CANCEL_OPERATION_KEY, false);
        deleteReq.getExtendedData().put(IS_CALCULATING_ENABLE, isCalculatingEnabled);
        CompoundCommand compoundCmd = new CompoundCommand();
        int i = 0;
        while (i < objects.size()) {
            EditPart object = (EditPart)objects.get(i);
            Command cmd = object.getCommand((Request)deleteReq);
            if (Boolean.TRUE.equals(deleteReq.getExtendedData().get(CANCEL_OPERATION_KEY))) {
                return null;
            }
            if (cmd != null) {
                compoundCmd.add(cmd);
            }
            ++i;
        }
        return compoundCmd;
    }

    protected boolean calculateEnabled() {
        CompoundCommand cmd = this.createDeleteCommand(this.getSelectedObjects(), true);
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void run() {
        CompoundCommand deleteCommandds = this.createDeleteCommand(this.getOrderedSelectedObjects(), false);
        if (deleteCommandds != null) {
            ANode model = this.getModel();
            EditPart treeEditPart = model.getTreeEditPart();
            if (treeEditPart != null) {
                treeEditPart.getViewer().deselectAll();
            }
            JSSCompoundCommand compCommand = new JSSCompoundCommand(deleteCommandds, model);
            StringBuilder messages = new StringBuilder();
            messages.append(String.valueOf(Messages.CustomDeleteAction_messageListStart) + "\n");
            boolean messageFound = false;
            for (Command oCommand : compCommand.getCommands()) {
                MessageProviderCommand messageCommand;
                CommandMessage message;
                if (!(oCommand instanceof MessageProviderCommand) || (message = (messageCommand = (MessageProviderCommand)oCommand).getMessage()) == null) continue;
                messages.append(String.valueOf(message.getMessage()) + "\n");
                messageFound = true;
            }
            messages.append(Messages.CustomDeleteAction_messageListEnd);
            if (messageFound) {
                if (UIUtils.showConfirmation((String)Messages.ADatasetObjectDeleteCommand_confirmationtitle, (String)messages.toString())) {
                    this.execute((Command)compCommand);
                    this.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            } else {
                this.execute((Command)compCommand);
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
    }
}

