/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.band;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.IGraphicElementContainer;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class StretchToContentAction
extends SelectionAction {
    public static final String ID = "stretch2content";

    public StretchToContentAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
        this.setText(Messages.StretchToContentAction_name);
        this.setToolTipText(Messages.StretchToContentAction_tooltip);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/transparent_icon.png"));
        this.setEnabled(false);
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createReorderCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public Command createReorderCommand(List<?> objects) {
        Object model;
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        Object obj = objects.get(0);
        if (obj instanceof EditPart && (model = ((EditPart)obj).getModel()) instanceof ANode) {
            Command c;
            ANode n = (ANode)model;
            if (n instanceof MPage) {
                for (INode c2 : n.getChildren()) {
                    if (!(c2 instanceof MGraphicElement)) continue;
                    n = (ANode)c2;
                    break;
                }
            }
            if (!(n instanceof IGraphicElement)) {
                return null;
            }
            JRElementGroup container = this.getContainer(n);
            if (container == null) {
                return null;
            }
            APropertyNode mcontainer = this.getContainerNode(n);
            JSSCompoundCommand cc = new JSSCompoundCommand(this.getText(), (ANode)mcontainer);
            Dimension size = new Dimension(0, 0);
            if (container instanceof JRDesignFrame) {
                size = ModelUtils.getContainerSize(container.getChildren(), size);
                if (size.height > 0 && size.width > 0) {
                    SetValueCommand cmd = new SetValueCommand();
                    cmd.setTarget(mcontainer);
                    cmd.setPropertyId("width");
                    cmd.setPropertyValue(size.width);
                    cc.add(cmd);
                    cmd = new SetValueCommand();
                    cmd.setTarget(mcontainer);
                    cmd.setPropertyId("height");
                    cmd.setPropertyValue(size.height);
                    cc.add(cmd);
                }
            } else if (container instanceof JRDesignBand) {
                int bandHeight = ModelUtils.getBandHeight((JRBand)container);
                if (bandHeight > 0) {
                    SetValueCommand cmd = new SetValueCommand();
                    cmd.setTarget(mcontainer);
                    cmd.setPropertyId("height");
                    cmd.setPropertyValue(bandHeight);
                    cc.add(cmd);
                }
            } else if (n instanceof IGraphicElementContainer) {
                Command c3 = JaspersoftStudioPlugin.getExtensionManager().getStretchToContent(n);
                if (c3 != null) {
                    cc.add(c3);
                }
            } else if (n.getParent() instanceof IGraphicElementContainer && (c = JaspersoftStudioPlugin.getExtensionManager().getStretchToContent(n.getParent())) != null) {
                cc.add(c);
            }
            return cc;
        }
        return null;
    }

    private JRElementGroup getContainer(ANode n) {
        if (n != null) {
            Object val = n.getValue();
            if (n instanceof IGroupElement) {
                return ((IGroupElement)((Object)n)).getJRElementGroup();
            }
            if (val instanceof JRElementGroup) {
                return (JRElementGroup)val;
            }
            if (val instanceof JRDesignElement) {
                return this.getContainer(n.getParent());
            }
        }
        return null;
    }

    private APropertyNode getContainerNode(ANode n) {
        Object val = n.getValue();
        if (n instanceof IGroupElement) {
            return (APropertyNode)n;
        }
        if (val instanceof JRElementGroup) {
            if (n instanceof MElementGroup) {
                return this.getContainerNode(n.getParent());
            }
            return (APropertyNode)n;
        }
        if (val instanceof JRDesignElement) {
            return this.getContainerNode(n.getParent());
        }
        return null;
    }

    public void run() {
        this.execute(this.createReorderCommand(this.getSelectedObjects()));
    }
}

