/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.border;

import com.jaspersoft.studio.utils.ModelUtils;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class TemplateBorder {
    private Float lineWidth;
    private LineStyleEnum lineStyle;
    private Color color;
    private static int width;

    public TemplateBorder(Float lineWidth, LineStyleEnum lineStyle, RGB lineColor) {
        this.lineStyle = lineStyle;
        this.lineWidth = lineWidth;
        this.color = lineColor != null ? SWTResourceManager.getColor((RGB)lineColor) : ColorConstants.black;
    }

    public TemplateBorder(Float lineWidth, LineStyleEnum lineStyle) {
        this(lineWidth, lineStyle, null);
    }

    public RGB getColor() {
        return this.color != null ? this.color.getRGB() : null;
    }

    public LineStyleEnum getStyle() {
        return this.lineStyle;
    }

    public Float getLineWidth() {
        return this.lineWidth;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TemplateBorder) {
            TemplateBorder other = (TemplateBorder)obj;
            if (this.getLineWidth() == null && other.getLineWidth() == null || this.getLineWidth() != null && other.getLineWidth() != null && this.getLineWidth().floatValue() <= 0.0f && other.getLineWidth().floatValue() <= 0.0f) {
                return true;
            }
            boolean colorEquals = ModelUtils.safeEquals(this.getColor(), other.getColor());
            if (!colorEquals) {
                return false;
            }
            boolean widthEquals = ModelUtils.safeEquals(this.getLineWidth(), other.getLineWidth());
            if (!widthEquals) {
                return false;
            }
            boolean styleEquals = ModelUtils.safeEquals(this.getStyle(), other.getStyle());
            return styleEquals;
        }
        return false;
    }

    private Image getNoBordersImage() {
        String key = "linePreset_noBorders";
        Image image = ResourceManager.getImage((String)key);
        if (image == null) {
            ImageData data = new ImageData(TemplateBorder.getWidth(), 15, 1, new PaletteData(new RGB[]{ColorConstants.white.getRGB()}));
            image = new Image(null, data);
            GC graphics = new GC((Drawable)image);
            try {
                graphics.setFont(ResourceManager.getFont((String)"Time New Roman", (int)10, (int)0));
                graphics.drawString("No Borders", 5, 0);
            }
            finally {
                graphics.dispose();
            }
            ResourceManager.addImage((String)key, (Image)image);
        }
        return image;
    }

    public Image getImage() {
        if (this.lineWidth == null || this.lineWidth.floatValue() <= 0.0f) {
            return this.getNoBordersImage();
        }
        String key = "linePreset_" + this.lineStyle.toString() + this.lineWidth.toString() + this.getColor().toString();
        Image image = ResourceManager.getImage((String)key);
        if (image == null) {
            ImageData data = new ImageData(TemplateBorder.getWidth(), 20, 1, new PaletteData(new RGB[]{ColorConstants.white.getRGB()}));
            image = new Image(null, data);
            GC graphics = new GC((Drawable)image);
            try {
                int width = image.getBounds().width - 5;
                switch (this.lineStyle) {
                    case DASHED: {
                        graphics.setLineStyle(2);
                        break;
                    }
                    case DOTTED: {
                        graphics.setLineStyle(3);
                        break;
                    }
                    case SOLID: {
                        graphics.setLineStyle(1);
                        break;
                    }
                    default: {
                        graphics.setLineStyle(1);
                    }
                }
                graphics.setForeground(this.color);
                graphics.setLineWidth(Math.round(this.lineWidth.floatValue()));
                if (this.lineStyle == LineStyleEnum.DOUBLE) {
                    int startX = 5;
                    Float imageHeight = new Float(image.getBounds().height);
                    int startY1 = Math.round(imageHeight.floatValue() / 3.0f - this.lineWidth.floatValue() / 2.0f + this.lineWidth.floatValue() / 4.0f);
                    int startY2 = Math.round(imageHeight.floatValue() / 3.0f * 2.0f - this.lineWidth.floatValue() / 2.0f + this.lineWidth.floatValue() / 4.0f);
                    graphics.drawLine(startX, startY1, width, startY1);
                    graphics.drawLine(startX, startY2, width, startY2);
                } else {
                    int startX = 5;
                    Float imageHeight = new Float(image.getBounds().height);
                    int startY = Math.round(imageHeight.floatValue() / 2.0f - this.lineWidth.floatValue() / 2.0f);
                    graphics.drawLine(startX, startY, width, startY);
                }
            }
            finally {
                graphics.dispose();
            }
            ResourceManager.addImage((String)key, (Image)image);
        }
        return image;
    }

    public static Image getCustomImage() {
        String key = "linePreset_custom";
        Image image = ResourceManager.getImage((String)key);
        if (image == null) {
            ImageData data = new ImageData(TemplateBorder.getWidth(), 15, 1, new PaletteData(new RGB[]{ColorConstants.white.getRGB()}));
            image = new Image(null, data);
            GC graphics = new GC((Drawable)image);
            try {
                graphics.setFont(ResourceManager.getFont((String)"Time New Roman", (int)10, (int)0));
                graphics.drawString("Custom", 5, 0);
            }
            finally {
                graphics.dispose();
            }
            ResourceManager.addImage((String)key, (Image)image);
        }
        return image;
    }

    public static void setWidth(int newWidth) {
        if (newWidth > 0) {
            width = newWidth;
        }
    }

    public static int getWidth() {
        if (width <= 0) {
            width = 70;
        }
        return width;
    }
}

