/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.copy;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class FixPositionCommand
extends Command {
    private MGraphicElement mge;
    private ANode originalParent;
    private ANode newParent;
    private Integer oldBandHeight = null;
    private JRDesignBand parentBand = null;
    private JasperReportsConfiguration jConfig;

    public FixPositionCommand(MGraphicElement mge, ANode originalParent, ANode newParent) {
        this.mge = mge;
        this.newParent = newParent;
        this.originalParent = originalParent;
        this.jConfig = mge.getJasperConfiguration();
    }

    public void execute() {
        JRDesignElement de = this.mge.getValue();
        if (this.originalParent == this.newParent || this.originalParent == null) {
            int xOffset = 5;
            int yOffset = 5;
            if (this.newParent.getValue() instanceof JRBand) {
                int maxBandHeight;
                JRBand band = (JRBand)this.newParent.getValue();
                Boolean resizeBandOnPaste = this.jConfig.getPropertyBoolean("resizeOnPaste", true);
                boolean fixXaxes = false;
                int height = de.getY() + yOffset + de.getHeight();
                if (band.getHeight() < height && !resizeBandOnPaste.booleanValue()) {
                    fixXaxes = true;
                    yOffset = 0;
                }
                Rectangle startingLocation = new Rectangle(de.getX() + xOffset, de.getY() + yOffset, de.getWidth(), de.getHeight());
                JRElement overlappingElement = this.getPerfectlyOverlappingChildren((JRElement)de, band, startingLocation);
                while (overlappingElement != null) {
                    xOffset = overlappingElement.getX() + 5 - de.getX();
                    if (!fixXaxes) {
                        int lastValidYOffset = yOffset;
                        yOffset = overlappingElement.getY() + 5 - de.getY();
                        height = de.getY() + yOffset + de.getHeight();
                        if (band.getHeight() < height && !resizeBandOnPaste.booleanValue()) {
                            fixXaxes = true;
                            yOffset = lastValidYOffset;
                        }
                    }
                    startingLocation = new Rectangle(de.getX() + xOffset, de.getY() + yOffset, de.getWidth(), de.getHeight());
                    overlappingElement = this.getPerfectlyOverlappingChildren((JRElement)de, band, startingLocation);
                }
                height = de.getY() + yOffset + de.getHeight();
                if (band.getHeight() < height && (maxBandHeight = ModelUtils.getMaxBandHeight((JRDesignBand)band, this.jConfig.getJasperDesign())) >= height) {
                    this.parentBand = (JRDesignBand)band;
                    this.oldBandHeight = band.getHeight();
                    this.parentBand.setHeight(height);
                }
            }
            de.setX(de.getX() + xOffset);
            de.setY(de.getY() + yOffset);
        }
    }

    public void undo() {
        if (this.parentBand != null && this.parentBand.getHeight() != this.oldBandHeight.intValue()) {
            this.parentBand.setHeight(this.oldBandHeight.intValue());
        }
    }

    private JRElement getPerfectlyOverlappingChildren(JRElement de, JRBand band, Rectangle newLocation) {
        for (JRChild child : band.getChildren()) {
            JRElement jrChild;
            Rectangle position;
            if (child == de || !(child instanceof JRElement) || !(position = new Rectangle((jrChild = (JRElement)child).getX(), jrChild.getY(), jrChild.getWidth(), jrChild.getHeight())).equals((Object)newLocation)) continue;
            return jrChild;
        }
        return null;
    }

    private Rectangle getOverlappingChildren(JRBand band, JRElement de, JasperDesign jd) {
        int availablePageSpace = jd.getPageWidth() - jd.getRightMargin();
        Rectangle newLocation = new Rectangle(de.getX() + de.getWidth(), de.getY(), de.getWidth(), de.getHeight());
        if (newLocation.x + newLocation.width > availablePageSpace) {
            return null;
        }
        for (JRChild child : band.getChildren()) {
            JRElement jrChild;
            Rectangle position;
            if (child != de && child instanceof JRElement && (position = new Rectangle((jrChild = (JRElement)child).getX(), jrChild.getY(), jrChild.getWidth(), jrChild.getHeight())).intersects(newLocation) && jrChild.getX() + jrChild.getWidth() >= newLocation.x + newLocation.width) {
                newLocation.setX(jrChild.getX() + jrChild.getWidth());
            }
            if (newLocation.x + newLocation.width <= availablePageSpace) continue;
            return null;
        }
        return newLocation;
    }
}

