/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.exporter.wizard;

import com.jaspersoft.studio.editor.action.exporter.IExportedResourceHandler;
import com.jaspersoft.studio.editor.action.exporter.IResourceDefinition;
import com.jaspersoft.studio.editor.action.exporter.wizard.DestinationPage;
import com.jaspersoft.studio.editor.action.exporter.wizard.ShowExportableWizardPage;
import com.jaspersoft.studio.messages.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.ZipUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ConfigurationExporterWizard
extends Wizard
implements IExportWizard {
    private ShowExportableWizardPage page0;
    private DestinationPage page1;

    public void addPages() {
        super.addPages();
        this.page0 = new ShowExportableWizardPage();
        this.addPage((IWizardPage)this.page0);
        this.page1 = new DestinationPage();
        this.addPage((IWizardPage)this.page1);
    }

    public boolean canFinish() {
        return this.page0.isPageComplete() && this.page1.isPageComplete();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        boolean doit = true;
        final File destinationFile = new File(this.page1.getDestinationPath());
        if (destinationFile.exists()) {
            if (!MessageDialog.openConfirm((Shell)UIUtils.getShell(), (String)Messages.ConfigurationExporterWizard_fileExistTitle, (String)Messages.ConfigurationExporterWizard_fileExistMessage)) {
                doit = false;
            } else {
                FileUtils.recursiveDelete((File)destinationFile);
            }
        }
        if (doit) {
            try {
                this.setNeedsProgressMonitor(true);
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Map<IExportedResourceHandler, List<IResourceDefinition>> selectedResources = ConfigurationExporterWizard.this.page0.getSelectedResources();
                        ArrayList<String> elementsToCompress = new ArrayList<String>();
                        monitor.beginTask("Exporting resources", selectedResources.keySet().size());
                        for (Map.Entry<IExportedResourceHandler, List<IResourceDefinition>> selectedEntry : selectedResources.entrySet()) {
                            IExportedResourceHandler exporter = selectedEntry.getKey();
                            File elementToCompress = exporter.exportContentFolder(selectedEntry.getValue());
                            if (elementToCompress != null) {
                                elementsToCompress.add(elementToCompress.getAbsolutePath());
                            }
                            monitor.worked(1);
                        }
                        ZipUtils zipUtils = new ZipUtils();
                        zipUtils.zipFiles(elementsToCompress, destinationFile.getAbsolutePath());
                        for (String compressedFolder : elementsToCompress) {
                            FileUtils.recursiveDelete((File)new File(compressedFolder));
                        }
                        monitor.done();
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return doit;
    }
}

