/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.image;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.action.IGlobalAction;
import com.jaspersoft.studio.jface.dialogs.ImageSelectionDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.image.MImage;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class ChangeImageExpression
extends ACachedSelectionAction
implements IGlobalAction {
    private MImage imageModel;
    public static final String ID = "ActionImageChangeExpression";

    public ChangeImageExpression(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(Messages.ImageContributionItem_actionName);
        this.setToolTipText(Messages.ImageContributionItem_actionName);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/blue-folder-open-image.png"));
        this.loadImageModel();
    }

    private void loadImageModel() {
        this.imageModel = null;
        List<Object> images = this.editor.getSelectionCache().getSelectionModelForType(MImage.class);
        if (!images.isEmpty()) {
            this.imageModel = (MImage)images.get(0);
        }
    }

    @Override
    protected boolean calculateEnabled() {
        return this.imageModel != null;
    }

    protected void setSelection(ISelection selection) {
        super.setSelection(selection);
        this.loadImageModel();
    }

    public static void setImageExpression(MImage imageModel) {
        if (imageModel != null) {
            ImageSelectionDialog d = new ImageSelectionDialog(UIUtils.getShell());
            JRDesignExpression expr = (JRDesignExpression)imageModel.getPropertyValue("expression");
            if (expr != null) {
                d.setFileExpressionText(expr.getText());
            }
            d.configureDialog(imageModel.getJasperConfiguration());
            if (d.open() == 0) {
                JRDesignExpression imageExpression = d.getFileExpression();
                if (imageExpression == null) {
                    imageModel.setPropertyValue("expression", "");
                } else {
                    imageModel.setPropertyValue("expression", imageExpression.getText());
                }
                JSSCompoundCommand.forceRefreshVisuals(imageModel);
            }
        }
    }

    @Override
    public void run() {
        ChangeImageExpression.setImageExpression(this.imageModel);
    }
}

