/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.json;

import com.jaspersoft.studio.editor.action.json.JSONAction;
import com.jaspersoft.studio.editor.gef.decorator.json.PathAndDataDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class JSONPathDataAction
extends JSONAction {
    private String path;
    private JRExpression data;
    private boolean repeat = false;
    public static final String JSON_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.json.";
    public static final String JSON_EXPORTER_PATH_PROPERTY = "net.sf.jasperreports.export.json.path";
    public static final String JSON_EXPORTER_REPEAT_VALUE_PROPERTY = "net.sf.jasperreports.export.json.repeat.value";
    public static final String JSON_EXPORTER_DATA_PROPERTY = "net.sf.jasperreports.export.json.data";

    public JSONPathDataAction(IWorkbenchPart part) {
        super(part, JSON_EXPORTER_PATH_PROPERTY, Messages.JSONPathDataAction_0);
    }

    @Override
    public void run() {
        boolean dialogResult;
        if (this.checkFrameParent() && !(dialogResult = MessageDialog.openQuestion((Shell)UIUtils.getShell(), (String)Messages.JSONPathDataAction_1, (String)Messages.JSONPathDataAction_2))) {
            return;
        }
        MTextElement element = this.getSelectedElement();
        if (element == null) {
            return;
        }
        PathAndDataDialog dialog = new PathAndDataDialog(UIUtils.getShell(), element);
        if (dialog.open() == 0) {
            this.path = dialog.getName();
            this.data = dialog.getData();
            this.repeat = dialog.isRepeat();
            this.execute(this.createCommand());
        }
    }

    private MTextElement getSelectedElement() {
        List<Object> textElements = this.editor.getSelectionCache().getSelectionModelForType(MTextElement.class);
        if (textElements.isEmpty() || textElements.size() != this.getSelectedObjects().size()) {
            return null;
        }
        return (MTextElement)textElements.get(0);
    }

    @Override
    public boolean isChecked() {
        List<Object> textElements = this.editor.getSelectionCache().getSelectionModelForType(MTextElement.class);
        if (textElements.isEmpty() || textElements.size() != this.getSelectedObjects().size()) {
            return false;
        }
        Iterator<Object> iterator = textElements.iterator();
        if (iterator.hasNext()) {
            Object element = iterator.next();
            MTextElement model = (MTextElement)element;
            JRPropertiesMap colDataMap = model.getPropertiesMap();
            return colDataMap.containsProperty(JSON_EXPORTER_PATH_PROPERTY);
        }
        return true;
    }

    private boolean checkFrameParent() {
        List<Object> textElements = this.editor.getSelectionCache().getSelectionModelForType(MTextElement.class);
        if (textElements.isEmpty() || this.getSelectedObjects().size() > 1) {
            return false;
        }
        MTextElement element = (MTextElement)textElements.get(0);
        return element.getParent() instanceof MFrame;
    }

    @Override
    protected boolean calculateEnabled() {
        return !this.editor.getSelectionCache().getSelectionModelForType(MTextElement.class).isEmpty();
    }

    @Override
    protected Command createCommand() {
        MTextElement n = this.getSelectedElement();
        if (n == null) {
            return null;
        }
        PropertyExpressionsDTO peDTO = (PropertyExpressionsDTO)n.getPropertyValue("propertyExpressions");
        if (this.path == null) {
            peDTO.removeProperty(JSON_EXPORTER_PATH_PROPERTY, false);
            peDTO.removeProperty(JSON_EXPORTER_REPEAT_VALUE_PROPERTY, false);
            this.removeDataPropertyExpression(peDTO);
        } else {
            peDTO.setProperty(JSON_EXPORTER_PATH_PROPERTY, this.path, false, false);
            if (this.repeat) {
                peDTO.setProperty(JSON_EXPORTER_REPEAT_VALUE_PROPERTY, "true", false, false);
            } else {
                peDTO.removeProperty(JSON_EXPORTER_REPEAT_VALUE_PROPERTY, false);
            }
        }
        if (this.data == null) {
            this.removeDataPropertyExpression(peDTO);
        } else {
            PropertyExpressionDTO dpe = peDTO.getProperty(JSON_EXPORTER_DATA_PROPERTY, true);
            if (dpe == null) {
                peDTO.addProperty(JSON_EXPORTER_DATA_PROPERTY, this.data.getText(), true, false);
            } else {
                dpe.setValue(this.data.getText());
            }
        }
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget(n);
        cmd.setDebugLabel(this.getText());
        cmd.setPropertyId("propertyExpressions");
        cmd.setPropertyValue(peDTO);
        return cmd;
    }

    protected void removeDataPropertyExpression(PropertyExpressionsDTO peDTO) {
        peDTO.removeProperty(JSON_EXPORTER_DATA_PROPERTY, true);
    }
}

