/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.layout;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutCommand;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.IGraphicElementContainer;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class LayoutAction
extends SelectionAction {
    public static final String ID = "LayoutGroup";
    private ILayout layout;

    public LayoutAction(IWorkbenchPart part, Class<?> type) {
        super(part);
        this.setLazyEnablementCalculation(true);
        this.layout = LayoutManager.instLayout(type.getName());
        this.setText(this.layout.getName());
        this.setToolTipText(this.layout.getToolTip());
        this.setId(type.getName());
        if (this.layout.getIcon() != null) {
            this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor(this.layout.getIcon()));
            this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor(this.layout.getIcon()));
        }
        this.setEnabled(false);
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createReorderCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public Command createReorderCommand(List<?> objects) {
        Object model;
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        Object obj = objects.get(0);
        if (obj instanceof EditPart && (model = ((EditPart)obj).getModel()) instanceof ANode) {
            ANode n = (ANode)model;
            if (n instanceof MPage) {
                for (INode c : n.getChildren()) {
                    if (!(c instanceof MGraphicElement)) continue;
                    n = (ANode)c;
                    break;
                }
            }
            if (!(n instanceof IGraphicElement)) {
                return null;
            }
            JRElementGroup container = this.getContainer(n);
            if (container == null) {
                return null;
            }
            Dimension size = null;
            if (container instanceof JRDesignElement) {
                size = LayoutManager.getPaddedSize((JRCommonElement)((JRDesignElement)container));
            } else if (container instanceof JRDesignBand) {
                int h = ((JRDesignBand)container).getHeight();
                JasperDesign jDesign = n.getJasperDesign();
                int w = jDesign.getPageWidth() - jDesign.getLeftMargin() - jDesign.getRightMargin();
                size = new Dimension(w, h);
            } else if (n instanceof IGraphicElementContainer) {
                size = LayoutManager.getPaddedSize((IGraphicElementContainer)((Object)n));
            } else if (n.getParent() instanceof IGraphicElementContainer) {
                IGraphicElementContainer prnt = (IGraphicElementContainer)((Object)n.getParent());
                size = LayoutManager.getPaddedSize(prnt);
            }
            APropertyNode mcontainer = this.getContainerNode(n);
            JSSCompoundCommand cc = new JSSCompoundCommand(this.getText(), (ANode)mcontainer);
            if (mcontainer.getValue() instanceof JRPropertiesHolder) {
                JRPropertiesMap pmap = (JRPropertiesMap)mcontainer.getPropertyValue("PROPERTY_MAP");
                pmap = (JRPropertiesMap)pmap.clone();
                pmap.setProperty("com.jaspersoft.studio.layout", this.layout.getClass().getName());
                SetValueCommand c = new SetValueCommand();
                c.setTarget(mcontainer);
                c.setPropertyId("PROPERTY_MAP");
                c.setPropertyValue(pmap);
                cc.add(c);
            } else if (mcontainer.getValue() instanceof JRBaseElement) {
                String uuid = ((JRBaseElement)mcontainer.getValue()).getUUID().toString();
                INode root = mcontainer.getRoot();
                if (root != null && n instanceof MReport) {
                    MReport mrep = (MReport)n;
                    JRPropertiesMap pmap = (JRPropertiesMap)mrep.getPropertyValue("PROPERTY_MAP");
                    pmap = (JRPropertiesMap)pmap.clone();
                    pmap.setProperty("com.jaspersoft.studio.layout." + uuid, this.layout.getClass().getName());
                    SetValueCommand c = new SetValueCommand();
                    c.setTarget((MReport)root);
                    c.setPropertyId("PROPERTY_MAP");
                    c.setPropertyValue(pmap);
                    cc.add(c);
                }
            }
            cc.add(new LayoutCommand(n.getJasperDesign(), container, this.layout, size));
            return cc;
        }
        return null;
    }

    private JRElementGroup getContainer(ANode n) {
        if (n != null) {
            Object val = n.getValue();
            if (n instanceof IGroupElement) {
                return ((IGroupElement)((Object)n)).getJRElementGroup();
            }
            if (val instanceof JRElementGroup) {
                return (JRElementGroup)val;
            }
            if (val instanceof JRDesignElement) {
                return this.getContainer(n.getParent());
            }
        }
        return null;
    }

    private APropertyNode getContainerNode(ANode n) {
        Object val = n.getValue();
        if (n instanceof IGroupElement) {
            return (APropertyNode)n;
        }
        if (val instanceof JRElementGroup) {
            if (n instanceof MElementGroup) {
                return this.getContainerNode(n.getParent());
            }
            return (APropertyNode)n;
        }
        if (val instanceof JRDesignElement) {
            return this.getContainerNode(n.getParent());
        }
        return null;
    }

    public void run() {
        this.execute(this.createReorderCommand(this.getSelectedObjects()));
    }
}

