/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.order;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.action.IGlobalAction;
import com.jaspersoft.studio.editor.action.order.OrderUtil;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class BringToFrontAction
extends ACachedSelectionAction
implements IGlobalAction {
    public static final String ID = "bring_front";

    public BringToFrontAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
    }

    @Override
    public Command createCommand() {
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty()) {
            return null;
        }
        OrderUtil.reorderReverseElements(graphicalElements);
        JSSCompoundCommand compoundCmd = new JSSCompoundCommand("Bring To Front", null);
        int j = 0;
        for (Object model : graphicalElements) {
            Command cmd = null;
            ANode parent = ((MGraphicElement)model).getParent();
            compoundCmd.setReferenceNodeIfNull(parent);
            if (parent == null) continue;
            int newIndex = parent.getChildren().size() - 1;
            if (parent.getChildren().indexOf(model) < parent.getChildren().size() - 1) {
                cmd = OutlineTreeEditPartFactory.getReorderCommand((ANode)model, parent, newIndex - j);
                ++j;
            } else {
                return null;
            }
            if (cmd == null) continue;
            compoundCmd.add(cmd);
        }
        return compoundCmd;
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
    }

    protected void init() {
        super.init();
        this.setText(Messages.BringToFrontAction_bring_to_front);
        this.setToolTipText(Messages.BringToFrontAction_bring_to_front_tool_tip);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/eclipseapps/elcl16/bring_to_front.gif"));
        this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/formatting/bring_to_front.gif"));
        this.setEnabled(false);
    }
}

