/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.order;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class OrderUtil {
    public static void reorderElements(List<Object> elements) {
        Collections.sort(elements, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                MGraphicElement ge1 = (MGraphicElement)o1;
                MGraphicElement ge2 = (MGraphicElement)o2;
                ANode p1 = ge1.getParent();
                ANode p2 = ge2.getParent();
                if (p1 == null && p2 == null) {
                    return 0;
                }
                if (p1 == null) {
                    return 1;
                }
                if (p2 == null) {
                    return -1;
                }
                if (p1.hashCode() < p2.hashCode()) {
                    return -1;
                }
                if (p1.hashCode() > p2.hashCode()) {
                    return 1;
                }
                if (p1.getChildren().indexOf(ge1) > p2.getChildren().indexOf(ge2)) {
                    return 1;
                }
                if (p1.getChildren().indexOf(ge1) < p2.getChildren().indexOf(ge2)) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public static void reorderReverseElements(List<Object> elements) {
        OrderUtil.reorderElements(elements);
        Collections.reverse(elements);
    }
}

