/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.snap;

import com.jaspersoft.studio.editor.action.snap.AResourcePreferenceAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class SizeGridAction
extends AResourcePreferenceAction {
    public static final String ID = "sizegridaction";

    public SizeGridAction(JasperReportsConfiguration jrConfig) {
        super(jrConfig);
        this.setText(Messages.SizeGridAction_set_grid_size);
        this.setToolTipText(Messages.SizeGridAction_set_grid_size_tool_tip);
        this.setId(ID);
    }

    @Override
    protected void doRun() throws Exception {
        int x = this.getStore().getInt("pageRulerGrid_GRIDSPACEX");
        int y = this.getStore().getInt("pageRulerGrid_GRIDSPACEY");
        SizeDialog dlg = new SizeDialog(UIUtils.getShell(), new Dimension(x, y));
        if (dlg.open() == 0) {
            ScopedPreferenceStore store = this.getStore();
            store.setValue("pageRulerGrid_GRIDSPACEX", dlg.getWidth());
            store.setValue("pageRulerGrid_GRIDSPACEY", dlg.getHeight());
            store.save();
        }
    }

    private final class SizeDialog
    extends FormDialog {
        private int w;
        private int h;

        private SizeDialog(Shell shell, Dimension d) {
            super(shell);
            this.w = d.width;
            this.h = d.height;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.SizeGridAction_grid_editor);
        }

        protected void createFormContent(IManagedForm mform) {
            mform.getForm().setText(Messages.SizeGridAction_grid_size);
            FormToolkit toolkit = mform.getToolkit();
            mform.getForm().getBody().setLayout((Layout)new GridLayout(4, false));
            toolkit.createLabel(mform.getForm().getBody(), String.valueOf(Messages.SizeGridAction_spacing_x) + ":");
            final Spinner width = new Spinner(mform.getForm().getBody(), 2048);
            width.setValues(this.w, 0, Integer.MAX_VALUE, 0, 1, 10);
            width.setToolTipText(Messages.SizeGridAction_grid_space_width_tool_tip);
            width.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SizeDialog.this.w = width.getSelection();
                }
            });
            toolkit.createLabel(mform.getForm().getBody(), String.valueOf(Messages.SizeGridAction_spacing_y) + ":");
            final Spinner height = new Spinner(mform.getForm().getBody(), 2048);
            height.setValues(this.h, 0, Integer.MAX_VALUE, 0, 1, 10);
            height.setToolTipText(Messages.SizeGridAction_grid_space_height_tool_tip);
            height.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SizeDialog.this.h = height.getSelection();
                }
            });
        }

        public int getWidth() {
            return this.w;
        }

        public int getHeight() {
            return this.h;
        }
    }
}

