/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.text;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.property.SetValueCommand;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class ABooleanPropertyAction
extends ACachedSelectionAction {
    private ModelListener modelListener = new ModelListener();

    public ABooleanPropertyAction(IWorkbenchPart part) {
        super(part, 2);
    }

    public boolean isChecked() {
        List<Object> textElements = this.editor.getSelectionCache().getSelectionModelForType(MTextElement.class);
        if (textElements.isEmpty()) {
            return false;
        }
        return this.getBooleanValue(textElements.get(0));
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
        this.setChecked(!this.isChecked());
    }

    @Override
    protected Command createCommand() {
        List<Object> textElements = this.editor.getSelectionCache().getSelectionModelForType(MTextElement.class);
        if (textElements.isEmpty() || textElements.size() != this.getSelectedObjects().size()) {
            return null;
        }
        boolean checked = !this.isChecked();
        JSSCompoundCommand cc = new JSSCompoundCommand(this.getText(), null);
        for (Object element : textElements) {
            cc.setReferenceNodeIfNull(element);
            cc.add(this.createCommand(element, checked));
        }
        return cc;
    }

    protected abstract Object getPropertyName();

    protected boolean getBooleanValue(Object obj) {
        Object res = ((APropertyNode)obj).getPropertyActualValue(this.getPropertyName());
        if (res instanceof Boolean) {
            return (Boolean)res;
        }
        return false;
    }

    protected Command createCommand(Object model, Object v) {
        if (!(model instanceof IPropertySource)) {
            return null;
        }
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget((IPropertySource)model);
        cmd.setPropertyId(this.getPropertyName());
        cmd.setPropertyValue(v);
        return cmd;
    }

    protected void setSelection(ISelection selection) {
        List<Object> nodes = this.editor.getSelectionCache().getSelectionModelForType(APropertyNode.class);
        for (Object node : nodes) {
            ((APropertyNode)node).getPropertyChangeSupport().removePropertyChangeListener(this.modelListener);
        }
        super.setSelection(selection);
        for (Object node : nodes) {
            ((APropertyNode)node).getPropertyChangeSupport().addPropertyChangeListener(this.modelListener);
        }
    }

    @Override
    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        this.setChecked(this.isChecked());
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ABooleanPropertyAction.this.refresh();
        }
    }
}

