/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.text;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.text.MStaticText;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.engine.util.JRTextMeasurerUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class AdjustTextFontSize
extends ACachedSelectionAction {
    public static final String ID = "AdjustTextFontSize";

    public AdjustTextFontSize(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(Messages.AdjustTextFontSize_action_name);
        this.setToolTipText(Messages.AdjustTextFontSize_action_tooltip);
    }

    private Float getTextSize(JRStaticText textElement, JasperReportsConfiguration jConfig) {
        String text = textElement.getText();
        return this.getTextSize((JRTextElement)textElement, text, jConfig);
    }

    private Float getTextSize(JRTextField textElement, JasperReportsConfiguration jConfig) {
        String text = textElement.getExpression().getText();
        return this.getTextSize((JRTextElement)textElement, text, jConfig);
    }

    private Float getTextSize(JRTextElement textElement, String text, JasperReportsConfiguration jConfig) {
        JRTextMeasurer measurer = JRTextMeasurerUtil.getInstance((JasperReportsContext)jConfig).createTextMeasurer((JRCommonText)textElement, null);
        HashMap<TextAttribute, Float> attributes = new HashMap<TextAttribute, Float>();
        FontUtil.getInstance((JasperReportsContext)jConfig).getAttributesWithoutAwtFont(attributes, (JRFont)textElement);
        JRStyledText styledText = JRStyledTextParser.getInstance().getStyledText(attributes, text, !"none".equals(textElement.getMarkup()), Locale.getDefault());
        styledText = JRStyledTextUtil.getInstance((JasperReportsContext)jConfig).resolveFonts(styledText, Locale.getDefault());
        JRMeasuredText measuredText = measurer.measure(styledText, 0, textElement.getHeight(), false, false);
        float currentSize = textElement.getFontsize();
        float originalSize = textElement.getFontsize();
        if (measuredText.getTextWidth() > (float)textElement.getWidth() || measuredText.getTextHeight() > (float)textElement.getHeight()) {
            do {
                attributes.put(TextAttribute.SIZE, Float.valueOf(currentSize -= 1.0f));
                styledText.setGlobalAttributes(attributes);
            } while ((measuredText = measurer.measure(styledText, 0, textElement.getHeight(), false, false)).getTextWidth() > (float)textElement.getWidth() || measuredText.getTextHeight() > (float)textElement.getHeight());
        } else {
            do {
                attributes.put(TextAttribute.SIZE, Float.valueOf(currentSize += 1.0f));
                styledText.setGlobalAttributes(attributes);
                measuredText = measurer.measure(styledText, 0, textElement.getHeight(), false, false);
                if (measuredText.getTextWidth() != 0.0f && measuredText.getTextHeight() != 0.0f) continue;
                return null;
            } while (measuredText.getTextWidth() < (float)textElement.getWidth() && measuredText.getTextHeight() < (float)textElement.getHeight());
            currentSize -= 1.0f;
        }
        return !ModelUtils.safeEquals(Float.valueOf(originalSize), Float.valueOf(currentSize)) ? Float.valueOf(currentSize) : null;
    }

    @Override
    protected Command createCommand() {
        List<Object> editparts = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (editparts.isEmpty()) {
            return null;
        }
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        for (Object part : editparts) {
            if (!(part instanceof MTextElement)) continue;
            MTextElement textElement = (MTextElement)part;
            command.setReferenceNodeIfNull(textElement);
            LazyCreateTextFieldCommand createCommand = new LazyCreateTextFieldCommand(textElement);
            command.add(createCommand);
        }
        if (command.isEmpty()) {
            return null;
        }
        return command;
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
    }

    private class LazyCreateTextFieldCommand
    extends Command {
        private SetValueCommand cmd = null;
        private MTextElement textElement;

        public LazyCreateTextFieldCommand(MTextElement elementToCopy) {
            this.textElement = elementToCopy;
        }

        public void execute() {
            Float fontSize = null;
            if (this.textElement instanceof MStaticText) {
                JRDesignStaticText labelObject = (JRDesignStaticText)this.textElement.getValue();
                fontSize = AdjustTextFontSize.this.getTextSize((JRStaticText)labelObject, this.textElement.getJasperConfiguration());
            } else if (this.textElement instanceof MTextField) {
                JRDesignTextField labelObject = (JRDesignTextField)this.textElement.getValue();
                fontSize = AdjustTextFontSize.this.getTextSize((JRTextField)labelObject, this.textElement.getJasperConfiguration());
            }
            if (fontSize != null) {
                this.cmd = new SetValueCommand();
                this.cmd.setTarget(this.textElement);
                this.cmd.setPropertyValue(fontSize);
                this.cmd.setPropertyId("fontSize");
                this.cmd.execute();
            }
        }

        public void undo() {
            this.cmd.undo();
            this.cmd = null;
        }

        public boolean canExecute() {
            return this.textElement != null;
        }

        public boolean canUndo() {
            return this.cmd != null;
        }
    }
}

