/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.xls;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.CustomSelectionAction;
import com.jaspersoft.studio.editor.action.pdf.PropertiesList;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class XLSActionList
extends CustomSelectionAction {
    private String[] values;
    private String[] attributeIds;
    private int actionCheckId;

    public XLSActionList(IWorkbenchPart part, String actionId, String[] attributeIds, String value, String actionName) {
        this(part, actionId, attributeIds, XLSActionList.initializeValuesArray(value, attributeIds.length), actionName);
    }

    public XLSActionList(IWorkbenchPart part, String actionId, String[] attributeIds, String[] values, String actionName) {
        super(part);
        this.attributeIds = attributeIds;
        this.setId(actionId);
        PropertiesList.addItem(actionId);
        this.setText(actionName);
        this.values = values;
        this.actionCheckId = -1;
    }

    public XLSActionList(IWorkbenchPart part, String actionId, String[] attributeIds, String[] values, String actionName, int actionCheckId) {
        super(part, 2);
        this.attributeIds = attributeIds;
        this.setId(actionId);
        PropertiesList.addItem(actionId);
        this.setText(actionName);
        this.values = values;
        this.actionCheckId = actionCheckId;
    }

    public boolean isChecked() {
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty() || this.actionCheckId == -1) {
            return false;
        }
        String attributeId = this.attributeIds[this.actionCheckId];
        for (Object element : graphicalElements) {
            MGraphicElement model = (MGraphicElement)element;
            JRPropertiesMap v = (JRPropertiesMap)model.getPropertyValue("PROPERTY_MAP");
            if (v == null) {
                return false;
            }
            String oldValue = v.getProperty(attributeId);
            if (oldValue != null && oldValue.equals(this.values[this.actionCheckId])) continue;
            return false;
        }
        return true;
    }

    private static String[] initializeValuesArray(String value, int lenght) {
        String[] result = new String[lenght];
        int i = 0;
        while (i < lenght) {
            result[i] = value;
            ++i;
        }
        return result;
    }

    public Command createCommand(MGraphicElement model) {
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget(model);
        cmd.setPropertyId("PROPERTY_MAP");
        JRPropertiesMap v = (JRPropertiesMap)model.getPropertyValue("PROPERTY_MAP");
        if (v == null) {
            v = new JRPropertiesMap();
            int i = 0;
            while (i < this.attributeIds.length) {
                v.setProperty(this.attributeIds[i], this.values[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.attributeIds.length) {
                String name = this.attributeIds[i];
                String value = this.values[i];
                v.removeProperty(name);
                if (value != null) {
                    v.setProperty(name, value);
                }
                ++i;
            }
        }
        cmd.setPropertyValue(v);
        return cmd;
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
    }

    @Override
    protected Command createCommand() {
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty()) {
            return null;
        }
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        command.setDebugLabel(this.getText());
        for (Object element : graphicalElements) {
            MGraphicElement graphElement = (MGraphicElement)element;
            command.add(this.createCommand(graphElement));
            command.setReferenceNodeIfNull(graphElement);
        }
        return command;
    }
}

