/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.context;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.editor.context.JSSClasspathListener;
import com.jaspersoft.studio.editor.context.JSSDefaultRepositoryService;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.utils.jasper.JSSFileRepositoryService;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.sf.jasperreports.eclipse.MScopedPreferenceStore;
import net.sf.jasperreports.eclipse.classpath.JavaProjectClassLoader;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.CompositeClassloader;
import net.sf.jasperreports.repo.DefaultRepositoryService;
import net.sf.jasperreports.repo.FileRepositoryPersistenceServiceFactory;
import net.sf.jasperreports.repo.FileRepositoryService;
import net.sf.jasperreports.repo.PersistenceServiceFactory;
import net.sf.jasperreports.repo.RepositoryService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class AEditorContext {
    public static final String NAME = "project";
    public static final String EDITOR_CONTEXT = "editor.context";
    protected IFile f;
    protected JasperReportsConfiguration jConf;
    private String id = "project";
    private List<RepositoryService> repositoryServices;
    private JSSDefaultRepositoryService jssDRepService;
    protected ClassLoader classLoader;
    protected JavaProjectClassLoader javaclassloader;
    protected JSSClasspathListener classpathlistener;

    public final void setId(String id) {
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    public boolean canHandleFile(IResource f) {
        return true;
    }

    public void init(IFile f, JasperReportsConfiguration jConf) {
        this.f = f;
        this.jConf = jConf;
    }

    public String getName() {
        return Messages.AEditorContext_2;
    }

    public void dispose() {
        if (this.javaclassloader != null) {
            this.javaclassloader.removeClasspathListener((PropertyChangeListener)this.classpathlistener);
        }
        this.jConf.remove("javaProjectClassLoader");
        this.jConf.remove("CURRENT_CLASS_LOADER");
    }

    public List<RepositoryService> getRepositoryServices() {
        return this.repositoryServices;
    }

    public void configureRepositoryService() {
        List<RepositoryService> list = this.jConf.getExtensions(RepositoryService.class);
        if (list == null) {
            list = new ArrayList<RepositoryService>();
        }
        if (this.f != null) {
            HashSet<RepositoryService> toDel = new HashSet<RepositoryService>();
            for (RepositoryService rs : list) {
                if (!(rs instanceof FileRepositoryService)) continue;
                toDel.add(rs);
            }
            list.removeAll(toDel);
            this.configRepositoryPaths(list);
        }
        this.setupProxy(list);
        this.repositoryServices = new ArrayList<RepositoryService>();
        this.repositoryServices.add(new JSSFileRepositoryService(this.jConf, list));
        this.jConf.setExtensions(RepositoryService.class, this.repositoryServices);
        List<PersistenceServiceFactory> persistenceServiceFactoryList = this.jConf.getExtensions(PersistenceServiceFactory.class);
        if (persistenceServiceFactoryList != null) {
            persistenceServiceFactoryList.add((PersistenceServiceFactory)FileRepositoryPersistenceServiceFactory.getInstance());
        }
        this.jConf.setExtensions(PersistenceServiceFactory.class, persistenceServiceFactoryList);
    }

    protected void configRepositoryPaths(List<RepositoryService> list) {
        HashSet<String> rset = new HashSet<String>();
        if (this.f.isLinked()) {
            this.add(list, rset, this.f.getRawLocation().toFile().getParentFile().getAbsolutePath());
        }
        this.add(list, rset, this.f.getProject().getLocation().toFile().getAbsolutePath());
    }

    public List<String> getRepositoryRoots() {
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.f.getProject().getLocation().toFile().getAbsolutePath());
        return res;
    }

    protected String add(List<RepositoryService> list, Set<String> rset, String root) {
        if (rset.contains(root)) {
            return null;
        }
        rset.add(root);
        list.add((RepositoryService)new FileRepositoryService((JasperReportsContext)this.jConf, root, true));
        return root;
    }

    protected void setupProxy(List<RepositoryService> rs) {
        int i = 0;
        while (i < rs.size()) {
            RepositoryService r = rs.get(i);
            if (r instanceof DefaultRepositoryService) {
                if (this.jssDRepService == null) {
                    this.jssDRepService = new JSSDefaultRepositoryService(this.jConf);
                }
                rs.set(i, (RepositoryService)this.jssDRepService);
                break;
            }
            ++i;
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void initClassloader() {
        if (this.javaclassloader != null && this.classpathlistener != null) {
            this.javaclassloader.removeClasspathListener((PropertyChangeListener)this.classpathlistener);
            this.jConf.remove("javaProjectClassLoader");
            this.jConf.remove("CURRENT_CLASS_LOADER");
        }
        try {
            IProject project;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (this.f != null && (project = this.f.getProject()) != null && project.exists() && project.getNature("org.eclipse.jdt.core.javanature") != null) {
                this.javaclassloader = JavaProjectClassLoader.instance((IJavaProject)JavaCore.create((IProject)project), (ClassLoader)cl);
                this.jConf.put("javaProjectClassLoader", this.javaclassloader);
                this.jConf.setValue("CURRENT_CLASS_LOADER", cl);
                this.classpathlistener = new JSSClasspathListener(this, this.jConf);
                this.javaclassloader.addClasspathListener((PropertyChangeListener)this.classpathlistener);
                cl = this.javaclassloader;
            }
            cl = JaspersoftStudioPlugin.getDriversManager().getClassLoader(cl);
            cl = new CompositeClassloader(cl, this.getClass().getClassLoader()){

                protected URL findResource(String name) {
                    if (name.endsWith("GroovyEvaluator.groovy")) {
                        return null;
                    }
                    return super.findResource(name);
                }

                protected Class<?> findClass(String className) throws ClassNotFoundException {
                    if (className.endsWith("GroovyEvaluator")) {
                        throw new ClassNotFoundException(className);
                    }
                    return super.findClass(className);
                }
            };
            this.setClassLoader(cl);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        List<RepositoryService> rs = this.jConf.getExtensions(RepositoryService.class);
        if (rs != null) {
            for (RepositoryService r : rs) {
                if (!(r instanceof DefaultRepositoryService)) continue;
                ((DefaultRepositoryService)r).setClassLoader(classLoader);
            }
        }
        this.jConf.put("CURRENT_CLASS_LOADER", classLoader);
    }

    public void refreshClasspath() {
        this.classpathlistener.propertyChange(null);
    }

    public Properties getJrProperties() {
        Properties props = null;
        MScopedPreferenceStore pStore = this.jConf.getPrefStore();
        try {
            try {
                pStore.setWithDefault(false);
                props = FileUtils.load((String)pStore.getString("net.sf.jasperreports.JRPROPERTIES"));
            }
            catch (IOException e) {
                e.printStackTrace();
                props = new Properties();
                pStore.setWithDefault(true);
            }
        }
        finally {
            pStore.setWithDefault(true);
        }
        return props;
    }

    public boolean needCompilation() {
        return true;
    }

    public boolean saveOnPreview() {
        return false;
    }

    public boolean hasBookmarks() {
        return true;
    }

    public boolean hasExporterSettings() {
        return true;
    }

    public boolean hasSortFields() {
        return true;
    }

    public String jrVersion() {
        return "any";
    }

    public boolean isDataAdapterStorage(ADataAdapterStorage storage) {
        return true;
    }

    public String getDataAdapterProperty() {
        return "com.jaspersoft.studio.data.defaultdataadapter";
    }

    public boolean hasNoDataAdapter() {
        return false;
    }

    public Boolean setDataAdapter(DataAdapterDescriptor myDataAdapterDesc, MReport mrep, boolean daAction) {
        if (!daAction) {
            return false;
        }
        if (myDataAdapterDesc != null) {
            JasperDesign jd = this.jConf.getJasperDesign();
            String oldp = jd.getProperty("com.jaspersoft.studio.data.defaultdataadapter");
            if (oldp == null || !oldp.equals(myDataAdapterDesc.getName())) {
                mrep.putParameter("com.jaspersoft.studio.data.defaultdataadapter", myDataAdapterDesc);
                jd.setProperty("com.jaspersoft.studio.data.defaultdataadapter", myDataAdapterDesc.getName());
                return true;
            }
        } else {
            mrep.getJasperDesign().removeProperty("com.jaspersoft.studio.data.defaultdataadapter");
            mrep.removeParameter("com.jaspersoft.studio.data.defaultdataadapter");
            return true;
        }
        return false;
    }

    public void setDataAdapter(DataAdapterDescriptor myDataAdapterDesc, JasperDesign jd) {
        if (myDataAdapterDesc != null) {
            jd.setProperty("com.jaspersoft.studio.data.defaultdataadapter", myDataAdapterDesc.getName());
        } else {
            jd.removeProperty("com.jaspersoft.studio.data.defaultdataadapter");
        }
    }

    public String getDefaultRunMode() {
        return "RUNLOCAL";
    }

    public boolean isAllowOtherRunners() {
        return true;
    }

    public boolean supportsDataSnapshots() {
        return true;
    }
}

