/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.defaults;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.editor.defaults.CustomStyleResolver;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.util.ReportFactory;
import com.jaspersoft.studio.preferences.util.PropertiesHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.digester.Digester;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DefaultManager {
    public static final DefaultManager INSTANCE = new DefaultManager();
    private Preferences prefs = PropertiesHelper.INSTANCE_SCOPE.getNode(JaspersoftStudioPlugin.getUniqueIdentifier());
    private static final String DEFAULT_KEY = "defaultValues";
    private List<String> availableDefaults;
    private String actualDefault = null;
    private INode defaultReport = null;
    private JasperReportsConfiguration defaultConfig = null;
    private HashMap<Class<?>, MGraphicElement> selectedDefaultsMap;
    private boolean disableDefaults = false;
    private IResourceChangeListener resourceDeletedListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            ArrayList<IFile> resourcesDeleted = new ArrayList<IFile>();
            if (event.getType() == 1) {
                DefaultManager.this.iterateResourceDelta(event.getDelta(), resourcesDeleted);
                for (IFile resource : resourcesDeleted) {
                    IPath resourceLocation = resource.getRawLocation();
                    if (resourceLocation == null) continue;
                    String resourceString = resourceLocation.toOSString();
                    DefaultManager.this.availableDefaults.remove(resourceString);
                    if (!resourceString.equals(DefaultManager.this.actualDefault)) continue;
                    DefaultManager.this.actualDefault = null;
                    DefaultManager.this.defaultReport = null;
                    DefaultManager.this.defaultConfig = null;
                }
                DefaultManager.this.savePreferences();
            }
        }
    };

    private DefaultManager() {
        this.initializeDefaultManager();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceDeletedListener);
    }

    private void savePreferences() {
        String xmlData = this.getXMLData();
        this.prefs.put(DEFAULT_KEY, xmlData);
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private String getXMLData() {
        String result = "<defaultReports>";
        for (String defaultReport : this.availableDefaults) {
            result = String.valueOf(result) + "<report path=\"" + defaultReport + "\" default=\"";
            result = String.valueOf(result) + defaultReport.equals(this.actualDefault) + "\"/>";
        }
        result = String.valueOf(result) + "</defaultReports>";
        return result;
    }

    private void initializeDefaultManager() {
        this.loadPreferences();
        if (this.actualDefault != null) {
            this.loadDefaultModel();
        }
    }

    private void loadPreferences() {
        String defaults = this.prefs.get(DEFAULT_KEY, "");
        this.availableDefaults = new ArrayList<String>();
        if (!defaults.isEmpty()) {
            try {
                Document document = JRXmlUtils.parse((InputSource)new InputSource(new StringReader(defaults)));
                NodeList adapterNodes = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < adapterNodes.getLength()) {
                    Node adapterNode = adapterNodes.item(i);
                    if (adapterNode.getNodeType() == 1) {
                        String path = adapterNode.getAttributes().getNamedItem("path").getNodeValue();
                        String defaultReport = adapterNode.getAttributes().getNamedItem("default").getNodeValue();
                        if (new File(path).exists()) {
                            this.availableDefaults.add(path);
                            if (Boolean.parseBoolean(defaultReport)) {
                                this.actualDefault = path;
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadDefaultModel() {
        block15: {
            InputStream in = null;
            this.selectedDefaultsMap = new HashMap();
            this.defaultReport = null;
            try {
                try {
                    File defaultFile = new File(this.actualDefault);
                    if (defaultFile.exists()) {
                        in = new ByteArrayInputStream(FileUtils.readFileToByteArray((File)defaultFile));
                        JasperReportsConfiguration jConfig = this.getDefaultJRConfig();
                        JasperDesign jd = new JRXmlLoader((JasperReportsContext)jConfig, (Digester)JRXmlDigesterFactory.createDigester((JasperReportsContext)jConfig)).loadXML(in);
                        jConfig.setJasperDesign(jd);
                        this.defaultReport = ReportFactory.createReport(jConfig);
                        this.defaultReport.getChildren().get(0).setValue(jd);
                        this.defaultConfig = jConfig;
                        this.setElementsType();
                    }
                }
                catch (Exception e) {
                    this.actualDefault = null;
                    this.defaultReport = null;
                    e.printStackTrace();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void iterateResourceDelta(IResourceDelta delta, List<IFile> deleteResources) {
        if (delta.getKind() == 2 && delta.getResource() instanceof IFile) {
            deleteResources.add((IFile)delta.getResource());
        }
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta affectedResource = iResourceDeltaArray[n2];
            this.iterateResourceDelta(affectedResource, deleteResources);
            ++n2;
        }
    }

    private JasperReportsConfiguration getDefaultJRConfig() {
        return new JasperReportsConfiguration((JasperReportsContext)DefaultJasperReportsContext.getInstance(), null);
    }

    private void setElementsType() {
        if (this.defaultReport == null || this.defaultReport.getChildren().isEmpty() || !(this.defaultReport instanceof MRoot)) {
            return;
        }
        for (INode node : this.defaultReport.getChildren().get(0).getChildren()) {
            MBand band;
            if (!(node instanceof MBand) || (band = (MBand)node).getBandType() != BandTypeEnum.DETAIL) continue;
            this.addAll(band);
            break;
        }
    }

    private void addAll(INode parent) {
        for (INode node : parent.getChildren()) {
            if (node instanceof MGraphicElement) {
                MGraphicElement graphicalNode = (MGraphicElement)node;
                CustomStyleResolver.copyInheritedAttributes(graphicalNode, graphicalNode.getValue());
                graphicalNode.setStyle(null);
                this.selectedDefaultsMap.put(node.getClass(), (MGraphicElement)node);
            }
            this.addAll(node);
        }
    }

    public boolean hasDefault() {
        return !this.disableDefaults && this.actualDefault != null && this.defaultReport != null;
    }

    public void applyDefault(Class<?> modelType, JRElement element) {
        MGraphicElement defaultSetter;
        if (INSTANCE.hasDefault() && (defaultSetter = this.selectedDefaultsMap.get(modelType)) != null) {
            defaultSetter.trasnferProperties(element);
        }
    }

    public void applySuperClassDefault(Class<?> modelType, JRElement element) {
        if (INSTANCE.hasDefault()) {
            MGraphicElement defaultSetter = null;
            for (Map.Entry<Class<?>, MGraphicElement> entry : this.selectedDefaultsMap.entrySet()) {
                if (!entry.getKey().isAssignableFrom(modelType)) continue;
                defaultSetter = entry.getValue();
                break;
            }
            if (defaultSetter != null) {
                defaultSetter.trasnferProperties(element);
            }
        }
    }

    public Object getDefaultPropertiesValue(Class<?> modelType, String propertyId) {
        MGraphicElement container;
        if (this.hasDefault() && (container = this.selectedDefaultsMap.get(modelType)) != null) {
            return container.getPropertyValue(propertyId);
        }
        return null;
    }

    public void setDefaultFile(String path) {
        String oldDefault = this.actualDefault;
        INode oldDefaultReport = this.defaultReport;
        JasperReportsConfiguration oldConfig = this.defaultConfig;
        HashMap<Class<?>, MGraphicElement> oldDefaultMap = this.selectedDefaultsMap;
        this.actualDefault = path;
        try {
            this.loadDefaultModel();
            this.savePreferences();
        }
        catch (Exception e) {
            this.actualDefault = oldDefault;
            this.defaultReport = oldDefaultReport;
            this.defaultConfig = oldConfig;
            this.selectedDefaultsMap = oldDefaultMap;
            e.printStackTrace();
        }
    }

    public void unsetDefaultFile() {
        this.actualDefault = null;
        this.defaultReport = null;
        this.defaultConfig = null;
        this.savePreferences();
    }

    public boolean isCurrentDefault(String path) {
        return path.equals(this.actualDefault);
    }

    public void addDefaultFile(String path, boolean isCurrentDefault) {
        boolean invalidDefault = false;
        this.availableDefaults.add(path);
        if (isCurrentDefault) {
            this.actualDefault = path;
            try {
                this.loadDefaultModel();
            }
            catch (Exception e) {
                this.availableDefaults.remove(path);
                invalidDefault = true;
                this.actualDefault = null;
                this.defaultReport = null;
                this.defaultConfig = null;
                e.printStackTrace();
            }
        }
        if (!invalidDefault) {
            this.savePreferences();
        }
    }

    public List<String> getAvailableElements() {
        if (this.availableDefaults == null) {
            this.initializeDefaultManager();
        }
        return this.availableDefaults;
    }

    private INode searchAndRemoveOld(JRDesignElement element, INode actualNode) {
        for (INode node : actualNode.getChildren()) {
            if (node.getValue() != null && node.getValue().getClass().equals(element.getClass()) && actualNode.getValue() instanceof JRDesignElementGroup) {
                Object parent = actualNode.getValue();
                ((JRDesignElementGroup)parent).removeElement((JRDesignElement)node.getValue());
                return actualNode;
            }
            INode subResult = this.searchAndRemoveOld(element, node);
            if (subResult == null) continue;
            return subResult;
        }
        return null;
    }

    private INode searchDetailBand() {
        MReport mReport = (MReport)this.defaultReport.getChildren().get(0);
        for (INode child : mReport.getChildren()) {
            MBand band;
            if (!(child instanceof MBand) || child.getValue() == null || (band = (MBand)child).getBandType() != BandTypeEnum.DETAIL) continue;
            return band;
        }
        return null;
    }

    private void addNewElement(JRDesignElement element) {
        INode parent = this.searchDetailBand();
        Assert.isNotNull((Object)parent, (String)"The Template Set report must have a detail band");
        if (parent != null) {
            this.searchAndRemoveOld(element, parent);
            ((JRDesignElementGroup)parent.getValue()).addElement(element);
        }
    }

    public void addElementToCurrentDefault(MGraphicElement element, boolean copyAttributesFromStyles) {
        if (this.hasDefault()) {
            JRDesignElement newElement = (JRDesignElement)element.getValue().clone();
            if (copyAttributesFromStyles) {
                CustomStyleResolver.copyInheritedAttributes(element, newElement);
            }
            newElement.setX(0);
            newElement.setY(0);
            this.selectedDefaultsMap.put(element.getClass(), (MGraphicElement)ReportFactory.createNode(null, newElement, 0));
            this.addNewElement(newElement);
            UIUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IFile reportFile = DefaultManager.this.getFileFromPath(DefaultManager.this.actualDefault);
                        String xml = DefaultManager.this.model2xml("last");
                        reportFile.setContents((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")), 3, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Throwable e) {
                        UIUtils.showError((Throwable)e);
                    }
                }
            });
        }
    }

    private IFile getFileFromPath(String pathString) {
        Path path = new Path(pathString);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile reportFile = workspace.getRoot().getFileForLocation((IPath)path);
        return reportFile;
    }

    private String model2xml(String version) {
        String xml = null;
        try {
            JasperDesign report = null;
            MReport mReport = (MReport)this.defaultReport.getChildren().get(0);
            if (mReport != null) {
                report = mReport.getJasperDesign();
            }
            xml = JRXmlWriterHelper.writeReport((JasperReportsContext)this.defaultConfig, (JRReport)report, "UTF-8", version);
        }
        catch (Throwable e) {
            UIUtils.showError((Throwable)e);
        }
        return xml;
    }

    public String getDefaultName() {
        if (this.hasDefault()) {
            return new File(this.actualDefault).getName();
        }
        return "";
    }

    public void removeDefaultFile(String path) {
        if (this.isCurrentDefault(path)) {
            this.unsetDefaultFile();
        }
        for (String defaults : this.availableDefaults) {
            if (!path.equals(defaults)) continue;
            this.availableDefaults.remove(defaults);
            this.savePreferences();
            break;
        }
    }

    public void reloadCurrentDefault() {
        if (this.actualDefault != null) {
            this.loadDefaultModel();
        }
    }

    public boolean isDisabled() {
        return this.disableDefaults;
    }

    public void setDisabled(boolean value) {
        this.disableDefaults = value;
    }
}

