/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.defaults;

import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.templates.StudioTemplateManager;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.JSSWizard;
import com.jaspersoft.studio.wizards.NewFileCreationWizardPage;
import com.jaspersoft.templates.ReportBundle;
import com.jaspersoft.templates.TemplateBundle;
import com.jaspersoft.templates.TemplateEngine;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class DefaultNewWizard
extends JSSWizard
implements INewWizard {
    private NewFileCreationWizardPage step1;
    private IFile reportFile;

    public DefaultNewWizard() {
        this.setWindowTitle(Messages.DefaultNewWizard_title);
        this.setNeedsProgressMonitor(true);
        JasperReportsConfiguration jrConfig = JasperReportsConfiguration.getDefaultJRConfig();
        JasperDesign jd = new JasperDesign();
        jd.setJasperReportsContext((JasperReportsContext)jrConfig);
        jrConfig.setJasperDesign(jd);
        this.setConfig(jrConfig, true);
    }

    @Override
    public void addPages() {
        this.step1 = new NewFileCreationWizardPage("newFilePage1", (IStructuredSelection)StructuredSelection.EMPTY);
        this.step1.setBaseName("template_set.jrxml");
        this.addPage((IWizardPage)this.step1);
    }

    @Override
    public boolean performFinish() {
        final String containerName = this.step1.getContainerFullPath().toPortableString();
        final String fileName = this.step1.getFileName();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.ReportNewWizard_2, -1);
                    try {
                        try {
                            DefaultNewWizard.this.doFinish(containerName, fileName, monitor);
                        }
                        catch (Exception e) {
                            UIUtils.showError((Throwable)e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
        return super.performFinish();
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        block9: {
            monitor.beginTask(String.valueOf(Messages.ReportNewWizard_3) + fileName, 2);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = root.findMember((IPath)new Path(containerName));
            if (!resource.exists() || !(resource instanceof IContainer)) {
                this.throwCoreException(String.format(Messages.ReportNewWizard_4, containerName));
            }
            HashMap<String, Object> templateSettings = new HashMap<String, Object>();
            TemplateBundle templateBundle = StudioTemplateManager.getInstance().getTemplateBundles().get(0);
            templateSettings.put("main_dataset", null);
            templateSettings.put("create_sort_fields", false);
            TemplateEngine templateEngine = templateBundle.getTemplateEngine();
            ByteArrayInputStream stream = null;
            try {
                try {
                    ReportBundle reportBundle = templateEngine.generateReportBundle(templateBundle, templateSettings, (JasperReportsContext)this.getConfig());
                    JasperDesign jd = reportBundle.getJasperDesign();
                    jd.setColumnFooter(null);
                    jd.setColumnHeader(null);
                    jd.setPageFooter(null);
                    jd.setPageHeader(null);
                    jd.setSummary(null);
                    jd.setBackground(null);
                    jd.setLeftMargin(0);
                    jd.setRightMargin(0);
                    jd.setTopMargin(0);
                    jd.setBottomMargin(0);
                    JRDesignStaticText helpText = new JRDesignStaticText();
                    helpText.setText(Messages.DefaultNewWizard_defaultsHint);
                    JRDesignBand title = (JRDesignBand)jd.getTitle();
                    title.addElement((JRDesignElement)helpText);
                    title.setHeight(150);
                    helpText.setWidth(jd.getPageWidth() - 10);
                    helpText.setHeight(title.getHeight() - 10);
                    helpText.setX(5);
                    helpText.setY(5);
                    ((JRDesignBand)jd.getDetailSection().getBands()[0]).setHeight(jd.getPageHeight() - title.getHeight());
                    IContainer container = (IContainer)resource;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            DefaultNewWizard.this.reportFile = DefaultNewWizard.this.step1.createNewFile();
                        }
                    });
                    String repname = this.reportFile.getName();
                    int lindx = repname.lastIndexOf(".");
                    if (lindx > 0 && lindx < repname.length() - 1) {
                        repname = repname.substring(0, lindx);
                    }
                    reportBundle.getJasperDesign().setName(repname);
                    String contents = JRXmlWriterHelper.writeReport(this.getConfig(), (JRReport)reportBundle.getJasperDesign(), this.reportFile, false);
                    stream = new ByteArrayInputStream(contents.getBytes());
                    if (this.reportFile.exists()) {
                        this.reportFile.setContents((InputStream)stream, true, true, monitor);
                    } else {
                        this.reportFile.create((InputStream)stream, true, monitor);
                    }
                    FileUtils.closeStream((Closeable)stream);
                    this.saveReportBundleResources(monitor, reportBundle, container);
                    monitor.setTaskName(Messages.ReportNewWizard_5);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            try {
                                IDE.openEditor((IWorkbenchPage)page, (IFile)DefaultNewWizard.this.reportFile, (boolean)true);
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    UIUtils.showError((Throwable)e);
                    FileUtils.closeStream(stream);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(stream);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)stream);
        }
    }

    public IFile getReportFile() {
        return this.reportFile;
    }

    private void saveReportBundleResources(IProgressMonitor monitor, ReportBundle reportBundle, IContainer container) {
        monitor.subTask(Messages.ReportNewWizard_6);
        List<String> resourceNames = reportBundle.getResourceNames();
        for (String resourceName : resourceNames) {
            IFile resourceFile = container.getFile((IPath)new Path(resourceName));
            InputStream is = null;
            try {
                try {
                    if (!resourceFile.exists() && (is = reportBundle.getResource(resourceName)) != null) {
                        resourceFile.create(is, true, monitor);
                    }
                }
                catch (Exception e) {
                    UIUtils.showError((Throwable)e);
                    FileUtils.closeStream(is);
                    continue;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(is);
                throw throwable;
            }
            FileUtils.closeStream(is);
        }
        monitor.done();
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.jaspersoft.studio", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

