/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.defaults;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class JrxmlFilterDialog
extends FilteredResourcesSelectionDialog {
    public JrxmlFilterDialog(Shell shell, boolean multi) {
        super(shell, multi, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredResourcesSelectionDialog.ResourceFilter(this){

            public String getPattern() {
                String pattern = super.getPattern();
                if (pattern.isEmpty()) {
                    return "*";
                }
                return pattern;
            }

            public boolean matchItem(Object item) {
                if (!(item instanceof IResource)) {
                    return false;
                }
                IResource resource = (IResource)item;
                String name = resource.getName();
                if (!name.toLowerCase().endsWith(".jrxml")) {
                    return false;
                }
                return super.matchItem(item);
            }
        };
    }

    public class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private FilteredItemsSelectionDialog.AbstractContentProvider proxyContentProvider;
        private FilteredResourcesSelectionDialog.ResourceFilter resourceFilter;
        private IProgressMonitor progressMonitor;

        public ResourceProxyVisitor(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredResourcesSelectionDialog.ResourceFilter resourceFilter, IProgressMonitor progressMonitor) throws CoreException {
            this.proxyContentProvider = contentProvider;
            this.resourceFilter = resourceFilter;
            this.progressMonitor = progressMonitor;
        }

        public boolean visit(IResourceProxy proxy) {
            if (this.progressMonitor.isCanceled()) {
                return false;
            }
            IResource resource = proxy.requestResource();
            this.proxyContentProvider.add((Object)resource, (FilteredItemsSelectionDialog.ItemsFilter)this.resourceFilter);
            if (resource.getType() == 2 && resource.isDerived() && !this.resourceFilter.isShowDerived()) {
                return false;
            }
            return resource.getType() != 1;
        }
    }
}

