/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.dnd;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.band.BandEditPart;
import com.jaspersoft.studio.editor.java2d.J2DScrollingGraphicalViewer;
import com.jaspersoft.studio.editor.outline.part.NotDragableContainerTreeEditPart;
import com.jaspersoft.studio.editor.palette.JDPaletteCreationFactory;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.DialogEnabledCommand;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.band.command.ReorderBandCommandBySibling;
import com.jaspersoft.studio.model.command.CreateE4ObjectCommand;
import com.jaspersoft.studio.model.command.CreateElementCommand;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.text.MStaticText;
import com.jaspersoft.studio.model.text.MTextField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class JSSTemplateTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    private EditPart feedBackContaienr = null;

    public JSSTemplateTransferDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)TemplateTransfer.getInstance());
        this.setEnablementDeterminedByCommand(true);
    }

    protected Request createTargetRequest() {
        Object template = TemplateTransfer.getInstance().getTemplate();
        if (!this.isCreation()) {
            return new ChangeBoundsRequest((Object)"move");
        }
        CreateRequest request = new CreateRequest();
        request.setFactory(this.getFactory(template));
        return request;
    }

    private boolean isCreation() {
        Object obj;
        Iterator iterator;
        Object template = TemplateTransfer.getInstance().getTemplate();
        return !(template instanceof Collection ? (iterator = ((Collection)template).iterator()).hasNext() && (obj = iterator.next()) instanceof MGraphicElement && ((ANode)obj).getParent() != null : template instanceof MGraphicElement && ((ANode)template).getParent() != null);
    }

    protected CreationFactory getFactory(Object template) {
        return new JDPaletteCreationFactory(template);
    }

    protected void handleDragOperationChanged() {
        this.getCurrentEvent().detail = this.isCreation() ? 1 : 0;
        super.handleDragOperationChanged();
    }

    protected void handleDragOver() {
        this.getCurrentEvent().detail = this.isCreation() ? 1 : 0;
        this.getCurrentEvent().feedback = 24;
        super.handleDragOver();
    }

    private void addAll(CompoundCommand compCommand, List<Command> commandsToAdd) {
        for (Command command : commandsToAdd) {
            compCommand.add(command);
        }
    }

    protected void updateTargetRequest() {
        Request request = this.getTargetRequest();
        if (request instanceof CreateRequest) {
            ((CreateRequest)request).setLocation(this.getDropLocation());
        } else if (request instanceof ChangeBoundsRequest) {
            if (this.getViewer() instanceof J2DScrollingGraphicalViewer) {
                ArrayList<EditPart> parts = new ArrayList<EditPart>();
                Object template = TemplateTransfer.getInstance().getTemplate();
                if (template instanceof Collection) {
                    for (Object obj : (Collection)template) {
                        Object p = this.getViewer().getEditPartRegistry().get(obj);
                        if (!(p instanceof EditPart)) continue;
                        parts.add((EditPart)p);
                    }
                    ((ChangeBoundsRequest)request).setEditParts(parts);
                } else {
                    Object p = this.getViewer().getEditPartRegistry().get(template);
                    if (p instanceof EditPart) {
                        ((ChangeBoundsRequest)request).setEditParts((EditPart)p);
                    }
                }
            }
            ((ChangeBoundsRequest)request).setLocation(this.getDropLocation());
            this.getTargetEditPart();
        }
    }

    private void createLabelForField(Command previusCommand) {
        EditPart container;
        Request target = this.getTargetRequest();
        if (target instanceof CreateRequest && (container = this.getContainer()) instanceof BandEditPart && ((MBand)container.getModel()).getBandType() == BandTypeEnum.DETAIL && previusCommand instanceof CompoundCommand) {
            boolean placeinTheHedaer;
            CompoundCommand compCommand = (CompoundCommand)previusCommand;
            ArrayList<Command> commandToAdd = new ArrayList<Command>();
            MBand band = (MBand)container.getModel();
            MBand dest = ((MReport)band.getParent()).getBand(BandTypeEnum.COLUMN_HEADER);
            int defaultHeight = new MStaticText().getDefaultHeight();
            int defaultWidth = new MTextField().getDefaultWidth();
            boolean bl = placeinTheHedaer = dest != null && dest.getValue() != null && dest.getValue().getHeight() >= defaultHeight;
            if (!placeinTheHedaer) {
                dest = band;
                defaultHeight = new MTextField().getDefaultHeight();
            }
            ArrayList<CreateE4ObjectCommand> creationCommands = new ArrayList<CreateE4ObjectCommand>();
            for (Object command : compCommand.getCommands()) {
                if (command instanceof CompoundCommand) {
                    CompoundCommand cc = (CompoundCommand)command;
                    for (Object c : cc.getCommands()) {
                        if (!(c instanceof CreateE4ObjectCommand) || !(((CreateE4ObjectCommand)((Object)c)).getChild() instanceof MField)) continue;
                        creationCommands.add((CreateE4ObjectCommand)((Object)c));
                    }
                    continue;
                }
                if (!(command instanceof CreateE4ObjectCommand) || !(((CreateE4ObjectCommand)((Object)command)).getChild() instanceof MField)) continue;
                creationCommands.add((CreateE4ObjectCommand)((Object)command));
            }
            String dragMessage = null;
            for (CreateE4ObjectCommand creatElementC : creationCommands) {
                int actualWidth;
                Object description;
                MStaticText newText = new MStaticText();
                MField field = (MField)creatElementC.getChild();
                JRDesignStaticText newTextElement = (JRDesignStaticText)newText.createJRElement(band.getJasperDesign());
                String labelText = field.getDisplayText();
                Boolean useDescription = field.getJasperConfiguration().getPropertyBoolean("useDescriptionOnFieldDrop", false);
                if (useDescription.booleanValue() && (description = field.getPropertyValue("description")) instanceof String) {
                    labelText = (String)description;
                }
                newTextElement.setText(labelText);
                newText.setValue(newTextElement);
                Rectangle location = null;
                if (placeinTheHedaer) {
                    int x = creatElementC.getLocation().x - band.getBounds().x;
                    int y = creatElementC.getLocation().y - band.getBounds().y;
                    actualWidth = creatElementC.getLocation().width != -1 ? creatElementC.getLocation().width : defaultWidth;
                    location = new Rectangle(x, y, actualWidth, defaultHeight);
                    location.y = 0;
                    dragMessage = Messages.JSSTemplateTransferDropTargetListener_createLabelMessage2;
                } else if (creationCommands.size() == 1) {
                    int x = creatElementC.getLocation().x - band.getBounds().x;
                    int y = creatElementC.getLocation().y - band.getBounds().y;
                    actualWidth = creatElementC.getLocation().width != -1 ? creatElementC.getLocation().width : defaultWidth;
                    location = new Rectangle(x, y, actualWidth, defaultHeight);
                    location.x = location.getLocation().x - location.width;
                    dragMessage = Messages.JSSTemplateTransferDropTargetListener_createLabelMessage1;
                }
                if (location != null) {
                    String dragBehavior = JaspersoftStudioPlugin.getInstance().getPreferenceStore().getString("fieldDrop");
                    if (dragBehavior.equals("ask_everytime")) {
                        MessageDialogWithToggle question = MessageDialogWithToggle.open((int)3, (Shell)UIUtils.getShell(), (String)Messages.JSSTemplateTransferDropTargetListener_createLabelTitle, dragMessage, null, (boolean)false, null, null, (int)0);
                        dragBehavior = question.getReturnCode() == 2 ? "create_label" : "do_nothing";
                        if (question.getToggleState()) {
                            JaspersoftStudioPlugin.getInstance().getPreferenceStore().setValue("fieldDrop", dragBehavior);
                        }
                    }
                    if (dragBehavior.equals("create_label")) {
                        commandToAdd.add(new CreateElementCommand(dest, (MGraphicElement)newText, location, -1));
                    }
                }
                location = null;
            }
            this.addAll(compCommand, commandToAdd);
        }
    }

    private EditPart getContainer() {
        EditPart target = this.getTargetEditPart();
        if (target instanceof FigureEditPart) {
            return ((FigureEditPart)target).getDropContainer();
        }
        if (target instanceof IContainer) {
            return target;
        }
        return FigureEditPart.getParentEditPart(target);
    }

    protected void showTargetFeedback() {
        Request req = this.getTargetRequest();
        this.eraseTargetFeedback();
        if (req != null && "create child".equals(req.getType())) {
            this.feedBackContaienr = this.getContainer();
            if (this.feedBackContaienr != null) {
                this.feedBackContaienr.showTargetFeedback(req);
            }
        } else {
            super.showTargetFeedback();
        }
    }

    protected void eraseTargetFeedback() {
        Request req = this.getTargetRequest();
        if (this.feedBackContaienr != null) {
            this.feedBackContaienr.eraseTargetFeedback(req);
            this.feedBackContaienr = null;
        } else {
            super.eraseTargetFeedback();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSSCompoundCommand dropDetailBands() {
        DropTargetEvent cEvent = this.getCurrentEvent();
        if (cEvent.detail != 2) {
            return null;
        }
        if (cEvent.item == null || !(cEvent.item instanceof TreeItem)) {
            return null;
        }
        List selectedItems = null;
        if (cEvent.data != null) {
            if (!(cEvent.data instanceof List)) return null;
            selectedItems = (List)cEvent.data;
        } else {
            selectedItems = this.getViewer().getSelectedEditParts();
        }
        ArrayList<MBand> movedBands = new ArrayList<MBand>();
        BandTypeEnum moveType = ReorderBandCommandBySibling.getMoveType(selectedItems, movedBands);
        if (moveType == null) {
            return null;
        }
        Tree tree = ((TreeItem)cEvent.item).getParent();
        Point pt = tree.getDisplay().map(null, (Control)tree, cEvent.x, cEvent.y);
        TreeItem firstItem = tree.getItem(new Point(pt.x, pt.y - 5));
        TreeItem secondItem = tree.getItem(new Point(pt.x, pt.y + 5));
        if (firstItem == null || !(firstItem.getData() instanceof NotDragableContainerTreeEditPart)) {
            return null;
        }
        if (secondItem == null || !(secondItem.getData() instanceof NotDragableContainerTreeEditPart)) {
            return null;
        }
        Object model1 = ((NotDragableContainerTreeEditPart)firstItem.getData()).getModel();
        Object model2 = ((NotDragableContainerTreeEditPart)secondItem.getData()).getModel();
        MBand band1 = null;
        MBand band2 = null;
        if (model1 instanceof MBand) {
            band1 = (MBand)model1;
        }
        if (model2 instanceof MBand) {
            band2 = (MBand)model2;
        }
        if (band1 == null || band2 == null) {
            return null;
        }
        JRDesignBand targetNode = null;
        if (band1.getBandType().equals((Object)moveType)) {
            targetNode = band1.getValue();
            return ReorderBandCommandBySibling.moveBandsCommand(movedBands, (JRBand)targetNode, ((NotDragableContainerTreeEditPart)firstItem.getData()).getParent());
        } else {
            if (band2.getBandType().equals((Object)moveType)) return ReorderBandCommandBySibling.moveBandsCommand(movedBands, (JRBand)targetNode, ((NotDragableContainerTreeEditPart)firstItem.getData()).getParent());
            return null;
        }
    }

    protected Command getCommand() {
        Object cmd = super.getCommand();
        if (cmd == null) {
            this.updateTargetRequest();
            this.updateTargetEditPart();
            cmd = this.dropDetailBands();
        }
        return cmd;
    }

    private ANode getLockReferenceNode() {
        ANode result = null;
        if (this.getCurrentEvent().data instanceof List) {
            List list = (List)this.getCurrentEvent().data;
            for (Object obj : list) {
                if (obj instanceof ANode && (result = JSSCompoundCommand.getMainNode((ANode)obj)) != null) break;
            }
        }
        return result;
    }

    protected void handleDrop() {
        Request request = this.getTargetRequest();
        if (request instanceof CreateRequest) {
            this.updateTargetRequest();
            this.updateTargetEditPart();
            JSSCompoundCommand movingDetails = this.dropDetailBands();
            if (movingDetails != null) {
                this.getViewer().getEditDomain().getCommandStack().execute((Command)movingDetails);
            } else if (this.getTargetEditPart() != null) {
                Command command = this.getCommand();
                Object elementToSelect = ((CreateRequest)request).getNewObject();
                ANode lockReferenceNode = null;
                if (command instanceof CompoundCommand) {
                    lockReferenceNode = this.getLockReferenceNode();
                }
                UIUtils.getDisplay().asyncExec((Runnable)new CommandRunnable(command, lockReferenceNode, elementToSelect));
            }
            this.getCurrentEvent().detail = 0;
        }
    }

    private void executeCompoundCommand(CompoundCommand cmd, ANode node) {
        JSSCompoundCommand compound = new JSSCompoundCommand(cmd, null){

            @Override
            public void execute() {
                if (this.size() > 0) {
                    List<Command> commands = this.getCommands();
                    this.setIgnoreEvents(true);
                    int i = 0;
                    while (i < this.size()) {
                        Command cmd = commands.get(i);
                        if (cmd instanceof CreateElementCommand) {
                            CreateElementCommand createCnd = (CreateElementCommand)cmd;
                            createCnd.execute();
                            if (createCnd.isCancelled()) {
                                break;
                            }
                        } else {
                            cmd.execute();
                        }
                        ++i;
                    }
                    this.setIgnoreEvents(false);
                    this.refreshVisuals();
                }
            }
        };
        compound.setReferenceNodeIfNull(node);
        this.getViewer().getEditDomain().getCommandStack().execute((Command)compound);
    }

    private void selectAddedObject(Object model) {
        if (model == null) {
            return;
        }
        EditPartViewer viewer = this.getViewer();
        viewer.getControl().forceFocus();
        Object editpart = viewer.getEditPartRegistry().get(model);
        if (editpart instanceof EditPart) {
            this.getViewer().flush();
            viewer.select((EditPart)editpart);
        }
    }

    protected class CommandRunnable
    implements Runnable {
        private Command commandToExecute;
        private ANode lockReferenceNode;
        private Object elementToSelect;

        public CommandRunnable(Command commandToExecute, ANode lockReferenceNode, Object elementToSelect) {
            this.commandToExecute = commandToExecute;
            this.lockReferenceNode = lockReferenceNode;
            this.elementToSelect = elementToSelect;
        }

        @Override
        public void run() {
            if (this.commandToExecute instanceof DialogEnabledCommand && this.commandToExecute.canExecute() && ((DialogEnabledCommand)this.commandToExecute).openDialog() == 1) {
                return;
            }
            if (this.commandToExecute != null && this.commandToExecute.canExecute()) {
                if (this.commandToExecute instanceof CompoundCommand) {
                    JSSTemplateTransferDropTargetListener.this.executeCompoundCommand((CompoundCommand)this.commandToExecute, this.lockReferenceNode);
                } else {
                    JSSTemplateTransferDropTargetListener.this.getViewer().getEditDomain().getCommandStack().execute(this.commandToExecute);
                }
            }
            JSSTemplateTransferDropTargetListener.this.selectAddedObject(this.elementToSelect);
        }
    }
}

