/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.expression;

import com.jaspersoft.studio.editor.expression.CrosstabTotalVariable;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JEditorPane;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;

public class ExpressionContext {
    public static final String ATTRIBUTE_EXPRESSION_CONTEXT = "EXPRESSION_CONTEXT";
    public static JEditorPane activeEditor = null;
    private static ExpressionContext globalContext = null;
    private JasperReportsConfiguration config = null;
    private List<JRDesignDataset> datasets = new ArrayList<JRDesignDataset>();
    private List<JRDesignCrosstab> crosstabs = new ArrayList<JRDesignCrosstab>();
    private EnumSet<Visibility> visibilities = EnumSet.allOf(Visibility.class);

    public static ExpressionContext getGlobalContext() {
        return globalContext;
    }

    public static synchronized void setGlobalContext(ExpressionContext g) {
        globalContext = g;
    }

    public List<JRDesignDataset> getDatasets() {
        return this.datasets;
    }

    public List<JRDesignCrosstab> getCrosstabs() {
        return this.crosstabs;
    }

    private ExpressionContext() {
    }

    public ExpressionContext(JasperReportsConfiguration config) {
        this();
        this.config = config;
    }

    public ExpressionContext(JRDesignDataset dataset, JasperReportsConfiguration config) {
        this(config);
        this.datasets.add(dataset);
    }

    public ExpressionContext(JRDesignCrosstab crosstab, JasperReportsConfiguration config) {
        this(config);
        this.crosstabs.add(crosstab);
    }

    public String findObjectClassName(String objName, char type) {
        block6: {
            block7: {
                block5: {
                    if (type != 'P') break block5;
                    for (JRDesignDataset dataset : this.getDatasets()) {
                        if (!dataset.getParametersMap().containsKey(objName)) continue;
                        return ((JRParameter)dataset.getParametersMap().get(objName)).getValueClassName();
                    }
                    for (JRDesignCrosstab crosstab : this.getCrosstabs()) {
                        String className = ExpressionContext.getCrosstabParameterClassName(crosstab, objName);
                        if (className == null) continue;
                        return className;
                    }
                    break block6;
                }
                if (type != 'V') break block7;
                for (JRDesignDataset dataset : this.getDatasets()) {
                    if (!dataset.getVariablesMap().containsKey(objName)) continue;
                    return ((JRVariable)dataset.getVariablesMap().get(objName)).getValueClassName();
                }
                for (JRDesignCrosstab crosstab : this.getCrosstabs()) {
                    String className = ExpressionContext.getCrosstabVariableClassName(crosstab, objName);
                    if (className == null) continue;
                    return className;
                }
                break block6;
            }
            if (type != 'F') break block6;
            for (JRDesignDataset dataset : this.getDatasets()) {
                if (!dataset.getFieldsMap().containsKey(objName)) continue;
                return ((JRField)dataset.getFieldsMap().get(objName)).getValueClassName();
            }
        }
        return null;
    }

    private static final String getCrosstabParameterClassName(JRDesignCrosstab crosstab, String name) {
        if (crosstab.getParametersMap().containsKey(name)) {
            return ((JRCrosstabParameter)crosstab.getParametersMap().get(name)).getValueClassName();
        }
        return null;
    }

    private static final String getCrosstabVariableClassName(JRDesignCrosstab crosstab, String name) {
        List rowGroups = crosstab.getRowGroupsList();
        List columnGroups = crosstab.getColumnGroupsList();
        for (JRDesignCrosstabMeasure measure : crosstab.getMesuresList()) {
            if (name.equals(measure.getVariable().getName())) {
                return measure.getVariable().getValueClassName();
            }
            int i = 0;
            while (i < rowGroups.size()) {
                JRDesignCrosstabRowGroup rowGroup = (JRDesignCrosstabRowGroup)rowGroups.get(i);
                CrosstabTotalVariable var = new CrosstabTotalVariable((JRCrosstabMeasure)measure, (JRCrosstabRowGroup)rowGroup, null);
                if (("$V{" + name + "}").equals(var.getExpression())) {
                    return var.getClassType();
                }
                int j = 0;
                while (j < columnGroups.size()) {
                    JRDesignCrosstabColumnGroup columnGroup = (JRDesignCrosstabColumnGroup)columnGroups.get(j);
                    if (j == 0) {
                        CrosstabTotalVariable var2 = new CrosstabTotalVariable((JRCrosstabMeasure)measure, null, (JRCrosstabColumnGroup)columnGroup);
                        if (("$V{" + name + "}").equals(var2.getExpression())) {
                            return var2.getClassType();
                        }
                    }
                    CrosstabTotalVariable var3 = new CrosstabTotalVariable((JRCrosstabMeasure)measure, (JRCrosstabRowGroup)rowGroup, (JRCrosstabColumnGroup)columnGroup);
                    if (("$V{" + name + "}").equals(var3.getExpression())) {
                        return var3.getClassType();
                    }
                    ++j;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < rowGroups.size()) {
            JRDesignCrosstabRowGroup rowGroup = (JRDesignCrosstabRowGroup)rowGroups.get(i);
            if (name.equals(rowGroup.getVariable().getName())) {
                return rowGroup.getVariable().getValueClassName();
            }
            ++i;
        }
        i = 0;
        while (i < columnGroups.size()) {
            JRDesignCrosstabColumnGroup columnGroup = (JRDesignCrosstabColumnGroup)columnGroups.get(i);
            if (name.equals(columnGroup.getVariable().getName())) {
                return columnGroup.getVariable().getValueClassName();
            }
            ++i;
        }
        return null;
    }

    public JasperReportsConfiguration getJasperReportsConfiguration() {
        return this.config;
    }

    public boolean hasDatasets() {
        return this.datasets != null && this.datasets.size() > 0;
    }

    public boolean hasCrosstabs() {
        return this.crosstabs != null && this.crosstabs.size() > 0;
    }

    public void addDataset(JRDesignDataset ds) {
        if (this.datasets == null) {
            this.datasets = new ArrayList<JRDesignDataset>();
        }
        this.datasets.add(ds);
    }

    public void addCrosstab(JRDesignCrosstab crosstab) {
        if (this.crosstabs == null) {
            this.crosstabs = new ArrayList<JRDesignCrosstab>();
        }
        this.crosstabs.add(crosstab);
    }

    public boolean canShowFields() {
        return this.visibilities.contains((Object)Visibility.SHOW_FIELDS);
    }

    public boolean canShowParameters() {
        return this.visibilities.contains((Object)Visibility.SHOW_PARAMETERS);
    }

    public boolean canShowVariables() {
        return this.visibilities.contains((Object)Visibility.SHOW_VARIABLES);
    }

    public void setVisibilities(EnumSet<Visibility> mask) {
        this.visibilities = mask;
    }

    public static enum Visibility {
        SHOW_VARIABLES,
        SHOW_PARAMETERS,
        SHOW_FIELDS;

    }
}

