/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.expression;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import org.eclipse.osgi.util.NLS;

public final class ExpressionContextUtils {
    private ExpressionContextUtils() {
    }

    public static List<JRParameter> getAllDatasetsParameters(ExpressionContext exprContext) {
        if (exprContext.hasDatasets() && exprContext.canShowParameters()) {
            ArrayList<JRParameter> elements = new ArrayList<JRParameter>();
            for (JRDesignDataset d : exprContext.getDatasets()) {
                elements.addAll(d.getParametersList());
            }
            return ExpressionContextUtils.getUniqueParameters(elements);
        }
        return new ArrayList<JRParameter>(0);
    }

    public static List<JRVariable> getAllDatasetsVariables(ExpressionContext exprContext) {
        if (exprContext.hasDatasets() && exprContext.canShowVariables()) {
            ArrayList<JRVariable> elements = new ArrayList<JRVariable>();
            for (JRDesignDataset d : exprContext.getDatasets()) {
                elements.addAll(d.getVariablesList());
            }
            return ExpressionContextUtils.getUniqueVariables(elements);
        }
        return new ArrayList<JRVariable>(0);
    }

    public static List<JRField> getAllDatasetsFields(ExpressionContext exprContext) {
        if (exprContext.hasDatasets() && exprContext.canShowFields()) {
            ArrayList<JRField> elements = new ArrayList<JRField>();
            for (JRDesignDataset d : exprContext.getDatasets()) {
                elements.addAll(d.getFieldsList());
            }
            return ExpressionContextUtils.getUniqueFields(elements);
        }
        return new ArrayList<JRField>(0);
    }

    public static List<JRVariable> getAllCrosstabsVariables(ExpressionContext exprContext) {
        if (exprContext.hasCrosstabs() && exprContext.canShowVariables()) {
            ArrayList<JRVariable> elements = new ArrayList<JRVariable>();
            for (JRDesignCrosstab c : exprContext.getCrosstabs()) {
                elements.addAll(Arrays.asList(c.getVariables()));
            }
            return elements;
        }
        return new ArrayList<JRVariable>(0);
    }

    public static List<JRParameter> getAllCrosstabsParameters(ExpressionContext exprContext) {
        if (exprContext.hasCrosstabs() && exprContext.canShowParameters()) {
            ArrayList<JRParameter> elements = new ArrayList<JRParameter>();
            for (JRDesignCrosstab c : exprContext.getCrosstabs()) {
                elements.addAll(Arrays.asList(c.getParameters()));
            }
            return elements;
        }
        return new ArrayList<JRParameter>(0);
    }

    private static List<JRVariable> getUniqueVariables(List<JRVariable> variables) {
        LinkedHashMap<String, JRVariable> variablesMap = new LinkedHashMap<String, JRVariable>();
        for (JRVariable v : variables) {
            variablesMap.put(v.getName(), v);
        }
        return new ArrayList<JRVariable>(variablesMap.values());
    }

    private static List<JRParameter> getUniqueParameters(List<JRParameter> parameters) {
        LinkedHashMap<String, JRParameter> parametersMap = new LinkedHashMap<String, JRParameter>();
        for (JRParameter p : parameters) {
            parametersMap.put(p.getName(), p);
        }
        return new ArrayList<JRParameter>(parametersMap.values());
    }

    private static List<JRField> getUniqueFields(List<JRField> fields) {
        LinkedHashMap<String, JRField> fieldsMap = new LinkedHashMap<String, JRField>();
        for (JRField f : fields) {
            fieldsMap.put(f.getName(), f);
        }
        return new ArrayList<JRField>(fieldsMap.values());
    }

    public static List<String> getResourceBundleKeys(ExpressionContext expContext) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (JRDataset jRDataset : expContext.getDatasets()) {
            ResourceBundle rb = ExpressionContextUtils.getResourceBundle(jRDataset, expContext.getJasperReportsConfiguration());
            if (rb == null) continue;
            keys.addAll(Collections.list(rb.getKeys()));
        }
        for (JRDesignCrosstab jRDesignCrosstab : expContext.getCrosstabs()) {
            ResourceBundle rb;
            JRDatasetRun datasetRun = jRDesignCrosstab.getDataset().getDatasetRun();
            JasperDesign jd = expContext.getJasperReportsConfiguration().getJasperDesign();
            JRDataset ds = jd.getMainDataset();
            if (datasetRun != null) {
                ds = (JRDataset)jd.getDatasetMap().get(datasetRun.getDatasetName());
            }
            if ((rb = ExpressionContextUtils.getResourceBundle(ds, expContext.getJasperReportsConfiguration())) == null) continue;
            keys.addAll(Collections.list(rb.getKeys()));
        }
        ArrayList<String> arrayList = new ArrayList<String>(keys);
        return arrayList;
    }

    public static ResourceBundle getResourceBundle(JRDataset dataset, JasperReportsConfiguration jconfig) {
        String baseName = dataset.getResourceBundle();
        ResourceBundle loadedBundle = null;
        if (baseName == null) {
            baseName = jconfig.getJasperDesign().getMainDataset().getResourceBundle();
        }
        if (!Misc.isNullOrEmpty((String)baseName)) {
            Locale locale = Locale.getDefault();
            Object obj = jconfig.getJRParameters().get("REPORT_LOCALE");
            if (obj instanceof Locale) {
                locale = (Locale)obj;
            }
            try {
                loadedBundle = JRResourcesUtil.loadResourceBundle((JasperReportsContext)jconfig, (String)baseName, (Locale)locale);
            }
            catch (MissingResourceException e) {
                JaspersoftStudioPlugin.getInstance().logError(NLS.bind((String)"Unable to get the resource bundle with base name {0}.", (Object)baseName), e);
            }
        }
        return loadedBundle;
    }

    public static List<JRParameter> getDatasetParameters(ExpressionContext exprContext, JRDesignDataset ds) {
        ArrayList<JRParameter> parameters = new ArrayList<JRParameter>();
        for (JRDesignDataset d : exprContext.getDatasets()) {
            if (d != ds) continue;
            parameters.addAll(d.getParametersList());
            break;
        }
        return parameters;
    }

    public static List<JRVariable> getDatasetVariables(ExpressionContext exprContext, JRDesignDataset ds) {
        ArrayList<JRVariable> variables = new ArrayList<JRVariable>();
        for (JRDesignDataset d : exprContext.getDatasets()) {
            if (d != ds) continue;
            variables.addAll(d.getVariablesList());
            break;
        }
        return variables;
    }

    public static List<JRField> getDatasetFields(ExpressionContext exprContext, JRDesignDataset ds) {
        ArrayList<JRField> fields = new ArrayList<JRField>();
        for (JRDesignDataset d : exprContext.getDatasets()) {
            if (d != ds) continue;
            fields.addAll(d.getFieldsList());
            break;
        }
        return fields;
    }
}

