/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.expression;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.editor.expression.ExpObjectSortingInfo;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupport;
import com.jaspersoft.studio.editor.expression.ExpressionPersistentWizardDialog;
import com.jaspersoft.studio.editor.expression.FunctionsLibraryUtil;
import com.jaspersoft.studio.editor.expression.IExpressionEditorSupportFactory;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionBean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class ExpressionEditorSupportUtil {
    public static final int EXPEDITOR_INITIAL_HEIGHT = 680;
    public static final int EXPEDITOR_INITIAL_WIDTH = 750;
    private static final IExpressionEditorSupportFactory supportFactory;
    private static final Map<String, ExpressionEditorSupport> editorSupports;
    private static ExpressionContext currentContext;
    private static Boolean isExpressionEditorDialogOpen;
    private static boolean showBuiltInParameters;
    private static boolean showBuiltInVariables;
    private static ExpObjectSortingInfo variablesSorting;
    private static ExpObjectSortingInfo fieldsSorting;
    private static ExpObjectSortingInfo parametersSorting;
    private static ExpObjectSortingInfo rbkeysSorting;

    static {
        isExpressionEditorDialogOpen = Boolean.FALSE;
        showBuiltInParameters = true;
        showBuiltInVariables = true;
        variablesSorting = new ExpObjectSortingInfo(1);
        fieldsSorting = new ExpObjectSortingInfo(0);
        parametersSorting = new ExpObjectSortingInfo(2);
        rbkeysSorting = new ExpObjectSortingInfo(3, false, true);
        supportFactory = JaspersoftStudioPlugin.getExtensionManager().getExpressionEditorSupportFactory();
        editorSupports = new HashMap<String, ExpressionEditorSupport>(3);
    }

    public static boolean existsExpressionEditorSupportFactory() {
        return supportFactory != null;
    }

    public static IExpressionEditorSupportFactory getExpressionEditorSupportFactory() {
        return supportFactory;
    }

    public static boolean existsSupportForLanguage(String language) {
        return ExpressionEditorSupportUtil.getEditorSupportForLanguage(language) != null;
    }

    public static ExpressionEditorSupport getEditorSupportForLanguage(String language) {
        if (supportFactory == null || language == null) {
            return null;
        }
        ExpressionEditorSupport expressionEditorSupport = null;
        if (!editorSupports.containsKey(language)) {
            expressionEditorSupport = supportFactory.getExpressionEditorSupport(language);
            if (expressionEditorSupport != null) {
                editorSupports.put(language, expressionEditorSupport);
            }
        } else {
            expressionEditorSupport = editorSupports.get(language);
        }
        return expressionEditorSupport;
    }

    public static ExpressionEditorSupport getEditorSupport(ExpressionContext exprContext) {
        JasperDesign jasperDesign;
        if (exprContext != null && (jasperDesign = exprContext.getJasperReportsConfiguration().getJasperDesign()) != null) {
            return ExpressionEditorSupportUtil.getEditorSupportForLanguage(jasperDesign.getLanguage());
        }
        return ExpressionEditorSupportUtil.getEditorSupportForReportLanguage();
    }

    public static ExpressionEditorSupport getEditorSupportForReportLanguage() {
        IEditorPart activeJRXMLEditor = SelectionHelper.getActiveJRXMLEditor();
        if (activeJRXMLEditor != null && activeJRXMLEditor instanceof AbstractJRXMLEditor) {
            return ExpressionEditorSupportUtil.getEditorSupportForLanguage(((AbstractJRXMLEditor)activeJRXMLEditor).getModel().getJasperDesign().getLanguage());
        }
        return null;
    }

    public static ExpressionContext getReportExpressionContext() {
        ANode mroot;
        IEditorPart activeJRXMLEditor = SelectionHelper.getActiveJRXMLEditor();
        if (activeJRXMLEditor != null && activeJRXMLEditor instanceof AbstractJRXMLEditor && (mroot = (ANode)((AbstractJRXMLEditor)activeJRXMLEditor).getModel()) != null) {
            ANode mreport = (ANode)mroot.getChildren().get(0);
            JRDataset mainDS = mreport.getJasperDesign().getMainDataset();
            ExpressionContext exprContext = new ExpressionContext((JRDesignDataset)mainDS, mreport.getJasperConfiguration());
            return exprContext;
        }
        return null;
    }

    public static ExpressionContext getReportExtendedExpressionContext() {
        ANode mroot;
        IEditorPart activeJRXMLEditor = SelectionHelper.getActiveJRXMLEditor();
        if (activeJRXMLEditor != null && activeJRXMLEditor instanceof AbstractJRXMLEditor && (mroot = (ANode)((AbstractJRXMLEditor)activeJRXMLEditor).getModel()) != null) {
            ANode mreport = (ANode)mroot.getChildren().get(0);
            JasperDesign jd = mreport.getJasperDesign();
            JRDataset mainDS = jd.getMainDataset();
            ExpressionContext exprContext = new ExpressionContext((JRDesignDataset)mainDS, mreport.getJasperConfiguration());
            JRDataset[] jRDatasetArray = jd.getDatasets();
            int n = jRDatasetArray.length;
            int n2 = 0;
            while (n2 < n) {
                JRDataset ds = jRDatasetArray[n2];
                if (ds instanceof JRDesignDataset) {
                    exprContext.addDataset((JRDesignDataset)ds);
                }
                ++n2;
            }
            for (JRCrosstab ct : ModelUtils.getAllCrosstabs(jd)) {
                if (!(ct instanceof JRDesignCrosstab)) continue;
                exprContext.addCrosstab((JRDesignCrosstab)ct);
            }
            return exprContext;
        }
        return null;
    }

    @Deprecated
    public static void addFunctionsLibraryImports(JasperDesign jd, JasperReportsConfiguration jrContext) {
        Assert.isNotNull((Object)jd);
        List collectedExpressions = JRExpressionCollector.collector((JasperReportsContext)jrContext, (JRReport)jd).getExpressions();
        List<String> libraryClasses = ExpressionEditorSupportUtil.getStaticImportsForExpressions(collectedExpressions);
        for (String clazzName : libraryClasses) {
            jd.addImport("static " + clazzName + ".*");
        }
    }

    public static void removeFunctionsLibraryImports(JasperDesign jd) {
        Assert.isNotNull((Object)jd);
        List<String> libraryClasses = FunctionsLibraryUtil.getLibraryClasses();
        for (String clazzName : libraryClasses) {
            jd.removeImport("static " + clazzName + ".*");
        }
    }

    @Deprecated
    public static void updateFunctionsLibraryImports(JasperDesign jasperDesign, JasperReportsConfiguration jrContext) {
        Assert.isNotNull((Object)jasperDesign);
        ExpressionEditorSupportUtil.removeFunctionsLibraryImports(jasperDesign);
        boolean useImports = jrContext.getPropertyBoolean("includeFunctionsLibraryImports", false);
        if (useImports && JRXmlWriterHelper.isCompatibleVersionMinor(jrContext, "5.1.0", true)) {
            ExpressionEditorSupportUtil.addFunctionsLibraryImports(jasperDesign, jrContext);
        }
    }

    @Deprecated
    public static List<String> getStaticImportsForExpressions(Collection<JRExpression> expressions) {
        HashSet<String> importsSet = new HashSet<String>();
        for (JRExpression jre : expressions) {
            List<JRExprFunctionBean> functions = FunctionsLibraryUtil.findFunctions(jre);
            for (JRExprFunctionBean f : functions) {
                importsSet.add(f.getFunctionClassName());
            }
        }
        return Arrays.asList(importsSet.toArray(new String[0]));
    }

    public static void setCurrentExpressionContext(ExpressionContext exprContext) {
        currentContext = exprContext;
    }

    public static ExpressionContext getCurrentExpressionContext() {
        return currentContext;
    }

    public static ExpressionContext safeGetCurrentExpressionContext() {
        ExpressionContext expContext = ExpressionEditorSupportUtil.getCurrentExpressionContext();
        if (expContext == null) {
            return ExpressionEditorSupportUtil.getReportExpressionContext();
        }
        return expContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WizardDialog getExpressionEditorWizardDialog(Shell parentShell, Wizard newWizard) {
        Boolean bl = isExpressionEditorDialogOpen;
        synchronized (bl) {
            block4: {
                if (!isExpressionEditorDialogOpen.booleanValue()) break block4;
                return null;
            }
            isExpressionEditorDialogOpen = Boolean.TRUE;
            return new ExpressionPersistentWizardDialog(parentShell, (IWizard)newWizard);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyExpressionEditorDialogClosing() {
        Boolean bl = isExpressionEditorDialogOpen;
        synchronized (bl) {
            isExpressionEditorDialogOpen = Boolean.FALSE;
        }
    }

    public static boolean isExpressionEditorDialogOpen() {
        return isExpressionEditorDialogOpen;
    }

    public static synchronized boolean isShowBuiltInParameters() {
        return showBuiltInParameters;
    }

    public static synchronized boolean toggleShowBuiltInParameters() {
        showBuiltInParameters = !showBuiltInParameters;
        return showBuiltInParameters;
    }

    public static synchronized boolean isShowBuiltInVariables() {
        return showBuiltInVariables;
    }

    public static synchronized boolean toggleShowBuiltInVariables() {
        showBuiltInVariables = !showBuiltInVariables;
        return showBuiltInVariables;
    }

    public static synchronized boolean toggleSortIncreaseItems(int type) {
        return ExpressionEditorSupportUtil.getSortingInfo(type).toggleSortIncreaseItems();
    }

    public static synchronized boolean toggleSortDecreaseItems(int type) {
        return ExpressionEditorSupportUtil.getSortingInfo(type).toggleSortDecreaseItems();
    }

    public static synchronized boolean isSortDecreaseItems(int type) {
        return ExpressionEditorSupportUtil.getSortingInfo(type).isSortDecreaseItems();
    }

    public static synchronized boolean isSortIncreaseItems(int type) {
        return ExpressionEditorSupportUtil.getSortingInfo(type).isSortIncreaseItems();
    }

    public static synchronized boolean isShowUnorderedItems(int type) {
        ExpObjectSortingInfo sortingInfo = ExpressionEditorSupportUtil.getSortingInfo(type);
        return !sortingInfo.isSortIncreaseItems() && !sortingInfo.isSortDecreaseItems();
    }

    private static ExpObjectSortingInfo getSortingInfo(int type) {
        switch (type) {
            case 0: {
                return fieldsSorting;
            }
            case 2: {
                return parametersSorting;
            }
            case 3: {
                return rbkeysSorting;
            }
            case 1: {
                return variablesSorting;
            }
        }
        throw new RuntimeException("The specified expession object type is invalid!");
    }

    public static boolean shouldRememberExpEditorDialogSize() {
        return JaspersoftStudioPlugin.getInstance().getPreferenceStore().getBoolean("rememberExpEditorSize");
    }

    public static boolean shouldRememberExpEditorDialogLocation() {
        return JaspersoftStudioPlugin.getInstance().getPreferenceStore().getBoolean("rememberExpEditorLocation");
    }

    public static void saveExpEditorDialogSize(int width, int height) {
        JaspersoftStudioPlugin.getInstance().getPreferenceStore().setValue("expressionEditorWidth", width);
        JaspersoftStudioPlugin.getInstance().getPreferenceStore().setValue("expressionEditorHeight", height);
    }

    public static void saveExpEditorDialogLocation(int x, int y) {
        JaspersoftStudioPlugin.getInstance().getPreferenceStore().setValue("expressionEditorLocationX", x);
        JaspersoftStudioPlugin.getInstance().getPreferenceStore().setValue("expressionEditorLocationY", y);
    }

    public static Point getExpEditorDialogLocation() {
        IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        if (store.contains("expressionEditorLocationX") && store.contains("expressionEditorLocationY")) {
            return new Point(store.getInt("expressionEditorLocationX"), store.getInt("expressionEditorLocationY"));
        }
        return null;
    }

    public static Point getExpEditorDialogSize() {
        IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        if (store.contains("expressionEditorWidth") && store.contains("expressionEditorHeight")) {
            return new Point(store.getInt("expressionEditorWidth"), store.getInt("expressionEditorHeight"));
        }
        return null;
    }
}

