/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.expression;

import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.expressions.annotations.JRExprAnnotationsUtils;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionBean;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionCategoryBean;
import net.sf.jasperreports.functions.FunctionsBundle;
import org.eclipse.ui.IEditorPart;

public class FunctionsLibraryUtil {
    private static Map<String, List<JRExprFunctionBean>> functionsByCategory = null;
    private static Map<String, JRExprFunctionCategoryBean> allCategories = null;
    private static List<JRExprFunctionBean> allFunctions = null;
    private static List<String> libraryClassNames = null;
    private static List<FunctionsBundle> currentExtensionObjects = null;
    private static String[] PREFIX_STRINGS = new String[]{"(", "+", "-", "/", "*", "!", "&", "|", "[", "{"};
    private static String[] WRONG_PREFIX_STRING = new String[]{"$P{", "$F{", "$V{", "$X{"};

    public static Collection<String> getCategories() {
        FunctionsLibraryUtil.lazyLibraryInitialization();
        return functionsByCategory.keySet();
    }

    public static JRExprFunctionCategoryBean getCategory(String categoryId) {
        FunctionsLibraryUtil.lazyLibraryInitialization();
        return allCategories.get(categoryId);
    }

    private static void initLibrary() {
        functionsByCategory = new HashMap<String, List<JRExprFunctionBean>>();
        allCategories = new HashMap<String, JRExprFunctionCategoryBean>();
        allFunctions = new ArrayList<JRExprFunctionBean>();
        libraryClassNames = new ArrayList<String>();
        currentExtensionObjects = new ArrayList<FunctionsBundle>();
        currentExtensionObjects.addAll(FunctionsLibraryUtil.getFunctionsExtensions());
        ArrayList<Class> foundClasses = new ArrayList<Class>();
        for (FunctionsBundle extObj : currentExtensionObjects) {
            for (Class fc : extObj.getFunctionClasses()) {
                if (foundClasses.contains(fc)) continue;
                foundClasses.add(fc);
            }
        }
        JasperReportsContext currentJRContext = FunctionsLibraryUtil.getCurrentJRContext();
        for (Class clazz : foundClasses) {
            String clazzName = clazz.getName();
            if (!libraryClassNames.contains(clazzName)) {
                libraryClassNames.add(clazzName);
            }
            JRExprAnnotationsUtils utilsInstance = JRExprAnnotationsUtils.getInstance((JasperReportsContext)currentJRContext);
            List jrFunctionsList = utilsInstance.getFunctionsList(clazz);
            for (JRExprFunctionBean f : jrFunctionsList) {
                for (JRExprFunctionCategoryBean category : f.getCategories()) {
                    if (!functionsByCategory.containsKey(category.getId())) {
                        functionsByCategory.put(category.getId(), new ArrayList());
                        allCategories.put(category.getId(), category);
                    }
                    functionsByCategory.get(category.getId()).add(f);
                    if (allFunctions.contains(f)) continue;
                    allFunctions.add(f);
                }
            }
        }
    }

    public static List<JRExprFunctionBean> getFunctionsByCategory(String categoryKey) {
        FunctionsLibraryUtil.lazyLibraryInitialization();
        ArrayList list = functionsByCategory.get(categoryKey);
        return list != null ? list : new ArrayList(0);
    }

    public static List<JRExprFunctionBean> getAllFunctions() {
        FunctionsLibraryUtil.lazyLibraryInitialization();
        return allFunctions;
    }

    public static List<String> getLibraryClasses() {
        FunctionsLibraryUtil.lazyLibraryInitialization();
        return libraryClassNames;
    }

    public static boolean existsFunction(String functionName) {
        for (JRExprFunctionBean f : FunctionsLibraryUtil.getAllFunctions()) {
            if (!f.getId().equals(functionName)) continue;
            return true;
        }
        return false;
    }

    public static List<JRExprFunctionBean> findFunctions(JRExpression jre) {
        ArrayList<JRExprFunctionBean> functionsFound = new ArrayList<JRExprFunctionBean>();
        String expressionText = jre.getText();
        if (expressionText != null && !expressionText.isEmpty()) {
            int expressionLength = expressionText.length();
            block0: for (JRExprFunctionBean f : FunctionsLibraryUtil.getAllFunctions()) {
                String fname = f.getId();
                int flength = f.getId().length();
                int findex = expressionText.indexOf(fname);
                while (findex != -1) {
                    String fprefix = expressionText.substring(0, findex);
                    String fsuffix = expressionText.substring(findex + flength, expressionLength);
                    if (FunctionsLibraryUtil.checkPossibleFunctionPrefix(fprefix) && FunctionsLibraryUtil.checkPossibleFunctionSuffix(fsuffix)) {
                        functionsFound.add(f);
                        continue block0;
                    }
                    findex = expressionText.indexOf(fname, findex + flength);
                }
            }
        }
        return functionsFound;
    }

    private static boolean checkPossibleFunctionPrefix(String prefix) {
        String s;
        if (prefix.isEmpty()) {
            return true;
        }
        boolean prefixOk = false;
        prefix = prefix.replace('\t', ' ').trim();
        String[] stringArray = WRONG_PREFIX_STRING;
        int n = WRONG_PREFIX_STRING.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (prefix.endsWith(s)) {
                return false;
            }
            ++n2;
        }
        stringArray = PREFIX_STRINGS;
        n = PREFIX_STRINGS.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (prefix.endsWith(s)) {
                prefixOk = true;
                break;
            }
            ++n2;
        }
        return prefixOk;
    }

    private static boolean checkPossibleFunctionSuffix(String suffix) {
        int i = 0;
        while (i < suffix.length()) {
            char readchar = suffix.charAt(i);
            if (readchar == '(') {
                return true;
            }
            if (readchar != ' ' && readchar != '\t') {
                return false;
            }
            ++i;
        }
        return false;
    }

    public static void reloadLibrary() {
        if (currentExtensionObjects != null) {
            currentExtensionObjects.clear();
            currentExtensionObjects = null;
        }
        if (functionsByCategory != null) {
            functionsByCategory.clear();
            functionsByCategory = null;
        }
        if (allCategories != null) {
            allCategories.clear();
            allCategories = null;
        }
        if (allFunctions != null) {
            allFunctions.clear();
            allFunctions = null;
        }
        if (libraryClassNames != null) {
            libraryClassNames.clear();
            libraryClassNames = null;
        }
        FunctionsLibraryUtil.initLibrary();
    }

    public static boolean functionsLibraryIsChanged() {
        if (currentExtensionObjects == null) {
            FunctionsLibraryUtil.initLibrary();
            return false;
        }
        List<FunctionsBundle> newExtensionsObjects = FunctionsLibraryUtil.getFunctionsExtensions();
        return !currentExtensionObjects.equals(newExtensionsObjects);
    }

    public static void reloadLibraryIfNeeded() {
        if (FunctionsLibraryUtil.functionsLibraryIsChanged()) {
            FunctionsLibraryUtil.reloadLibrary();
        }
    }

    private static void lazyLibraryInitialization() {
        if (currentExtensionObjects == null) {
            FunctionsLibraryUtil.initLibrary();
        }
    }

    private static List<FunctionsBundle> getFunctionsExtensions() {
        return FunctionsLibraryUtil.getCurrentJRContext().getExtensions(FunctionsBundle.class);
    }

    private static JasperReportsContext getCurrentJRContext() {
        Object jrContext = null;
        IEditorPart activeJRXMLEditor = SelectionHelper.getActiveJRXMLEditor();
        if (activeJRXMLEditor != null && activeJRXMLEditor instanceof JrxmlEditor) {
            ANode mroot = (ANode)((JrxmlEditor)activeJRXMLEditor).getModel();
            ANode mreport = (ANode)mroot.getChildren().get(0);
            jrContext = mreport.getJasperConfiguration();
        }
        if (jrContext == null) {
            jrContext = DefaultJasperReportsContext.getInstance();
        }
        return jrContext;
    }
}

