/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator.image;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.gef.decorator.chainable.AbstractPainter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class ImageLocation
extends AbstractPainter {
    private String path;
    private Image loadedImage;
    private boolean attemptLoading = false;

    public ImageLocation(AbstractPainter.Location loc, String path) {
        super(loc);
        this.path = path;
    }

    protected Image getImage() {
        if (this.loadedImage == null && !this.attemptLoading) {
            try {
                try {
                    URL resource = JaspersoftStudioPlugin.getInstance().getBundle().getResource(this.path);
                    this.loadedImage = ImageIO.read(resource);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.attemptLoading = true;
                }
            }
            finally {
                this.attemptLoading = true;
            }
        }
        return this.loadedImage;
    }

    public boolean hasValue() {
        if (this.getImage() != null) {
            return this.getImage().getWidth(null) != 0;
        }
        return false;
    }

    @Override
    public void paint(Graphics2D g, int x, int y) {
        if (this.hasValue()) {
            g.drawImage(this.getImage(), x, y, null);
        }
    }

    @Override
    public Point getElementSize(Graphics2D g) {
        if (this.hasValue()) {
            return new Point(this.getImage().getHeight(null), this.getImage().getHeight(null) + 4);
        }
        return new Point(0, 0);
    }
}

