/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator.json;

import com.jaspersoft.studio.editor.gef.decorator.chainable.AbstractPainter;
import com.jaspersoft.studio.editor.gef.decorator.chainable.IDecoratorInterface;
import com.jaspersoft.studio.editor.gef.decorator.text.TextLocation;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import net.sf.jasperreports.engine.JRPropertiesMap;

public class JSONDecorator
implements IDecoratorInterface {
    private static ImageIcon startImageAwt = null;
    private static ImageIcon endImageAwt = null;
    private static Font JSS_TEXT_FONT = new Font("SansSerif", 0, 10);
    private static Color JSS_TEXT_COLOR = new Color(29, 198, 29);
    String[] tags;

    public JSONDecorator() {
        if (startImageAwt == null || endImageAwt == null) {
            startImageAwt = new ImageIcon(JSONDecorator.class.getResource("/icons/resources/corner1.png"));
            endImageAwt = new ImageIcon(JSONDecorator.class.getResource("/icons/resources/corner2.png"));
        }
        this.tags = new String[]{"net.sf.jasperreports.export.json.path", "isPath "};
    }

    public void setTextFont(Font newFont) {
        JSS_TEXT_FONT = newFont;
    }

    public void setTextColor(Color newColor) {
        JSS_TEXT_COLOR = newColor;
    }

    @Override
    public ArrayList<AbstractPainter> getDecoratorPainter(ComponentFigure fig) {
        JRPropertiesMap mapProperties = fig.getJrElement().getPropertiesMap();
        ArrayList<AbstractPainter> result = new ArrayList<AbstractPainter>();
        boolean hasValue = false;
        String endString = "";
        int i = 0;
        while (i < this.tags.length) {
            String prop = this.tags[i];
            String label = this.tags[i + 1];
            hasValue = mapProperties.containsProperty(prop);
            if (prop.equals("net.sf.jasperreports.export.json.path") && hasValue) {
                endString = String.valueOf(endString) + label.concat(mapProperties.getProperty("net.sf.jasperreports.export.json.path")).concat(" ");
            }
            i += 2;
        }
        if ((endString = endString.trim()).length() > 0) {
            result.add(new TextLocation(AbstractPainter.Location.BottomRight, endString, JSS_TEXT_FONT, JSS_TEXT_COLOR));
        }
        return result;
    }
}

