/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator.json;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MReport;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SchemaDialog
extends ATitledDialog {
    private Text tPath;
    private MReport mtext;
    private String path;

    public SchemaDialog(Shell parentShell, MReport mtext) {
        super(parentShell);
        this.mtext = mtext;
        this.setTitle(Messages.SchemaDialog_0);
        JasperDesign v = mtext.getValue();
        this.path = v.getPropertiesMap().getProperty("net.sf.jasperreports.export.json.schema");
    }

    public String getName() {
        if (Misc.isNullOrEmpty((String)this.path)) {
            return null;
        }
        return this.path;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite cmp = new Composite(area, 0);
        cmp.setLayout((Layout)new GridLayout(3, false));
        cmp.setLayoutData((Object)new GridData(1808));
        new Label(cmp, 0).setText(Messages.SchemaDialog_1);
        this.tPath = new Text(cmp, 2048);
        this.tPath.setText(Misc.nvl((String)this.path));
        this.tPath.setToolTipText(Misc.nvl((String)this.path));
        GridData gd = new GridData(4, 128, true, false, 1, 1);
        gd.widthHint = 400;
        gd.horizontalSpan = 1;
        this.tPath.setLayoutData((Object)gd);
        this.tPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SchemaDialog.this.path = SchemaDialog.this.tPath.getText();
                SchemaDialog.this.validate(SchemaDialog.this.path);
            }
        });
        Button browse = new Button(cmp, 8);
        browse.setText("...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(UIUtils.getShell());
                fd.setFilterExtensions(new String[]{"*.json", "*.*"});
                String selection = fd.open();
                if (selection != null) {
                    SchemaDialog.this.path = selection;
                    SchemaDialog.this.tPath.setText(selection);
                    SchemaDialog.this.tPath.setToolTipText(selection);
                }
            }
        });
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SchemaDialog.this.validate(SchemaDialog.this.path);
            }
        });
        return area;
    }

    private void validate(String path) {
        this.getButton(0).setEnabled(true);
        this.setError(null);
        if (Misc.isNullOrEmpty((String)path)) {
            JRPropertiesMap map = this.mtext.getValue().getPropertiesMap();
            if (map != null && map.getProperty("net.sf.jasperreports.export.json.schema") != null) {
                this.setError(Messages.SchemaDialog_5);
            } else {
                this.setError(Messages.SchemaDialog_6);
                this.getButton(0).setEnabled(false);
            }
            return;
        }
    }
}

