/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator.pdf;

import com.jaspersoft.studio.editor.gef.decorator.IDecorator;
import com.jaspersoft.studio.editor.gef.decorator.chainable.AbstractPainter;
import com.jaspersoft.studio.editor.gef.decorator.chainable.IDecoratorInterface;
import com.jaspersoft.studio.editor.gef.decorator.text.TextLocation;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.java2d.J2DUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;

public class PDFDecorator
implements IDecorator,
IDecoratorInterface {
    private static ImageIcon startImageAwt = null;
    private static ImageIcon endImageAwt = null;
    private static Font JSS_TEXT_FONT = new Font("SansSerif", 0, 10);
    private static Color JSS_TEXT_COLOR = new Color(195, 47, 193);

    public PDFDecorator() {
        if (startImageAwt == null || endImageAwt == null) {
            startImageAwt = new ImageIcon(PDFDecorator.class.getResource("/icons/resources/corner1.png"));
            endImageAwt = new ImageIcon(PDFDecorator.class.getResource("/icons/resources/corner2.png"));
        }
    }

    @Override
    public void paint(Graphics graphics, ComponentFigure fig) {
        if (fig.getJrElement() instanceof JRDesignElement) {
            Rectangle r = fig.getBounds();
            Graphics2D g = ComponentFigure.getG2D(graphics);
            if (g != null) {
                int strWidth;
                Stroke oldStroke = g.getStroke();
                g.setStroke(J2DUtils.getInvertedZoomedStroke(oldStroke, graphics.getAbsoluteScale()));
                String tagValue = "";
                String startString = "";
                String fullString = "";
                String endString = "";
                boolean drawstart = false;
                boolean drawend = false;
                String[] tags = new String[]{"net.sf.jasperreports.export.pdf.tag.table", "TBL", "net.sf.jasperreports.export.pdf.tag.tr", "TR", "net.sf.jasperreports.export.pdf.tag.th", "TH", "net.sf.jasperreports.export.pdf.tag.td", "TD", "net.sf.jasperreports.export.pdf.tag.l", "LIST", "net.sf.jasperreports.export.pdf.tag.li", "LIST ITEM"};
                JRPropertiesMap v = fig.getJrElement().getPropertiesMap();
                int i = 0;
                while (i < tags.length) {
                    String prop = tags[i];
                    String label = tags[i + 1];
                    tagValue = v.getProperty(prop);
                    if (tagValue != null) {
                        if (tagValue.equals("full")) {
                            drawstart = true;
                            drawend = true;
                            fullString = String.valueOf(fullString) + label + " ";
                        } else if (tagValue.equals("start")) {
                            drawstart = true;
                            startString = String.valueOf(startString) + label + " ";
                        } else if (tagValue.equals("end")) {
                            drawend = true;
                            endString = String.valueOf(label) + " " + endString;
                        }
                    }
                    i += 2;
                }
                String headingValue = v.getProperty("net.sf.jasperreports.export.accessibility.tag");
                if (headingValue != null) {
                    drawend = true;
                    drawstart = true;
                    fullString = String.valueOf(fullString) + headingValue.toUpperCase() + " ";
                }
                if (drawstart) {
                    this.drawStart(g, r);
                }
                if (drawend) {
                    this.drawEnd(g, r);
                }
                Font f = g.getFont();
                Color color = g.getColor();
                startString = startString.trim();
                endString = endString.trim();
                fullString = fullString.trim();
                g.setFont(JSS_TEXT_FONT);
                g.setColor(JSS_TEXT_COLOR);
                if (startString.length() > 0) {
                    g.drawString(startString, r.x + 4, r.y + 11);
                }
                if (endString.length() > 0) {
                    strWidth = g.getFontMetrics().stringWidth(endString);
                    g.drawString(endString, r.x + r.width - strWidth - 6, r.y + r.height - 6);
                }
                if (fullString.length() > 0) {
                    strWidth = 0;
                    if (startString.length() > 0) {
                        strWidth = g.getFontMetrics().stringWidth(String.valueOf(startString) + " ");
                    }
                    AttributedString as = new AttributedString(fullString);
                    as.addAttribute(TextAttribute.FONT, g.getFont());
                    as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                    g.drawString(as.getIterator(), r.x + 4 + strWidth, r.y + 11);
                }
                g.setFont(f);
                g.setColor(color);
            }
        }
    }

    public void setTextFont(Font newFont) {
        JSS_TEXT_FONT = newFont;
    }

    public void setTextColor(Color newColor) {
        JSS_TEXT_COLOR = newColor;
    }

    private void drawEnd(Graphics2D gr, Rectangle r) {
        gr.drawImage(endImageAwt.getImage(), r.x + r.width - endImageAwt.getIconWidth() - 2, r.y + r.height - endImageAwt.getIconHeight() - 2, null);
    }

    private void drawStart(Graphics2D gr, Rectangle r) {
        gr.drawImage(startImageAwt.getImage(), r.x, r.y, null);
    }

    @Override
    public ArrayList<AbstractPainter> getDecoratorPainter(ComponentFigure fig) {
        JRPropertiesMap mapProperties = fig.getJrElement().getPropertiesMap();
        ArrayList<AbstractPainter> result = new ArrayList<AbstractPainter>();
        String tagValue = "";
        String startString = "";
        String fullString = "";
        String endString = "";
        String[] tags = new String[]{"net.sf.jasperreports.export.pdf.tag.table", "TBL", "net.sf.jasperreports.export.pdf.tag.tr", "TR", "net.sf.jasperreports.export.pdf.tag.th", "TH", "net.sf.jasperreports.export.pdf.tag.td", "TD", "net.sf.jasperreports.export.pdf.tag.l", "LIST", "net.sf.jasperreports.export.pdf.tag.li", "LIST ITEM"};
        int i = 0;
        while (i < tags.length) {
            String prop = tags[i];
            String label = tags[i + 1];
            tagValue = mapProperties.getProperty(prop);
            if (tagValue != null) {
                if (tagValue.equals("full")) {
                    fullString = String.valueOf(fullString) + label + " ";
                } else if (tagValue.equals("start")) {
                    startString = String.valueOf(startString) + label + " ";
                } else if (tagValue.equals("end")) {
                    endString = String.valueOf(label) + " " + endString;
                }
            }
            i += 2;
        }
        String headingValue = mapProperties.getProperty("net.sf.jasperreports.export.accessibility.tag");
        if (headingValue != null) {
            fullString = String.valueOf(fullString) + headingValue.toUpperCase() + " ";
        }
        startString = startString.trim();
        endString = endString.trim();
        fullString = fullString.trim();
        if (startString.length() > 0) {
            result.add(new TextLocation(AbstractPainter.Location.TopLeft, startString, JSS_TEXT_FONT, JSS_TEXT_COLOR));
        }
        if (endString.length() > 0) {
            result.add(new TextLocation(AbstractPainter.Location.BottomRight, endString, JSS_TEXT_FONT, JSS_TEXT_COLOR));
        }
        if (fullString.length() > 0) {
            TextLocation as = new TextLocation(AbstractPainter.Location.TopLeft, fullString, JSS_TEXT_FONT, JSS_TEXT_COLOR);
            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            result.add(as);
        }
        return result;
    }
}

