/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator.text;

import com.jaspersoft.studio.editor.gef.decorator.chainable.AbstractPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class TextLocation
extends AbstractPainter {
    private AttributedString value;
    private String stringValue;
    private Font font;
    private Color color;

    public TextLocation(AbstractPainter.Location loc, String value, Font font, Color color) {
        super(loc);
        this.value = new AttributedString(value);
        this.stringValue = value;
        this.font = font;
        this.color = color;
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object value) {
        this.value.addAttribute(attribute, value);
    }

    public AttributedString getValue() {
        return this.value;
    }

    public String getText() {
        return this.stringValue;
    }

    public int getLenght() {
        return this.stringValue.length();
    }

    public boolean hasValue() {
        return this.value != null && this.stringValue.length() > 0;
    }

    @Override
    public void paint(Graphics2D g, int x, int y) {
        if (this.hasValue()) {
            Font oldFont = g.getFont();
            Color oldColor = g.getColor();
            if (this.font != null) {
                g.setFont(this.font);
            }
            if (this.color != null) {
                g.setColor(this.color);
            }
            g.drawString(this.getValue().getIterator(), x, y);
            g.setFont(oldFont);
            g.setColor(oldColor);
        }
    }

    @Override
    public Point getElementSize(Graphics2D g) {
        if (this.hasValue()) {
            return new Point(g.getFontMetrics().stringWidth(this.getText()) + this.getLenght(), 7);
        }
        return new Point(0, 0);
    }
}

