/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator.xls;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.text.MStaticText;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.swt.events.ExpressionModifiedEvent;
import com.jaspersoft.studio.swt.events.ExpressionModifiedListener;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PathAndDataDialog
extends ATitledDialog {
    private Text tPath;
    private MTextElement mtext;
    private String path;
    private JRExpression data;
    private boolean repeat = false;
    private WTextExpression wtExp;
    private Button bRepeat;
    private List<JRDesignElement> tels;
    private Button bUseExp;

    public PathAndDataDialog(Shell parentShell, MTextElement mtext) {
        super(parentShell);
        this.mtext = mtext;
        this.setTitle(Messages.PathAndDataDialog_2);
        this.setDescription(Messages.PathAndDataDialog_3);
        JRDesignElement v = mtext.getValue();
        this.path = v.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
        if (this.path == null) {
            JRDesignTextField tf;
            if (mtext instanceof MTextField) {
                tf = (JRDesignTextField)v;
                if (tf.getExpression() != null) {
                    int ind;
                    this.path = tf.getExpression().getText().trim();
                    this.path = this.path.startsWith("$F{") || this.path.startsWith("$P{") || this.path.startsWith("$V{") ? ((ind = this.path.indexOf("}")) > 0 ? this.path.substring(3, ind) : this.path.substring(3)) : "column name";
                }
            } else if (mtext instanceof MStaticText) {
                tf = (JRDesignStaticText)v;
                this.path = tf.getText();
            }
        }
        this.repeat = (Boolean)Misc.nvl((Object)Boolean.valueOf(v.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.repeat.value")), (Object)false);
        JRPropertyExpression[] pExpr = v.getPropertyExpressions();
        if (pExpr != null) {
            JRPropertyExpression[] jRPropertyExpressionArray = pExpr;
            int n = pExpr.length;
            int n2 = 0;
            while (n2 < n) {
                JRPropertyExpression pe = jRPropertyExpressionArray[n2];
                if (pe.getName().equals("net.sf.jasperreports.export.xls.data")) {
                    if (pe.getValueExpression() == null) break;
                    this.data = pe.getValueExpression();
                    break;
                }
                ++n2;
            }
        }
    }

    public String getName() {
        if (Misc.isNullOrEmpty((String)this.path)) {
            return null;
        }
        return this.path;
    }

    public JRExpression getData() {
        if (Misc.isNullOrEmpty((String)this.path)) {
            return null;
        }
        return this.data;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite cmp = new Composite(area, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        cmp.setLayoutData((Object)new GridData(1808));
        new Label(cmp, 0).setText(Messages.PathAndDataDialog_7);
        this.tPath = new Text(cmp, 2048);
        this.tPath.setText(Misc.nvl((String)this.path));
        GridData gd = new GridData(4, 128, true, false, 1, 1);
        gd.widthHint = 200;
        gd.horizontalSpan = 1;
        this.tPath.setLayoutData((Object)gd);
        this.tPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathAndDataDialog.this.path = PathAndDataDialog.this.tPath.getText();
                PathAndDataDialog.this.validate(PathAndDataDialog.this.path);
                PathAndDataDialog.this.setEnabledWidgets(PathAndDataDialog.this.path);
            }
        });
        this.bRepeat = new Button(cmp, 32);
        this.bRepeat.setText(Messages.PathAndDataDialog_9);
        this.bRepeat.setSelection(this.repeat);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.bRepeat.setLayoutData((Object)gd);
        this.bRepeat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathAndDataDialog.this.repeat = PathAndDataDialog.this.bRepeat.getSelection();
            }
        });
        this.bUseExp = new Button(cmp, 32);
        this.bUseExp.setText(Messages.PathAndDataDialog_10);
        this.bRepeat.setSelection(this.repeat);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.bUseExp.setLayoutData((Object)gd);
        this.bUseExp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathAndDataDialog.this.wtExp.setEnabled(PathAndDataDialog.this.bUseExp.getSelection());
                if (!PathAndDataDialog.this.bUseExp.getSelection()) {
                    PathAndDataDialog.this.data = null;
                    PathAndDataDialog.this.wtExp.setExpression(null);
                }
            }
        });
        this.bUseExp.setSelection(this.data != null);
        this.wtExp = new WTextExpression(cmp, 0, Messages.PathAndDataDialog_11, 1, 3);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.wtExp.setLayoutData(gd);
        Object expContextAdapter = this.mtext.getAdapter(ExpressionContext.class);
        if (expContextAdapter != null) {
            this.wtExp.setExpressionContext((ExpressionContext)expContextAdapter);
        } else {
            this.wtExp.setExpressionContext(ModelUtils.getElementExpressionContext(this.mtext.getValue(), this.mtext));
        }
        this.wtExp.setExpression((JRDesignExpression)this.data);
        this.wtExp.addModifyListener(new ExpressionModifiedListener(){

            @Override
            public void expressionModified(ExpressionModifiedEvent event) {
                PathAndDataDialog.this.data = PathAndDataDialog.this.wtExp.getExpression();
            }
        });
        this.setEnabledWidgets(this.path);
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                PathAndDataDialog.this.validate(PathAndDataDialog.this.path);
            }
        });
        return area;
    }

    private void validate(String path) {
        this.getButton(0).setEnabled(true);
        this.setError("");
        if (Misc.isNullOrEmpty((String)path)) {
            JRPropertiesMap map = this.mtext.getValue().getPropertiesMap();
            if (map != null && map.getProperty("net.sf.jasperreports.export.xls.column.name") != null) {
                this.setError(Messages.PathAndDataDialog_13);
            } else {
                this.setError(Messages.PathAndDataDialog_14);
                this.getButton(0).setEnabled(false);
            }
            return;
        }
        if (this.tels == null) {
            this.tels = new ArrayList<JRDesignElement>();
            List<JRDesignElement> els = ModelUtils.getAllGElements(this.mtext.getJasperDesign());
            for (JRDesignElement de : els) {
                if (!(de instanceof JRTextElement) || de == this.mtext.getValue()) continue;
                this.tels.add(de);
            }
        }
        for (JRDesignElement te : this.tels) {
            String name;
            JRPropertiesMap map = te.getPropertiesMap();
            if (map == null || (name = map.getProperty("net.sf.jasperreports.export.xls.column.name")) == null || !name.equals(path)) continue;
            this.getButton(0).setEnabled(false);
            this.setError(Messages.PathAndDataDialog_15);
            break;
        }
    }

    private void setEnabledWidgets(String path) {
        this.bRepeat.setEnabled(!Misc.isNullOrEmpty((String)path));
        this.wtExp.setEnabled(!Misc.isNullOrEmpty((String)path) && this.bUseExp.getSelection());
        this.bUseExp.setEnabled(!Misc.isNullOrEmpty((String)path));
    }
}

