/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.figures;

import com.jaspersoft.studio.editor.gef.figures.ACachedGraphics;
import com.jaspersoft.studio.editor.gef.figures.AHandleBoundsFigure;
import com.jaspersoft.studio.editor.gef.figures.IModelFigure;
import com.jaspersoft.studio.editor.java2d.ImageGraphics2D;
import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import com.jaspersoft.studio.model.MGraphicElement;
import java.awt.Graphics2D;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRLineBox;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;

public class FrameFigure
extends AHandleBoundsFigure
implements IModelFigure {
    public FrameFigure(MGraphicElement frameModel) {
        super(frameModel);
        this.setLayoutManager((LayoutManager)new XYLayout());
    }

    public FrameFigure() {
        super(null);
        this.setLayoutManager((LayoutManager)new XYLayout());
    }

    @Override
    protected void draw(JSSDrawVisitor drawVisitor, JRElement jrElement) {
        if (this.model == null || !this.allowsFigureDrawCache()) {
            drawVisitor.visitFrame((JRFrame)jrElement);
            return;
        }
        Graphics2D oldGraphics = drawVisitor.getGraphics2d();
        if (this.needRefresh(oldGraphics)) {
            this.model.setChangedProperty(false);
            this.cachedGraphics = this.getCachedGraphics(oldGraphics);
            drawVisitor.setGraphics2D(this.cachedGraphics);
            drawVisitor.visitFrame((JRFrame)jrElement);
            drawVisitor.setGraphics2D(oldGraphics);
        }
        this.cachedGraphics.setGraphics(drawVisitor.getGraphics2d());
        this.cachedGraphics.paintCache();
    }

    @Override
    public void setJRElement(JRElement jrElement, JSSDrawVisitor drawVisitor) {
        super.setJRElement(jrElement, drawVisitor);
        Rectangle o = this.calcBorder(this.getLineBox());
        Rectangle b = this.getBounds();
        this.setBounds(new Rectangle(b.x - o.x, b.y - o.y, b.width + o.x + o.width + 1, b.height + o.y + o.height + 1));
    }

    protected JRLineBox getLineBox() {
        JRElement jrElement = this.getJrElement();
        JRLineBox box = null;
        if (jrElement != null) {
            if (jrElement instanceof JRBoxContainer) {
                box = ((JRBoxContainer)jrElement).getLineBox();
            }
            if (box == null && jrElement.getStyle() != null) {
                box = jrElement.getStyle().getLineBox();
            }
        } else {
            box = null;
        }
        return box;
    }

    @Override
    public Rectangle getHandleBounds() {
        Rectangle b = this.getBounds();
        Rectangle o = this.calcBorder(this.getLineBox());
        return new Rectangle(b.x + o.x, b.y + o.y, this.getElementWidth() + 1, this.getElementHeight() + 1);
    }

    protected int getElementWidth() {
        return this.getJrElement() != null ? this.getJrElement().getWidth() : 0;
    }

    protected int getElementHeight() {
        return this.getJrElement() != null ? this.getJrElement().getHeight() : 0;
    }

    protected Rectangle calcBorder(JRLineBox jrLineBox) {
        if (jrLineBox == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        int x = (int)Math.ceil(jrLineBox.getLeftPen().getLineWidth().floatValue() / 2.0f);
        int y = (int)Math.ceil(jrLineBox.getTopPen().getLineWidth().floatValue() / 2.0f);
        int w = (int)Math.ceil(jrLineBox.getRightPen().getLineWidth().floatValue() / 2.0f) + 1;
        int h = (int)Math.ceil(jrLineBox.getBottomPen().getLineWidth().floatValue() / 2.0f) + 1;
        return new Rectangle(x, y, w, h);
    }

    @Override
    protected ACachedGraphics getCachedGraphics(Graphics2D originalGraphics) {
        return new ImageGraphics2D(originalGraphics);
    }
}

