/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.figures;

import com.jaspersoft.studio.editor.gef.figures.ACachedGraphics;
import com.jaspersoft.studio.editor.gef.figures.AHandleBoundsFigure;
import com.jaspersoft.studio.editor.gef.figures.IModelFigure;
import com.jaspersoft.studio.editor.java2d.StackGraphics2D;
import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import com.jaspersoft.studio.model.MGraphicElement;
import java.awt.Graphics2D;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRPen;
import org.eclipse.draw2d.geometry.Rectangle;

public class LineFigure
extends AHandleBoundsFigure
implements IModelFigure {
    public LineFigure(MGraphicElement lineModel) {
        super(null);
        this.model = lineModel;
    }

    @Override
    protected void draw(JSSDrawVisitor drawVisitor, JRElement jrElement) {
        Graphics2D oldGraphics = drawVisitor.getGraphics2d();
        if (this.needRefresh(oldGraphics)) {
            this.model.setChangedProperty(false);
            this.cachedGraphics = this.getCachedGraphics(oldGraphics);
            drawVisitor.setGraphics2D(this.cachedGraphics);
            drawVisitor.visitLine((JRLine)jrElement);
            drawVisitor.setGraphics2D(oldGraphics);
        }
        this.cachedGraphics.setGraphics(drawVisitor.getGraphics2d());
        this.cachedGraphics.paintCache();
    }

    @Override
    public void setJRElement(JRElement jrElement, JSSDrawVisitor drawVisitor) {
        super.setJRElement(jrElement, drawVisitor);
        int offset = this.calcBorder(this.getLinePen());
        Rectangle b = this.getBounds();
        this.setBounds(new Rectangle(b.x - offset, b.y - offset, b.width + offset * 2 + 1, b.height + offset * 2 + 1));
    }

    protected JRPen getLinePen() {
        JRCommonGraphicElement jrElement = (JRCommonGraphicElement)this.getJrElement();
        if (jrElement == null) {
            return null;
        }
        return jrElement.getLinePen();
    }

    @Override
    public Rectangle getHandleBounds() {
        Rectangle b = this.getBounds();
        int offset = this.calcBorder(this.getLinePen());
        JRElement jrElement = this.getJrElement();
        if (jrElement == null) {
            return new Rectangle(b.x + offset, b.y + offset, 0, 0);
        }
        return new Rectangle(b.x + offset, b.y + offset, jrElement.getWidth() + 1, jrElement.getHeight() + 1);
    }

    protected int calcBorder(JRPen jrPen) {
        if (jrPen == null) {
            return 0;
        }
        int offset = (int)Math.ceil((double)jrPen.getLineWidth().floatValue() / 2.0) + 1;
        return offset;
    }

    @Override
    protected ACachedGraphics getCachedGraphics(Graphics2D originalGraphics) {
        return new StackGraphics2D(originalGraphics);
    }
}

