/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.figures.svg;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.figures.JRComponentFigure;
import com.jaspersoft.studio.editor.gef.figures.svg.InferringNamespaceContext;
import com.jaspersoft.studio.editor.gef.figures.svg.SVGUtils;
import com.jaspersoft.studio.editor.gef.figures.svg.SimpleImageTranscoder;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.WeakHashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.util.XMLResourceDescriptor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SVGFigure
extends JRComponentFigure {
    private String uri;
    private boolean failedToLoadDocument;
    private boolean specifyCanvasWidth = true;
    private boolean specifyCanvasHeight = true;
    private SimpleImageTranscoder transcoder;
    private static WeakHashMap<String, Document> documentsMap = new WeakHashMap();

    public final String getURI() {
        return this.uri;
    }

    public final void setURI(String uri) {
        this.setURI(uri, true);
    }

    public void setURI(String uri, boolean loadOnDemand) {
        this.uri = uri;
        this.transcoder = null;
        this.failedToLoadDocument = false;
        if (loadOnDemand) {
            this.loadDocument();
        }
    }

    private void loadDocument() {
        this.transcoder = null;
        this.failedToLoadDocument = true;
        if (this.uri == null) {
            return;
        }
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        try {
            Document document;
            if (documentsMap.containsKey(this.uri)) {
                document = documentsMap.get(this.uri);
            } else {
                document = factory.createDocument(this.uri);
                documentsMap.put(this.uri, document);
            }
            this.transcoder = new SimpleImageTranscoder(document);
            this.failedToLoadDocument = false;
        }
        catch (IOException e) {
            JaspersoftStudioPlugin.getInstance().logError("Error loading SVG file", e);
        }
    }

    protected final Document getDocument() {
        if (this.failedToLoadDocument) {
            return null;
        }
        if (this.transcoder == null) {
            this.loadDocument();
        }
        return this.transcoder == null ? null : this.transcoder.getDocument();
    }

    public final boolean checkContentAvailable() {
        return this.getDocument() != null;
    }

    private XPath getXPath() {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new InferringNamespaceContext(this.getDocument().getDocumentElement()));
        return xpath;
    }

    protected final NodeList getNodes(String query) {
        Document document = this.getDocument();
        if (document != null) {
            try {
                return (NodeList)this.getXPath().evaluate(query, document, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected Color getColor(Element element, String attributeName) {
        if (this.getDocument() == null || this.getDocument() != element.getOwnerDocument()) {
            return null;
        }
        Color color = null;
        BridgeContext ctx = this.transcoder.initCSSEngine();
        try {
            color = SVGUtils.toSWTColor(element, attributeName);
        }
        finally {
            if (ctx != null) {
                ctx.dispose();
            }
        }
        return color;
    }

    @Override
    public void paint(Graphics graphics) {
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        Rectangle r = this.getClientArea();
        this.transcoder.setCanvasSize(this.specifyCanvasWidth ? r.width : -1, this.specifyCanvasHeight ? r.height : -1);
        this.updateRenderingHints(graphics);
        BufferedImage awtImage = this.transcoder.getBufferedImage();
        if (awtImage != null) {
            int imgWidth = awtImage.getWidth(null);
            int imgHeight = awtImage.getHeight(null);
            Graphics2D g = ComponentFigure.getG2D(graphics);
            if (g != null) {
                g.setColor(java.awt.Color.WHITE);
                g.fillRect(r.x, r.y, r.x + r.width, r.y + r.height);
                g.drawImage(awtImage, r.x, r.y, r.x + r.width, r.y + r.height, 0, 0, imgWidth, imgHeight, null);
            }
            this.paintBorder(graphics);
            this.paintDecorators(graphics);
        }
    }

    private void updateRenderingHints(Graphics graphics) {
        int aa = -1;
        try {
            aa = graphics.getAntialias();
        }
        catch (Exception exception) {}
        Object aaHint = aa == 1 ? RenderingHints.VALUE_ANTIALIAS_ON : (aa == 0 ? RenderingHints.VALUE_ANTIALIAS_OFF : RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        if (this.transcoder.getRenderingHints().get(RenderingHints.KEY_ANTIALIASING) != aaHint) {
            this.transcoder.getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, aaHint);
            this.transcoder.contentChanged();
        }
        aa = -1;
        try {
            aa = graphics.getTextAntialias();
        }
        catch (Exception exception) {}
        aaHint = aa == 1 ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : (aa == 0 ? RenderingHints.VALUE_TEXT_ANTIALIAS_OFF : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        if (this.transcoder.getRenderingHints().get(RenderingHints.KEY_TEXT_ANTIALIASING) != aaHint) {
            this.transcoder.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, aaHint);
            this.transcoder.contentChanged();
        }
    }

    public final Rectangle2D getAreaOfInterest() {
        this.getDocument();
        return this.transcoder == null ? null : this.transcoder.getCanvasAreaOfInterest();
    }

    public void setAreaOfInterest(Rectangle2D value) {
        this.getDocument();
        if (this.transcoder != null) {
            this.transcoder.setCanvasAreaOfInterest(value);
        }
        this.repaint();
    }

    public final boolean isSpecifyCanvasWidth() {
        return this.specifyCanvasWidth;
    }

    public void setSpecifyCanvasWidth(boolean specifyCanvasWidth) {
        this.specifyCanvasWidth = specifyCanvasWidth;
        this.contentChanged();
    }

    public final boolean isSpecifyCanvasHeight() {
        return this.specifyCanvasHeight;
    }

    public void setSpecifyCanvasHeight(boolean specifyCanvasHeight) {
        this.specifyCanvasHeight = specifyCanvasHeight;
        this.contentChanged();
    }

    public void contentChanged() {
        this.getDocument();
        if (this.transcoder != null) {
            this.transcoder.contentChanged();
        }
        this.repaint();
    }
}

