/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.figures.svg;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.w3c.dom.Document;

public class SimpleImageTranscoder
extends SVGAbstractTranscoder {
    private BufferedImage bufferedImage;
    private Document document;
    private int canvasWidth = -1;
    private int canvasHeight = -1;
    private Rectangle2D canvasAOI;
    private RenderingHints renderingHints;

    public SimpleImageTranscoder(Document document) {
        this.document = document;
        this.renderingHints = new RenderingHints(null);
    }

    public final Document getDocument() {
        return this.document;
    }

    public final RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public final int getCanvasWidth() {
        return this.canvasWidth;
    }

    public final int getCanvasHeight() {
        return this.canvasHeight;
    }

    public void setCanvasSize(int width, int height) {
        if (this.canvasWidth == width && this.canvasHeight == height) {
            return;
        }
        this.canvasWidth = width;
        this.canvasHeight = height;
        this.contentChanged();
    }

    public final Rectangle2D getCanvasAreaOfInterest() {
        if (this.canvasAOI == null) {
            return null;
        }
        Rectangle2D.Float result = new Rectangle2D.Float();
        ((Rectangle2D)result).setRect(this.canvasAOI);
        return result;
    }

    public void setCanvasAreaOfInterest(Rectangle2D value) {
        if (value == null) {
            if (this.canvasAOI == null) {
                return;
            }
            this.canvasAOI = null;
            this.contentChanged();
            return;
        }
        if (value.equals(this.canvasAOI)) {
            return;
        }
        this.canvasAOI = new Rectangle2D.Float();
        this.canvasAOI.setRect(value);
        this.contentChanged();
    }

    public BridgeContext initCSSEngine() {
        if (this.document == null) {
            return null;
        }
        SVGOMDocument sd = (SVGOMDocument)this.document;
        if (sd.getCSSEngine() != null) {
            return null;
        }
        class BridgeContextEx
        extends BridgeContext {
            public BridgeContextEx() {
                super(SimpleImageTranscoder.this.userAgent);
                this.setDocument(SimpleImageTranscoder.this.document);
                this.initializeDocument(SimpleImageTranscoder.this.document);
            }
        }
        return new BridgeContextEx();
    }

    public void contentChanged() {
        this.bufferedImage = null;
    }

    private void updateImage() {
        if (this.document == null) {
            return;
        }
        try {
            if (this.canvasWidth >= 0) {
                this.addTranscodingHint(ImageTranscoder.KEY_WIDTH, new Float(this.canvasWidth));
            } else {
                this.removeTranscodingHint(ImageTranscoder.KEY_WIDTH);
            }
            if (this.canvasHeight >= 0) {
                this.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, new Float(this.canvasHeight));
            } else {
                this.removeTranscodingHint(ImageTranscoder.KEY_HEIGHT);
            }
            if (this.canvasAOI != null) {
                this.addTranscodingHint(ImageTranscoder.KEY_AOI, this.canvasAOI);
            } else {
                this.removeTranscodingHint(ImageTranscoder.KEY_AOI);
            }
            this.transcode(new TranscoderInput(this.document), new TranscoderOutput());
        }
        catch (TranscoderException e) {
            JaspersoftStudioPlugin.getInstance().logError("Error transcoding SVG image", e);
        }
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        super.transcode(document, uri, output);
        int w = (int)((double)this.width + 0.5);
        int h = (int)((double)this.height + 0.5);
        ImageRenderer renderer = this.createImageRenderer();
        renderer.updateOffScreen(w, h);
        renderer.setTransform(this.curTxf);
        renderer.setTree(this.root);
        this.root = null;
        try {
            Rectangle2D.Float raoi = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            renderer.repaint(this.curTxf.createInverse().createTransformedShape(raoi));
            this.bufferedImage = renderer.getOffScreen();
        }
        catch (Exception ex) {
            throw new TranscoderException(ex);
        }
    }

    protected ImageRenderer createImageRenderer() {
        StaticRenderer renderer = new StaticRenderer();
        renderer.getRenderingHints().add(this.renderingHints);
        return renderer;
    }

    public final BufferedImage getBufferedImage() {
        if (this.bufferedImage == null) {
            this.updateImage();
        }
        return this.bufferedImage;
    }
}

