/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.band;

import com.jaspersoft.studio.editor.java2d.J2DGraphics;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.utils.UIUtil;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Color;

public class BandResizableEditPolicy
extends ResizableEditPolicy {
    private String feedbackText = "";
    private static java.awt.Color marginColor = null;

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (this.getHost().getModel() instanceof IGraphicElement) {
            APropertyNode n = (APropertyNode)this.getHost().getModel();
            int bandHeight = (Integer)n.getPropertyValue("height");
            Integer bWidth = (Integer)n.getPropertyValue("width");
            Rectangle oldBounds = new Rectangle(0, 0, bWidth != null ? bWidth : 0, bandHeight);
            PrecisionRectangle rect2 = new PrecisionRectangle(new Rectangle(0, 0, request.getSizeDelta().width, request.getSizeDelta().height));
            this.getHostFigure().translateToRelative((Translatable)rect2);
            oldBounds.resize(rect2.width, rect2.height);
            this.setFeedbackText(String.valueOf(oldBounds.height) + (bWidth != null ? "," + oldBounds.width : "") + " px");
        }
        super.showChangeBoundsFeedback(request);
        if (Util.isLinux()) {
            this.getHost().getViewer().getControl().redraw();
        }
    }

    public BandResizableEditPolicy() {
        this.setDragAllowed(false);
    }

    protected List<AbstractHandle> createSelectionHandles() {
        ArrayList<AbstractHandle> list = new ArrayList<AbstractHandle>();
        MoveHandle handle = new MoveHandle((GraphicalEditPart)this.getHost());
        handle.setBorder((Border)new MarginBorder(5));
        list.add((AbstractHandle)handle);
        return list;
    }

    protected IFigure createDragSourceFeedbackFigure() {
        RectangleFigure r = new RectangleFigure(){

            public void paintClientArea(Graphics g) {
                String text = BandResizableEditPolicy.this.getFeedbackText();
                if (g == null) {
                    return;
                }
                Rectangle clientArea = this.getClientArea();
                Graphics2D gr = ((J2DGraphics)g).getGraphics2D();
                gr.setColor(java.awt.Color.gray);
                gr.fillOval(clientArea.x + clientArea.width / 2 - 3, clientArea.y - 3, 7, 7);
                gr.fillOval(clientArea.x + clientArea.width / 2 - 3, clientArea.y + clientArea.height - 4, 7, 7);
                if (clientArea.width < 20 || clientArea.height < 20) {
                    gr.drawLine(clientArea.x + clientArea.width / 2, clientArea.y, clientArea.x + clientArea.width / 2, clientArea.y + clientArea.height);
                    return;
                }
                FontMetrics fm = gr.getFontMetrics();
                Rectangle2D textBounds = fm.getStringBounds(text, gr);
                java.awt.Rectangle textBgBounds = new java.awt.Rectangle(clientArea.x - 30 + (clientArea.width + 60) / 2 - (int)textBounds.getWidth() / 2 - 10, clientArea.y - 30 + (clientArea.height + 60) / 2 - (int)textBounds.getHeight() / 2 - 2, (int)textBounds.getWidth() + 20, (int)textBounds.getHeight() + 4);
                gr.setColor(new java.awt.Color(30, 30, 30, 128));
                gr.fillRoundRect(textBgBounds.x, textBgBounds.y, textBgBounds.width, textBgBounds.height, 20, 20);
                gr.drawLine(clientArea.x - 30 + (clientArea.width + 60) / 2, clientArea.y - 30, clientArea.x - 30 + (clientArea.width + 60) / 2, clientArea.y - 30 + (clientArea.height + 60 - textBgBounds.height) / 2);
                gr.drawLine(clientArea.x - 30 + (clientArea.width + 60) / 2, clientArea.y - 30 + (clientArea.height + 60 + textBgBounds.height) / 2, clientArea.x - 30 + (clientArea.width + 60) / 2, clientArea.y - 30 + clientArea.height + 60);
                gr.setColor(java.awt.Color.white);
                gr.drawString(text, textBgBounds.x + 10, textBgBounds.y + fm.getAscent());
            }
        };
        r.setOpaque(false);
        r.setFill(false);
        r.setBounds(this.getInitialFeedbackBounds());
        this.addFeedback((IFigure)r);
        return r;
    }

    private void setFeedbackText(String feedbackText) {
        this.feedbackText = feedbackText;
    }

    private String getFeedbackText() {
        return this.feedbackText;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        if (request.getSizeDelta().height != 0 && (request.getResizeDirection() == 4 || request.getResizeDirection() == 1)) {
            APropertyNode n = (APropertyNode)this.getHost().getModel();
            int bandHeight = (Integer)n.getPropertyValue("height");
            Rectangle oldBounds = new Rectangle(0, 0, 0, bandHeight);
            PrecisionRectangle rect2 = new PrecisionRectangle(new Rectangle(0, 0, request.getSizeDelta().width, request.getSizeDelta().height));
            this.getHostFigure().translateToRelative((Translatable)rect2);
            int height = oldBounds.resize((int)rect2.width, (int)rect2.height).height;
            if (height < 0) {
                height = 0;
            }
            SetValueCommand setCommand = new SetValueCommand();
            setCommand.setTarget(n);
            setCommand.setLabel("Resize Band");
            setCommand.setPropertyId("height");
            setCommand.setPropertyValue(height);
            return setCommand;
        }
        return null;
    }

    private class MarginBorder
    extends LineBorder {
        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            if (figure.getChildren().isEmpty()) {
                figure.add((IFigure)new Label());
            }
            Rectangle bounds = figure.getBounds();
            Graphics2D g = ((J2DGraphics)graphics).getGraphics2D();
            if (marginColor == null) {
                Color editorBackgroundColor = UIUtil.getColor("org.eclipse.ui.workbench.INFORMATION_BACKGROUND");
                marginColor = new java.awt.Color(Math.abs(editorBackgroundColor.getRed() - 128), Math.abs(editorBackgroundColor.getGreen() - 255), Math.abs(editorBackgroundColor.getBlue() - 255));
            }
            g.setColor(marginColor);
            g.fillRect(bounds.x - 3, bounds.y + 5, 5, bounds.height - 10);
        }

        public MarginBorder(int width) {
            super(width);
        }
    }
}

