/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.band;

import com.jaspersoft.studio.editor.gef.parts.MainDesignerRootEditPart;
import com.jaspersoft.studio.editor.gef.parts.band.BandEditPart;
import com.jaspersoft.studio.editor.java2d.J2DGraphics;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.compatibility.FigureUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import net.sf.jasperreports.eclipse.util.Pair;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.gef.util.EditPartUtilities;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;

public class NotMovablePartDragTracker
extends SelectEditPartTracker {
    private static Color borderColor = new Color(0, 50, 200, 128);
    private static Color fillColor = new Color(168, 202, 236, 128);
    public static final int BEHAVIOR_NODES_CONTAINED = new Integer(1);
    public static final int BEHAVIOR_NODES_TOUCHED = new Integer(4);
    private static final Request MARQUEE_REQUEST = new Request((Object)"selection");
    public static final Object PROPERTY_MARQUEE_BEHAVIOR = "marqueeBehavior";
    public static final int DEFAULT_MARQUEE_BEHAVIOR = BEHAVIOR_NODES_CONTAINED;
    private static final int DEFAULT_MODE = 0;
    private static final int TOGGLE_MODE = 1;
    private static final int APPEND_MODE = 2;
    private int marqueeBehavior = DEFAULT_MARQUEE_BEHAVIOR;
    private Figure marqueeRectangleFigure;
    private int mode;
    private Collection<EditPart> selectedEditParts;
    private Request targetRequest;
    private int dragStart = -1;

    public NotMovablePartDragTracker(EditPart owner) {
        super(owner);
    }

    public NotMovablePartDragTracker() {
        super(null);
        this.setDefaultCursor(SharedCursors.CROSS);
        this.setUnloadWhenFinished(false);
    }

    public void mouseUp(MouseEvent me, EditPartViewer viewer) {
        boolean wasDragging = this.movedPastThreshold();
        if (me.button == 1 && !wasDragging) {
            EditPart clickedPart = viewer.findObjectAt(new Point(me.x, me.y));
            if (clickedPart instanceof BandEditPart) {
                viewer.select(clickedPart);
            } else if (clickedPart instanceof MainDesignerRootEditPart) {
                viewer.select((EditPart)clickedPart.getChildren().get(0));
            } else {
                viewer.deselectAll();
            }
        } else {
            super.mouseUp(me, viewer);
        }
    }

    protected void handleFinished() {
        this.dragStart = -1;
        if (this.unloadWhenFinished()) {
            this.getDomain().loadDefaultTool();
        } else {
            this.reactivate();
        }
    }

    protected void applyProperty(Object key, Object value) {
        if (PROPERTY_MARQUEE_BEHAVIOR.equals(key)) {
            if (value instanceof Integer) {
                this.setMarqueeBehavior((Integer)value);
            }
            return;
        }
        super.applyProperty(key, value);
    }

    private String getNodeIndex(EditPart part) {
        ANode model = (ANode)part.getModel();
        ANode parent = model.getParent();
        StringBuilder path = new StringBuilder();
        while (parent != null && parent.getParent() != null) {
            int index = parent.getChildren().indexOf(model) + 1;
            model = parent;
            parent = model.getParent();
            path.insert(0, index);
            if (parent == null || parent.getParent() == null) continue;
            path.insert(0, ".");
        }
        return path.toString();
    }

    private Integer comparePath(String str1, String str2) {
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        int i = 0;
        while (i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i])) {
            ++i;
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    protected Collection<EditPart> calculateMarqueeSelectedEditParts() {
        HashSet<EditPart> marqueeSelectedEditParts = new HashSet<EditPart>();
        marqueeSelectedEditParts.addAll(this.calculatePrimaryMarqueeSelectedEditParts());
        marqueeSelectedEditParts.addAll(this.calculateSecondaryMarqueeSelectedEditParts(marqueeSelectedEditParts));
        ArrayList<Pair> orderedParts = new ArrayList<Pair>();
        for (EditPart part : marqueeSelectedEditParts) {
            orderedParts.add(new Pair((Object)this.getNodeIndex(part), (Object)part));
        }
        Collections.sort(orderedParts, new Comparator<Pair<String, EditPart>>(){

            @Override
            public int compare(Pair<String, EditPart> o1, Pair<String, EditPart> o2) {
                return NotMovablePartDragTracker.this.comparePath((String)o1.getKey(), (String)o2.getKey());
            }
        });
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        for (Pair part : orderedParts) {
            result.add((EditPart)part.getValue());
        }
        return result;
    }

    protected Collection<EditPart> calculatePrimaryMarqueeSelectedEditParts() {
        HashSet editPartsToProcess = new HashSet();
        editPartsToProcess.addAll(EditPartUtilities.getAllChildren((GraphicalEditPart)((GraphicalEditPart)this.getCurrentViewer().getRootEditPart())));
        ArrayList<EditPart> marqueeSelectedEditParts = new ArrayList<EditPart>();
        for (GraphicalEditPart editPart : editPartsToProcess) {
            if (!this.isMarqueeSelectable(editPart) || !this.isPrimaryMarqueeSelectedEditPart(editPart)) continue;
            marqueeSelectedEditParts.add((EditPart)editPart);
        }
        return marqueeSelectedEditParts;
    }

    protected Collection<EditPart> calculateSecondaryMarqueeSelectedEditParts(Collection<EditPart> directlyMarqueeSelectedEditParts) {
        HashSet editPartsToProcess = new HashSet();
        for (GraphicalEditPart graphicalEditPart : directlyMarqueeSelectedEditParts) {
            editPartsToProcess.addAll(graphicalEditPart.getSourceConnections());
            editPartsToProcess.addAll(graphicalEditPart.getTargetConnections());
        }
        HashSet<EditPart> secondaryMarqueeSelectedEditParts = new HashSet<EditPart>();
        for (GraphicalEditPart editPart : editPartsToProcess) {
            if (!this.isMarqueeSelectable(editPart)) continue;
            secondaryMarqueeSelectedEditParts.add((EditPart)editPart);
        }
        return secondaryMarqueeSelectedEditParts;
    }

    private boolean isPrimaryMarqueeSelectedEditPart(GraphicalEditPart editPart) {
        IFigure figure = editPart.getFigure();
        Rectangle r = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)r);
        boolean included = false;
        Rectangle marqueeSelectionRectangle = this.getCurrentMarqueeSelectionRectangle();
        if (this.marqueeBehavior == BEHAVIOR_NODES_TOUCHED) {
            included = marqueeSelectionRectangle.intersects(r);
        } else if (this.marqueeBehavior == BEHAVIOR_NODES_CONTAINED) {
            included = marqueeSelectionRectangle.contains(r);
        }
        return included;
    }

    protected Request createTargetRequest() {
        return MARQUEE_REQUEST;
    }

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.setState(0x40000000);
    }

    protected void eraseMarqueeFeedback() {
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
    }

    protected void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        for (EditPart editPart : this.selectedEditParts) {
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    protected String getCommandName() {
        return "selection";
    }

    protected Rectangle getCurrentMarqueeSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    protected int getCurrentSelectionMode() {
        return this.mode;
    }

    protected IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = new MarqueeRectangleFigure();
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    protected Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected boolean handleButtonDown(int button) {
        if (!this.isViewerImportant(null)) {
            return true;
        }
        if ((button == 3 || button == 1) && this.isInState(1)) {
            this.performConditionalSelection();
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
                this.setSelectionMode(1);
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                this.setSelectionMode(2);
            } else {
                this.setSelectionMode(0);
            }
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.eraseMarqueeFeedback();
            this.performMarqueeSelect();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            if (this.dragStart == -1) {
                this.dragStart = this.getLocation().y;
            } else if (this.getLocation().y < this.dragStart) {
                this.marqueeBehavior = BEHAVIOR_NODES_TOUCHED;
            }
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = this.calculateMarqueeSelectedEditParts();
            this.showTargetFeedback();
            if (Util.isLinux()) {
                this.getCurrentViewer().getControl().redraw();
            }
        }
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.handleFinished();
            return true;
        }
        return false;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (super.handleKeyDown(e)) {
            return true;
        }
        if (this.getCurrentViewer().getKeyHandler() != null) {
            return this.getCurrentViewer().getKeyHandler().keyPressed(e);
        }
        return false;
    }

    protected boolean isMarqueeSelectable(GraphicalEditPart editPart) {
        return editPart.isSelectable() && FigureUtilities.isNotFullyClipped(editPart.getFigure()) && editPart.getModel() instanceof MGraphicElement;
    }

    protected boolean isViewerImportant(EditPartViewer viewer) {
        return this.getCurrentViewer() instanceof GraphicalViewer;
    }

    protected void performMarqueeSelect() {
        Collection<EditPart> marqueeSelectedEditParts = this.calculateMarqueeSelectedEditParts();
        LinkedHashSet<EditPart> editPartsToSelect = new LinkedHashSet<EditPart>();
        HashSet<EditPart> editPartsToDeselect = new HashSet<EditPart>();
        for (EditPart affectedEditPart : marqueeSelectedEditParts) {
            if (affectedEditPart.getSelected() == 0 || this.getCurrentSelectionMode() != 1) {
                editPartsToSelect.add(affectedEditPart);
                continue;
            }
            editPartsToDeselect.add(affectedEditPart);
        }
        if (this.getCurrentSelectionMode() != 0) {
            editPartsToSelect.addAll(this.getCurrentViewer().getSelectedEditParts());
            editPartsToSelect.removeAll(editPartsToDeselect);
        }
        this.getCurrentViewer().setSelection((ISelection)new StructuredSelection(editPartsToSelect.toArray()));
    }

    public void setMarqueeBehavior(int type) {
        if (type != BEHAVIOR_NODES_TOUCHED && type != BEHAVIOR_NODES_CONTAINED) {
            throw new IllegalArgumentException("Invalid marquee behaviour specified.");
        }
        this.marqueeBehavior = type;
    }

    private void setSelectionMode(int mode) {
        this.mode = mode;
    }

    protected boolean handleDoubleClick(int button) {
        if (this.getSourceEditPart() != null) {
            super.handleDoubleClick(button);
        }
        return true;
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
        if (viewer instanceof GraphicalViewer) {
            this.setDefaultCursor(SharedCursors.CROSS);
        } else {
            this.setDefaultCursor(SharedCursors.NO);
        }
    }

    private void showMarqueeFeedback() {
        Rectangle rect = this.getCurrentMarqueeSelectionRectangle().getCopy();
        IFigure marqueeFeedbackFigure = this.getMarqueeFeedbackFigure();
        marqueeFeedbackFigure.translateToRelative((Translatable)rect);
        marqueeFeedbackFigure.setBounds(rect);
        marqueeFeedbackFigure.validate();
    }

    protected void showTargetFeedback() {
        for (EditPart editPart : this.selectedEditParts) {
            editPart.showTargetFeedback(this.getTargetRequest());
        }
    }

    protected boolean movedPastThreshold() {
        if (this.getSourceEditPart() == null) {
            return true;
        }
        return super.movedPastThreshold();
    }

    class MarqueeRectangleFigure
    extends Figure {
        private static final int DELAY = 110;
        private int offset = 0;
        private boolean schedulePaint = true;

        MarqueeRectangleFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds = this.getBounds().getCopy();
            graphics.translate(this.getLocation());
            Graphics2D gr = ((J2DGraphics)graphics).getGraphics2D();
            gr.setColor(fillColor);
            gr.fillRect(0, 0, bounds.width - 1, bounds.height - 1);
            gr.setStroke(new BasicStroke(2.0f));
            gr.setColor(borderColor);
            gr.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
            if (this.schedulePaint) {
                Display.getCurrent().timerExec(110, new Runnable(){

                    @Override
                    public void run() {
                        ++MarqueeRectangleFigure.this.offset;
                        if (MarqueeRectangleFigure.this.offset > 5) {
                            MarqueeRectangleFigure.this.offset = 0;
                        }
                        MarqueeRectangleFigure.this.schedulePaint = true;
                        MarqueeRectangleFigure.this.repaint();
                    }
                });
            }
            this.schedulePaint = false;
        }
    }
}

