/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.editPolicy;

import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.spreadsheet.SpreadsheetLayout;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.property.SetPropertyValueCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.ExtendedMessageDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class ElementEditPolicy
extends ComponentEditPolicy {
    public static final String DELETED_MODELS_KEY = "deletedModels";

    protected Command createDeleteCommand(GroupRequest request) {
        ANode node;
        ANode parent;
        if (this.getHost() != null && this.getHost().getModel() != null && (parent = (node = (ANode)this.getHost().getModel()).getParent()) != null) {
            Object isCalculatingEnablement = request.getExtendedData().get("calculatingEnable");
            if (Boolean.FALSE.equals(isCalculatingEnablement) && SpreadsheetLayout.class.equals(LayoutManager.getContainerLayout(parent))) {
                return this.handleSpreadsheetDelete(node, parent, request);
            }
            return OutlineTreeEditPartFactory.getDeleteCommand(parent, node);
        }
        return null;
    }

    protected HashMap<Object, Boolean> getDeletedNodes(GroupRequest request) {
        HashMap<Object, Boolean> deletedElements = (HashMap<Object, Boolean>)request.getExtendedData().get(DELETED_MODELS_KEY);
        if (deletedElements == null) {
            deletedElements = new HashMap<Object, Boolean>();
            for (Object object : request.getEditParts()) {
                EditPart part = (EditPart)object;
                deletedElements.put(((ANode)part.getModel()).getValue(), Boolean.FALSE);
            }
            request.getExtendedData().put(DELETED_MODELS_KEY, deletedElements);
        }
        return deletedElements;
    }

    protected boolean areConnectedElementAlreadyDeleted(List<JRDesignElement> connectedElements, HashMap<Object, Boolean> deletedElements) {
        for (JRDesignElement connectedElement : connectedElements) {
            Boolean isDeleted = deletedElements.get(connectedElement);
            if (isDeleted != null && isDeleted.booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected boolean isWipingEntireColumn(List<JRDesignElement> connectedElements, HashMap<Object, Boolean> deletedElements) {
        for (JRDesignElement connectedElement : connectedElements) {
            if (deletedElements.containsKey(connectedElement)) continue;
            return false;
        }
        return true;
    }

    protected Command handleSpreadsheetDelete(ANode target, ANode parent, GroupRequest request) {
        JasperDesign jd;
        List<JRDesignElement> list;
        JRPropertiesHolder targetHolder;
        String deleteElementUUID;
        ArrayList<Command> deleteCommands = new ArrayList<Command>();
        HashMap<Object, Boolean> deletedElements = this.getDeletedNodes(request);
        HashSet<Object> connectedParents = new HashSet<Object>();
        Boolean hasGeneratedCommand = deletedElements.get(target.getValue());
        if (hasGeneratedCommand == null || !hasGeneratedCommand.booleanValue()) {
            deletedElements.put(target.getValue(), true);
            connectedParents.add(parent.getValue());
            deleteCommands.add(OutlineTreeEditPartFactory.getDeleteCommand(parent, target));
        }
        if ((deleteElementUUID = (targetHolder = LayoutManager.getPropertyHolder(target)).getPropertiesMap().getProperty("com.jaspersoft.studio.spreadsheet.connectionID")) != null && (list = SpreadsheetLayout.getElementsForUUID(deleteElementUUID, jd = parent.getJasperDesign(), ModelUtils.getReport(parent))) != null && !list.isEmpty() && !this.areConnectedElementAlreadyDeleted(list, deletedElements)) {
            boolean deleteColumn;
            int messageResult = 1;
            if (!this.isWipingEntireColumn(list, deletedElements)) {
                messageResult = this.openMessageDialog(parent);
            }
            if (messageResult == 2 || messageResult == -1) {
                request.getExtendedData().put("cancelOperation", Boolean.TRUE);
                return null;
            }
            boolean bl = deleteColumn = messageResult == 0;
            if (deleteColumn) {
                for (JRDesignElement connectedElement : list) {
                    Command deleteCmd;
                    ANode node;
                    if (connectedElement == target.getValue() || (node = SelectionHelper.getNode(connectedElement)) == null || node.getParent() == null || deletedElements.containsKey(node.getValue())) continue;
                    JRPropertiesHolder parentHolder = (JRPropertiesHolder)node.getParent().getValue();
                    String parentLayout = parentHolder.getPropertiesMap().getProperty("com.jaspersoft.studio.layout");
                    if (!SpreadsheetLayout.class.getName().equals(parentLayout) || (deleteCmd = OutlineTreeEditPartFactory.getDeleteCommand(node.getParent(), node)) == null) continue;
                    deletedElements.put(node.getValue(), true);
                    deleteCommands.add(deleteCmd);
                    connectedParents.add(node.getParent().getValue());
                }
            }
        }
        if (!deleteCommands.isEmpty()) {
            CompoundCommand result = new CompoundCommand();
            for (Object e : connectedParents) {
                JRPropertiesHolder parentHolder = (JRPropertiesHolder)e;
                SetPropertyValueCommand removeLayoutComd = new SetPropertyValueCommand(parentHolder.getPropertiesMap(), "com.jaspersoft.studio.layout", null);
                result.add((Command)removeLayoutComd);
            }
            for (Command command : deleteCommands) {
                result.add(command);
            }
            for (Object e : connectedParents) {
                JRPropertiesHolder parentHolder = (JRPropertiesHolder)e;
                SetPropertyValueCommand setLayoutComd = new SetPropertyValueCommand(parentHolder.getPropertiesMap(), "com.jaspersoft.studio.layout", SpreadsheetLayout.class.getName());
                result.add((Command)setLayoutComd);
            }
            result.add((Command)LayoutManager.createRelayoutCommand(parent));
            return result;
        }
        return null;
    }

    protected int openMessageDialog(ANode deletedParent) {
        boolean isDetailBand = false;
        ANode currentParent = deletedParent;
        while (currentParent != null) {
            if (currentParent instanceof MBand) {
                MBand band = (MBand)currentParent;
                if (band.getBandType() != BandTypeEnum.DETAIL) break;
                isDetailBand = true;
                break;
            }
            currentParent = currentParent.getParent();
        }
        ExtendedMessageDialog dialog = null;
        dialog = isDetailBand ? new ExtendedMessageDialog(UIUtils.getShell(), Messages.SpreadsheetPostDelete_title, null, Messages.SpreadsheetPostDelete_messageDetail, 4, new String[]{Messages.SpreadsheetPostDelete_optionDeleteColumn, Messages.SpreadsheetPostDelete_optionDeleteSelected, "Cancel"}, 2, null) : new ExtendedMessageDialog(UIUtils.getShell(), Messages.SpreadsheetPostDelete_title, null, Messages.SpreadsheetPostDelete_message, 3, new String[]{Messages.SpreadsheetPostDelete_optionDeleteColumn, Messages.SpreadsheetPostDelete_optionDeleteSelected, "Cancel"}, 2, null);
        return dialog.open();
    }
}

