/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.editPolicy;

import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.FrameFigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.IRulerUpdatable;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.HighlightBorder;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainer;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.swt.graphics.Color;

public class FigureSelectionEditPolicy
extends SelectionEditPolicy {
    public static Color mouseEnterColor = ColorConstants.orange;

    protected void showSelection() {
        EditPart host = this.getHost();
        if (host instanceof IRulerUpdatable) {
            ((IRulerUpdatable)host).updateRulers();
        }
        ANode n = (ANode)this.getHost().getModel();
        List eparts = this.getHost().getParent().getChildren();
        int mindepth = Integer.MAX_VALUE;
        for (EditPart ep : eparts) {
            ANode cn;
            int depth;
            if (!(ep instanceof IContainer) || (depth = n.findParent(cn = (ANode)ep.getModel())) == -1 || mindepth <= depth) continue;
            mindepth = depth;
        }
    }

    protected void hideSelection() {
    }

    protected boolean hasAlreadyColoredBorder(EditPart hostFigure) {
        if (hostFigure instanceof FrameFigureEditPart) {
            return ((FrameFigureEditPart)hostFigure).hasTargetFeedBack();
        }
        return false;
    }

    public void showTargetFeedback(Request request) {
        EditPart host = this.getHost();
        if (host instanceof FigureEditPart && host.getSelected() == 0) {
            if (!this.hasAlreadyColoredBorder((EditPart)((FigureEditPart)host))) {
                ((FigureEditPart)host).getFigure().setBorder((Border)new HighlightBorder(mouseEnterColor, 2));
                super.showTargetFeedback(request);
            } else {
                this.eraseTargetFeedback(request);
            }
        }
    }

    public void eraseTargetFeedback(Request request) {
        EditPart host = this.getHost();
        if (host instanceof FigureEditPart) {
            FigureEditPart feditpart = (FigureEditPart)host;
            feditpart.setPrefsBorder(feditpart.getFigure());
        }
        super.eraseTargetFeedback(request);
    }
}

