/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.handles;

import com.jaspersoft.studio.editor.gef.parts.handles.CellMoveHandleLocator;
import com.jaspersoft.studio.editor.gef.util.GEFUtil;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.handles.MoveHandle;

public class CellMoveHandle
extends MoveHandle {
    public static final int Y_OFFSET = 10;
    private boolean row;
    private boolean col;
    private int offset = 0;
    private static final int LINEWIDTH = 6;
    private static final int VLINEWIDTH = 4;

    public CellMoveHandle(GraphicalEditPart owner, Locator loc) {
        super(owner, loc);
    }

    public CellMoveHandle(GraphicalEditPart owner, boolean row, boolean col) {
        this(owner, (Locator)new CellMoveHandleLocator(owner));
        this.row = row;
        this.col = col;
    }

    public CellMoveHandle(GraphicalEditPart owner, boolean row, boolean col, int offset) {
        this(owner, row, col);
        this.offset = offset;
    }

    protected void initialize() {
        super.initialize();
        this.setOpaque(true);
        this.setBackgroundColor(ColorConstants.lightGray);
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setAlpha(10);
        super.paintFigure(graphics);
    }

    protected void paintBorder(Graphics graphics) {
        graphics.setForegroundColor(ColorConstants.darkGray);
        Rectangle r = this.getBounds().getCopy();
        IFigure ofig = this.getOwner().getFigure();
        Rectangle rown = ofig.getBounds().getCopy();
        if (this.offset != 0) {
            rown = rown.resize(this.offset, this.offset);
        }
        ofig.translateToAbsolute((Translatable)rown);
        IFigure feedback = LayerManager.Helper.find((EditPart)this.getOwner()).getLayer((Object)"Feedback Layer");
        feedback.translateToRelative((Translatable)rown);
        int off2 = 5;
        if (this.row) {
            int y2 = r.y + off2;
            int x1 = rown.x + 2;
            int x2 = rown.x + rown.width - 2 + 1;
            this.drawHBorder(graphics, off2, y2, rown.x + off2, rown.x + rown.width - off2 + 1, x1, x2);
            this.drawHBorder(graphics, off2, r.y + r.height - off2, rown.x + off2, rown.x + rown.width - off2 + 1, x1, x2);
        }
        graphics.drawLine(r.x + off2, rown.y + off2, r.x + off2, rown.y + rown.height - off2 + 1);
        graphics.drawLine(r.x + r.width - off2, rown.y + off2, r.x + r.width - off2, rown.y + rown.height - off2 + 1);
    }

    public void drawHBorder(Graphics graphics, int off2, int y, int xx1, int xx2, int x1, int x2) {
        graphics.setLineWidth(6);
        graphics.drawLine(xx1, y, xx2, y);
        int y1 = y - off2;
        int y2 = y + off2;
        graphics.setLineWidth(4);
        graphics.drawLine(x1, y1, x1, y2);
        graphics.drawLine(x2, y1, x2, y2);
    }

    public boolean containsPoint(int x, int y) {
        if (!this.getBounds().contains(x, y)) {
            return false;
        }
        Rectangle r = this.getBounds().getCopy();
        IFigure ofig = this.getOwner().getFigure();
        Rectangle rown = ofig.getBounds().getCopy();
        ofig.translateToAbsolute((Translatable)rown);
        IFigure feedback = LayerManager.Helper.find((EditPart)this.getOwner()).getLayer((Object)"Feedback Layer");
        feedback.translateToRelative((Translatable)rown);
        int offset = this.getOffset();
        if (this.row && x >= rown.x && x <= rown.x + rown.width && (y <= offset || y >= r.y + r.height - offset)) {
            return true;
        }
        return this.col && y >= rown.y && y <= rown.y + rown.height && (x <= offset || x >= r.x + r.width - offset);
    }

    public int getOffset() {
        return (int)Math.floor(10.0 * GEFUtil.getZoom(this.getOwner()));
    }
}

